/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.sdk.android.tweetui.internal;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Matrix;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.widget.ImageView;

public class MultiTouchImageView
extends ImageView {
    private static final long SCALE_ANIMATION_DURATION = 300L;
    private static final float DOUBLE_TAP_SCALE_FACTOR = 2.0f;
    private static final float MINIMUM_SCALE_FACTOR = 1.0f;
    final ScaleGestureDetector scaleGestureDetector;
    final GestureDetector gestureDetector;
    final Matrix drawMatrix = new Matrix();
    final Matrix baseMatrix = new Matrix();
    final Matrix updateMatrix = new Matrix();
    final RectF viewRect = new RectF();
    final RectF drawRect = new RectF();
    final float[] matrixValues = new float[9];

    public MultiTouchImageView(Context context) {
        this(context, null);
    }

    public MultiTouchImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public MultiTouchImageView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.scaleGestureDetector = new ScaleGestureDetector(context, (ScaleGestureDetector.OnScaleGestureListener)new ScaleGestureDetector.SimpleOnScaleGestureListener(){

            public boolean onScale(ScaleGestureDetector scaleGestureDetector) {
                MultiTouchImageView.this.setScale(scaleGestureDetector.getScaleFactor(), scaleGestureDetector.getFocusX(), scaleGestureDetector.getFocusY());
                MultiTouchImageView.this.setImageMatrix();
                return true;
            }

            public void onScaleEnd(ScaleGestureDetector detector) {
                if (MultiTouchImageView.this.getScale() < 1.0f) {
                    MultiTouchImageView.this.reset();
                    MultiTouchImageView.this.setImageMatrix();
                }
            }
        });
        this.gestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

            public boolean onScroll(MotionEvent e1, MotionEvent e2, float dx, float dy) {
                MultiTouchImageView.this.setTranslate(-dx, -dy);
                MultiTouchImageView.this.setImageMatrix();
                return true;
            }

            public boolean onDoubleTap(MotionEvent e) {
                if (MultiTouchImageView.this.getScale() > 1.0f) {
                    MultiTouchImageView.this.animateScale(MultiTouchImageView.this.getScale(), 1.0f, e.getX(), e.getY());
                } else {
                    MultiTouchImageView.this.animateScale(MultiTouchImageView.this.getScale(), 2.0f, e.getX(), e.getY());
                }
                return true;
            }
        });
    }

    boolean isInitializationComplete() {
        Drawable drawable2 = this.getDrawable();
        return drawable2 != null && drawable2.getIntrinsicWidth() > 0;
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (this.isInitializationComplete()) {
            this.initializeViewRect();
            this.initializeBaseMatrix(this.getDrawable());
            this.setImageMatrix();
        }
    }

    void initializeViewRect() {
        this.viewRect.set((float)this.getPaddingLeft(), (float)this.getPaddingTop(), (float)(this.getWidth() - this.getPaddingRight()), (float)(this.getHeight() - this.getPaddingBottom()));
    }

    void initializeBaseMatrix(Drawable drawable2) {
        int drawableWidth = drawable2.getIntrinsicWidth();
        int drawableHeight = drawable2.getIntrinsicHeight();
        RectF srcRect = new RectF(0.0f, 0.0f, (float)drawableWidth, (float)drawableHeight);
        this.baseMatrix.reset();
        this.baseMatrix.setRectToRect(srcRect, this.viewRect, Matrix.ScaleToFit.CENTER);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.isInitializationComplete()) {
            return false;
        }
        this.getParent().requestDisallowInterceptTouchEvent(true);
        boolean retVal = this.scaleGestureDetector.onTouchEvent(event);
        retVal = this.gestureDetector.onTouchEvent(event) || retVal;
        return retVal || super.onTouchEvent(event);
    }

    void setScale(float ds, float px, float py) {
        this.updateMatrix.postScale(ds, ds, px, py);
    }

    float getScale() {
        this.updateMatrix.getValues(this.matrixValues);
        return this.matrixValues[0];
    }

    void setTranslate(float dx, float dy) {
        this.updateMatrix.postTranslate(dx, dy);
    }

    void reset() {
        this.updateMatrix.reset();
    }

    void updateMatrixBounds() {
        RectF rect = this.getDrawRect(this.getDrawMatrix());
        float dy = 0.0f;
        float dx = 0.0f;
        if (rect.height() <= this.viewRect.height()) {
            dy = (this.viewRect.height() - rect.height()) / 2.0f - rect.top;
        } else if (rect.top > 0.0f) {
            dy = -rect.top;
        } else if (rect.bottom < this.viewRect.height()) {
            dy = this.viewRect.height() - rect.bottom;
        }
        if (rect.width() <= this.viewRect.width()) {
            dx = (this.viewRect.width() - rect.width()) / 2.0f - rect.left;
        } else if (rect.left > 0.0f) {
            dx = -rect.left;
        } else if (rect.right < this.viewRect.width()) {
            dx = this.viewRect.width() - rect.right;
        }
        this.setTranslate(dx, dy);
    }

    RectF getDrawRect(Matrix matrix) {
        Drawable drawable2 = this.getDrawable();
        if (drawable2 != null) {
            this.drawRect.set(0.0f, 0.0f, (float)drawable2.getIntrinsicWidth(), (float)drawable2.getIntrinsicHeight());
            matrix.mapRect(this.drawRect);
        }
        return this.drawRect;
    }

    Matrix getDrawMatrix() {
        this.drawMatrix.set(this.baseMatrix);
        this.drawMatrix.postConcat(this.updateMatrix);
        return this.drawMatrix;
    }

    void setImageMatrix() {
        this.updateMatrixBounds();
        this.setScaleType(ImageView.ScaleType.MATRIX);
        this.setImageMatrix(this.getDrawMatrix());
    }

    void animateScale(float start, float end, float px, float py) {
        if (Build.VERSION.SDK_INT >= 11) {
            this.animateScaleHoneyComb(start, end, px, py);
        } else {
            this.setScale(end / this.getScale(), px, py);
            this.setImageMatrix();
        }
    }

    @TargetApi(value=11)
    void animateScaleHoneyComb(float start, float end, final float px, final float py) {
        ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{start, end});
        animator.setDuration(300L);
        animator.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                float scale = ((Float)valueAnimator.getAnimatedValue()).floatValue();
                float ds = scale / MultiTouchImageView.this.getScale();
                MultiTouchImageView.this.setScale(ds, px, py);
                MultiTouchImageView.this.setImageMatrix();
            }
        });
        animator.start();
    }
}

