/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.sdk.android.tweetui.internal;

import android.os.Build;
import com.twitter.sdk.android.core.models.MediaEntity;
import com.twitter.sdk.android.core.models.Tweet;
import com.twitter.sdk.android.core.models.VideoInfo;
import java.util.ArrayList;
import java.util.List;

public final class TweetMediaUtils {
    public static final String PHOTO_TYPE = "photo";
    public static final String VIDEO_TYPE = "video";
    public static final String GIF_TYPE = "animated_gif";
    private static final String CONTENT_TYPE_MP4 = "video/mp4";
    private static final String CONTENT_TYPE_WEBM = "video/webm";

    private TweetMediaUtils() {
    }

    public static MediaEntity getPhotoEntity(Tweet tweet) {
        List<MediaEntity> mediaEntityList = TweetMediaUtils.getAllMediaEntities(tweet);
        for (int i = mediaEntityList.size() - 1; i >= 0; --i) {
            MediaEntity entity = mediaEntityList.get(i);
            if (entity.type == null || !TweetMediaUtils.isPhotoType(entity)) continue;
            return entity;
        }
        return null;
    }

    public static boolean hasPhoto(Tweet tweet) {
        return TweetMediaUtils.getPhotoEntity(tweet) != null;
    }

    public static MediaEntity getVideoEntity(Tweet tweet) {
        for (MediaEntity mediaEntity : TweetMediaUtils.getAllMediaEntities(tweet)) {
            if (mediaEntity.type == null || !TweetMediaUtils.isVideoType(mediaEntity)) continue;
            return mediaEntity;
        }
        return null;
    }

    public static boolean hasVideo(Tweet tweet) {
        return TweetMediaUtils.getVideoEntity(tweet) != null;
    }

    static boolean isPhotoType(MediaEntity mediaEntity) {
        return PHOTO_TYPE.equals(mediaEntity.type);
    }

    static boolean isVideoType(MediaEntity mediaEntity) {
        return VIDEO_TYPE.equals(mediaEntity.type) || GIF_TYPE.equals(mediaEntity.type);
    }

    public static VideoInfo.Variant getSupportedVariant(MediaEntity mediaEntity) {
        for (VideoInfo.Variant variant : mediaEntity.videoInfo.variants) {
            if (!TweetMediaUtils.isVariantSupported(variant)) continue;
            return variant;
        }
        return null;
    }

    public static boolean isLooping(MediaEntity mediaEntity) {
        return GIF_TYPE.equals(mediaEntity.type);
    }

    static boolean isVariantSupported(VideoInfo.Variant variant) {
        if (CONTENT_TYPE_MP4.equals(variant.contentType)) {
            return true;
        }
        return Build.VERSION.SDK_INT >= 19 && CONTENT_TYPE_WEBM.equals(variant.contentType);
    }

    static List<MediaEntity> getAllMediaEntities(Tweet tweet) {
        ArrayList<MediaEntity> entities = new ArrayList<MediaEntity>();
        if (tweet.entities != null && tweet.entities.media != null) {
            entities.addAll(tweet.entities.media);
        }
        if (tweet.extendedEtities != null && tweet.extendedEtities.media != null) {
            entities.addAll(tweet.extendedEtities.media);
        }
        return entities;
    }
}

