/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.sdk.android.tweetui.internal;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.SeekBar;
import android.widget.TextView;
import com.twitter.sdk.android.tweetui.R;
import com.twitter.sdk.android.tweetui.internal.AnimationUtils;
import com.twitter.sdk.android.tweetui.internal.MediaTimeUtils;

public class VideoControlView
extends FrameLayout {
    static final long PROGRESS_BAR_TICKS = 1000L;
    static final int FADE_DURATION_MS = 150;
    private static final int SHOW_PROGRESS_MSG = 1001;
    MediaPlayerControl player;
    ImageButton stateControl;
    TextView currentTime;
    TextView duration;
    SeekBar seekBar;
    @SuppressLint(value={"HandlerLeak"})
    private final Handler handler = new Handler(){

        public void handleMessage(Message msg) {
            if (msg.what == 1001) {
                VideoControlView.this.updateProgress();
                VideoControlView.this.updateStateControl();
                if (VideoControlView.this.isShowing() && VideoControlView.this.player.isPlaying()) {
                    msg = this.obtainMessage(1001);
                    this.sendMessageDelayed(msg, 500L);
                }
            }
        }
    };

    public VideoControlView(Context context) {
        super(context);
    }

    public VideoControlView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public VideoControlView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public void setMediaPlayer(MediaPlayerControl player) {
        this.player = player;
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.initSubviews();
    }

    void initSubviews() {
        LayoutInflater inflater = (LayoutInflater)this.getContext().getSystemService("layout_inflater");
        inflater.inflate(R.layout.tw__video_control, (ViewGroup)this);
        this.stateControl = (ImageButton)this.findViewById(R.id.tw__state_control);
        this.currentTime = (TextView)this.findViewById(R.id.tw__current_time);
        this.duration = (TextView)this.findViewById(R.id.tw__duration);
        this.seekBar = (SeekBar)this.findViewById(R.id.tw__progress);
        this.seekBar.setMax(1000);
        this.seekBar.setOnSeekBarChangeListener(this.createProgressChangeListener());
        this.stateControl.setOnClickListener(this.createStateControlClickListener());
        this.setDuration(0);
        this.setCurrentTime(0);
        this.setProgress(0, 0, 0);
    }

    View.OnClickListener createStateControlClickListener() {
        return new View.OnClickListener(){

            public void onClick(View view) {
                if (VideoControlView.this.player.isPlaying()) {
                    VideoControlView.this.player.pause();
                } else {
                    VideoControlView.this.player.start();
                }
                VideoControlView.this.show();
            }
        };
    }

    SeekBar.OnSeekBarChangeListener createProgressChangeListener() {
        return new SeekBar.OnSeekBarChangeListener(){

            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                if (!fromUser) {
                    return;
                }
                int duration = VideoControlView.this.player.getDuration();
                long position = (long)(duration * progress) / 1000L;
                VideoControlView.this.player.seekTo((int)position);
                VideoControlView.this.setCurrentTime((int)position);
            }

            public void onStartTrackingTouch(SeekBar seekBar) {
                VideoControlView.this.handler.removeMessages(1001);
            }

            public void onStopTrackingTouch(SeekBar seekBar) {
                VideoControlView.this.updateStateControl();
                VideoControlView.this.handler.sendEmptyMessage(1001);
            }
        };
    }

    void updateProgress() {
        int duration = this.player.getDuration();
        int currentTime = this.player.getCurrentPosition();
        int bufferPercentage = this.player.getBufferPercentage();
        this.setDuration(duration);
        this.setCurrentTime(currentTime);
        this.setProgress(currentTime, duration, bufferPercentage);
    }

    void setDuration(int durationMillis) {
        this.duration.setText((CharSequence)MediaTimeUtils.getPlaybackTime(durationMillis));
    }

    void setCurrentTime(int currentTimeMillis) {
        this.currentTime.setText((CharSequence)MediaTimeUtils.getPlaybackTime(currentTimeMillis));
    }

    void setProgress(int currentTimeMillis, int durationMillis, int bufferPercentage) {
        long pos = durationMillis > 0 ? 1000L * (long)currentTimeMillis / (long)durationMillis : 0L;
        this.seekBar.setProgress((int)pos);
        this.seekBar.setSecondaryProgress(bufferPercentage * 10);
    }

    void updateStateControl() {
        if (this.player.isPlaying()) {
            this.setPauseDrawable();
        } else if (this.player.getCurrentPosition() >= this.player.getDuration() - 500) {
            this.setReplayDrawable();
        } else {
            this.setPlayDrawable();
        }
    }

    void setPlayDrawable() {
        this.stateControl.setImageResource(R.drawable.tw__video_play_btn);
        this.stateControl.setContentDescription((CharSequence)this.getContext().getString(R.string.tw__play));
    }

    void setPauseDrawable() {
        this.stateControl.setImageResource(R.drawable.tw__video_pause_btn);
        this.stateControl.setContentDescription((CharSequence)this.getContext().getString(R.string.tw__pause));
    }

    void setReplayDrawable() {
        this.stateControl.setImageResource(R.drawable.tw__video_replay_btn);
        this.stateControl.setContentDescription((CharSequence)this.getContext().getString(R.string.tw__replay));
    }

    void hide() {
        this.handler.removeMessages(1001);
        if (Build.VERSION.SDK_INT >= 12) {
            AnimationUtils.fadeOut((View)this, 150);
        } else {
            this.setVisibility(4);
        }
    }

    void show() {
        this.handler.sendEmptyMessage(1001);
        this.updateStateControl();
        if (Build.VERSION.SDK_INT >= 12) {
            AnimationUtils.fadeIn((View)this, 150);
        } else {
            this.setVisibility(0);
        }
    }

    public boolean isShowing() {
        return this.getVisibility() == 0;
    }

    public static interface MediaPlayerControl {
        public void start();

        public void pause();

        public int getDuration();

        public int getCurrentPosition();

        public void seekTo(int var1);

        public boolean isPlaying();

        public int getBufferPercentage();

        public boolean canPause();

        public boolean canSeekBackward();

        public boolean canSeekForward();

        public int getAudioSessionId();
    }
}

