/*
 * Decompiled with CFR 0.152.
 */
package com.uber.autodispose.android.lifecycle;

import android.arch.lifecycle.Lifecycle;
import android.arch.lifecycle.LifecycleOwner;
import com.uber.autodispose.LifecycleEndedException;
import com.uber.autodispose.LifecycleScopeProvider;
import com.uber.autodispose.android.lifecycle.LifecycleEventsObservable;
import io.reactivex.Observable;
import io.reactivex.functions.Function;

public final class AndroidLifecycleScopeProvider
implements LifecycleScopeProvider<Lifecycle.Event> {
    private static final Function<Lifecycle.Event, Lifecycle.Event> CORRESPONDING_EVENTS = new Function<Lifecycle.Event, Lifecycle.Event>(){

        public Lifecycle.Event apply(Lifecycle.Event lastEvent) throws Exception {
            switch (lastEvent) {
                case ON_CREATE: {
                    return Lifecycle.Event.ON_DESTROY;
                }
                case ON_START: {
                    return Lifecycle.Event.ON_STOP;
                }
                case ON_RESUME: {
                    return Lifecycle.Event.ON_PAUSE;
                }
                case ON_PAUSE: {
                    return Lifecycle.Event.ON_STOP;
                }
            }
            throw new LifecycleEndedException();
        }
    };
    private final LifecycleEventsObservable lifecycleObservable;

    public static AndroidLifecycleScopeProvider from(LifecycleOwner owner) {
        return AndroidLifecycleScopeProvider.from(owner.getLifecycle());
    }

    public static AndroidLifecycleScopeProvider from(Lifecycle lifecycle) {
        return new AndroidLifecycleScopeProvider(lifecycle);
    }

    private AndroidLifecycleScopeProvider(Lifecycle lifecycle) {
        this.lifecycleObservable = new LifecycleEventsObservable(lifecycle);
    }

    public Observable<Lifecycle.Event> lifecycle() {
        return this.lifecycleObservable;
    }

    public Function<Lifecycle.Event, Lifecycle.Event> correspondingEvents() {
        return CORRESPONDING_EVENTS;
    }

    public Lifecycle.Event peekLifecycle() {
        return this.lifecycleObservable.getValue();
    }
}

