/*
 * Decompiled with CFR 0.152.
 */
package com.uber.autodispose.android.lifecycle;

import android.arch.lifecycle.Lifecycle;
import android.arch.lifecycle.LifecycleObserver;
import android.arch.lifecycle.LifecycleOwner;
import android.arch.lifecycle.OnLifecycleEvent;
import android.support.annotation.RestrictTo;
import com.uber.autodispose.android.internal.AutoDisposeAndroidUtil;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.android.MainThreadDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.subjects.BehaviorSubject;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
class LifecycleEventsObservable
extends Observable<Lifecycle.Event> {
    private final Lifecycle lifecycle;
    private final BehaviorSubject<Lifecycle.Event> eventsObservable = BehaviorSubject.create();

    LifecycleEventsObservable(Lifecycle lifecycle) {
        Lifecycle.Event correspondingEvent;
        this.lifecycle = lifecycle;
        switch (lifecycle.getCurrentState()) {
            case INITIALIZED: {
                correspondingEvent = Lifecycle.Event.ON_CREATE;
                break;
            }
            case CREATED: {
                correspondingEvent = Lifecycle.Event.ON_START;
                break;
            }
            case STARTED: 
            case RESUMED: {
                correspondingEvent = Lifecycle.Event.ON_RESUME;
                break;
            }
            default: {
                correspondingEvent = Lifecycle.Event.ON_DESTROY;
            }
        }
        this.eventsObservable.onNext((Object)correspondingEvent);
    }

    Lifecycle.Event getValue() {
        return (Lifecycle.Event)this.eventsObservable.getValue();
    }

    protected void subscribeActual(Observer<? super Lifecycle.Event> observer) {
        if (!AutoDisposeAndroidUtil.isMainThread()) {
            observer.onError((Throwable)new IllegalStateException("Lifecycles can only be bound to on the main thread!"));
            return;
        }
        ArchLifecycleObserver archObserver = new ArchLifecycleObserver(this.lifecycle, observer, this.eventsObservable);
        observer.onSubscribe((Disposable)archObserver);
        this.lifecycle.addObserver((LifecycleObserver)archObserver);
    }

    static final class ArchLifecycleObserver
    extends MainThreadDisposable
    implements LifecycleObserver {
        private final Lifecycle lifecycle;
        private final Observer<? super Lifecycle.Event> observer;
        private final BehaviorSubject<Lifecycle.Event> eventsObservable;

        ArchLifecycleObserver(Lifecycle lifecycle, Observer<? super Lifecycle.Event> observer, BehaviorSubject<Lifecycle.Event> eventsObservable) {
            this.lifecycle = lifecycle;
            this.observer = observer;
            this.eventsObservable = eventsObservable;
        }

        protected void onDispose() {
            this.lifecycle.removeObserver((LifecycleObserver)this);
        }

        @OnLifecycleEvent(value=Lifecycle.Event.ON_ANY)
        void onStateChange(LifecycleOwner owner, Lifecycle.Event event) {
            if (!this.isDisposed()) {
                if (event != Lifecycle.Event.ON_CREATE || this.eventsObservable.getValue() != event) {
                    this.eventsObservable.onNext((Object)event);
                }
                this.observer.onNext((Object)event);
            }
        }
    }
}

