/*
 * Decompiled with CFR 0.152.
 */
package com.uber.autodispose.android.lifecycle;

import android.arch.lifecycle.Lifecycle;
import android.arch.lifecycle.LifecycleOwner;
import android.arch.lifecycle.LifecycleRegistry;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;

@RestrictTo(value={RestrictTo.Scope.TESTS})
public final class TestAndroidLifecycleScopeProvider
implements LifecycleOwner {
    private final LifecycleRegistry registry;

    public TestAndroidLifecycleScopeProvider() {
        this(null);
    }

    public TestAndroidLifecycleScopeProvider(@Nullable LifecycleRegistry registry) {
        this.registry = registry == null ? new LifecycleRegistry((LifecycleOwner)this) : registry;
    }

    public LifecycleRegistry getLifecycle() {
        return this.registry;
    }

    public void emit(Lifecycle.Event event) {
        this.registry.handleLifecycleEvent(event);
        switch (event) {
            case ON_CREATE: {
                this.registry.markState(Lifecycle.State.CREATED);
                break;
            }
            case ON_START: {
                this.registry.markState(Lifecycle.State.STARTED);
                break;
            }
            case ON_RESUME: {
                this.registry.markState(Lifecycle.State.RESUMED);
                break;
            }
            case ON_PAUSE: 
            case ON_STOP: 
            case ON_DESTROY: {
                this.registry.markState(Lifecycle.State.DESTROYED);
                break;
            }
            case ON_ANY: {
                throw new IllegalArgumentException("Event#ON_ANY is not a valid event to the emit() method.");
            }
        }
    }
}

