/*
 * Decompiled with CFR 0.152.
 */
package com.uber.autodispose.android.lifecycle;

import android.arch.lifecycle.Lifecycle;
import android.arch.lifecycle.LifecycleOwner;
import com.uber.autodispose.LifecycleEndedException;
import com.uber.autodispose.LifecycleScopeProvider;
import com.uber.autodispose.android.lifecycle.LifecycleEventsObservable;
import io.reactivex.Observable;
import io.reactivex.functions.Function;

public final class AndroidLifecycleScopeProvider
implements LifecycleScopeProvider<Lifecycle.Event> {
    private static final Function<Lifecycle.Event, Lifecycle.Event> DEFAULT_CORRESPONDING_EVENTS = new Function<Lifecycle.Event, Lifecycle.Event>(){

        public Lifecycle.Event apply(Lifecycle.Event lastEvent) throws Exception {
            switch (lastEvent) {
                case ON_CREATE: {
                    return Lifecycle.Event.ON_DESTROY;
                }
                case ON_START: {
                    return Lifecycle.Event.ON_STOP;
                }
                case ON_RESUME: {
                    return Lifecycle.Event.ON_PAUSE;
                }
                case ON_PAUSE: {
                    return Lifecycle.Event.ON_STOP;
                }
            }
            throw new LifecycleEndedException("Lifecycle has ended! Last event was " + lastEvent);
        }
    };
    private final Function<Lifecycle.Event, Lifecycle.Event> boundaryResolver;
    private final LifecycleEventsObservable lifecycleObservable;

    public static AndroidLifecycleScopeProvider from(LifecycleOwner owner) {
        return AndroidLifecycleScopeProvider.from(owner.getLifecycle());
    }

    public static AndroidLifecycleScopeProvider from(LifecycleOwner owner, Lifecycle.Event untilEvent) {
        return AndroidLifecycleScopeProvider.from(owner.getLifecycle(), untilEvent);
    }

    public static AndroidLifecycleScopeProvider from(Lifecycle lifecycle) {
        return AndroidLifecycleScopeProvider.from(lifecycle, DEFAULT_CORRESPONDING_EVENTS);
    }

    public static AndroidLifecycleScopeProvider from(Lifecycle lifecycle, Lifecycle.Event untilEvent) {
        return AndroidLifecycleScopeProvider.from(lifecycle, (Function<Lifecycle.Event, Lifecycle.Event>)new UntilEventFunction(untilEvent));
    }

    public static AndroidLifecycleScopeProvider from(LifecycleOwner owner, Function<Lifecycle.Event, Lifecycle.Event> boundaryResolver) {
        return AndroidLifecycleScopeProvider.from(owner.getLifecycle(), boundaryResolver);
    }

    public static AndroidLifecycleScopeProvider from(Lifecycle lifecycle, Function<Lifecycle.Event, Lifecycle.Event> boundaryResolver) {
        return new AndroidLifecycleScopeProvider(lifecycle, boundaryResolver);
    }

    private AndroidLifecycleScopeProvider(Lifecycle lifecycle, Function<Lifecycle.Event, Lifecycle.Event> boundaryResolver) {
        this.lifecycleObservable = new LifecycleEventsObservable(lifecycle);
        this.boundaryResolver = boundaryResolver;
    }

    public Observable<Lifecycle.Event> lifecycle() {
        return this.lifecycleObservable;
    }

    public Function<Lifecycle.Event, Lifecycle.Event> correspondingEvents() {
        return this.boundaryResolver;
    }

    public Lifecycle.Event peekLifecycle() {
        this.lifecycleObservable.backfillEvents();
        return this.lifecycleObservable.getValue();
    }

    private static class UntilEventFunction
    implements Function<Lifecycle.Event, Lifecycle.Event> {
        private final Lifecycle.Event untilEvent;

        UntilEventFunction(Lifecycle.Event untilEvent) {
            this.untilEvent = untilEvent;
        }

        public Lifecycle.Event apply(Lifecycle.Event event) throws Exception {
            return this.untilEvent;
        }
    }
}

