/*
 * Decompiled with CFR 0.152.
 */
package com.efs.sdk.base.newsharedpreferences;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Log;
import com.efs.sdk.base.newsharedpreferences.SharedPreferencesNewImpl;
import java.io.File;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class SharedPreferencesUtils {
    private static final HashMap<String, SharedPreferencesWrapper> sSpCache = new HashMap();

    public static SharedPreferences getSharedPreferences(Context context, String string) {
        return SharedPreferencesUtils.getSharedPreferences(context, string, false);
    }

    public static SharedPreferences getSharedPreferences(Context context, String string, boolean bl) {
        return SharedPreferencesUtils.getNewSharedPreferences(context, string, bl);
    }

    private static SharedPreferences getNewSharedPreferences(Context context, String string, boolean bl) {
        return SharedPreferencesUtils.getNewSharedPreferences(context, string, bl, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SharedPreferences getNewSharedPreferences(Context context, String string, boolean bl, boolean bl2) {
        SharedPreferencesWrapper sharedPreferencesWrapper;
        Object object = sSpCache;
        synchronized (object) {
            sharedPreferencesWrapper = sSpCache.get(string);
            if (sharedPreferencesWrapper == null) {
                sharedPreferencesWrapper = new SharedPreferencesWrapper();
                sSpCache.put(string, sharedPreferencesWrapper);
            }
        }
        if (sharedPreferencesWrapper.mSharedPreferences == null) {
            object = sharedPreferencesWrapper;
            synchronized (object) {
                if (sharedPreferencesWrapper.mSharedPreferences == null && sharedPreferencesWrapper.mSharedPreferences == null) {
                    sharedPreferencesWrapper.mSharedPreferences = new SharedPreferencesNewImpl(SharedPreferencesUtils.getNewSharedPrefsFile(context, string), bl);
                }
            }
        }
        return sharedPreferencesWrapper.mSharedPreferences;
    }

    public static File getNewSharedPrefsFile(Context context, String string) {
        return new File(context.getApplicationInfo().dataDir, "shared_prefs" + File.separatorChar + string + ".sp");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onDestroy() {
        HashMap<String, SharedPreferencesWrapper> hashMap = sSpCache;
        synchronized (hashMap) {
            if (sSpCache.size() > 0) {
                Iterator<SharedPreferencesWrapper> iterator = sSpCache.values().iterator();
                while (iterator.hasNext()) {
                    SharedPreferences sharedPreferences = iterator.next().mSharedPreferences;
                    if (sharedPreferences == null) continue;
                    ((SharedPreferencesNewImpl)sharedPreferences).onDestroy();
                }
            }
            return;
        }
    }

    private static synchronized void handleReplace(Context object, String string, boolean bl) {
        if (object == null) {
            return;
        }
        SharedPreferences sharedPreferences = SharedPreferencesUtils.getNewSharedPreferences((Context)object, "sp_replace_flag", bl, true);
        if (!sharedPreferences.contains(string)) {
            SharedPreferences object22 = SharedPreferencesUtils.getNewSharedPreferences((Context)object, string, bl, true);
            SharedPreferences.Editor editor = object22.edit();
            if (((SharedPreferencesNewImpl)object22).getModifyID() <= 1) {
                object = object.getSharedPreferences(string, 0).getAll();
                Log.e((String)"caisq", (String)("replace " + string + "   " + object.size() + "   " + object22.hashCode()));
                if (object.size() > 0) {
                    for (Map.Entry entry : object.entrySet()) {
                        String string2 = (String)entry.getKey();
                        Object v = entry.getValue();
                        if (string2 == null || string2.trim().length() <= 0 || v == null) continue;
                        if (v instanceof String) {
                            editor.putString(string2, (String)v);
                            continue;
                        }
                        if (v instanceof Long) {
                            editor.putLong(string2, ((Long)v).longValue());
                            continue;
                        }
                        if (v instanceof Integer) {
                            editor.putInt(string2, ((Integer)v).intValue());
                            continue;
                        }
                        if (v instanceof Float) {
                            editor.putFloat(string2, ((Float)v).floatValue());
                            continue;
                        }
                        if (!(v instanceof Boolean)) continue;
                        editor.putBoolean(string2, ((Boolean)v).booleanValue());
                    }
                    editor.apply();
                }
            }
            sharedPreferences.edit().putBoolean(string, true).apply();
        }
    }

    private static Object invokeObjectMethod(Object object, String object2, Class[] classArray, Object[] objectArray) {
        Object object3 = null;
        try {
            object2 = object.getClass().getMethod((String)object2, classArray);
            ((Method)object2).setAccessible(true);
            object3 = ((Method)object2).invoke(object, objectArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return object3;
    }

    static class SharedPreferencesWrapper {
        private volatile SharedPreferences mSharedPreferences;

        private SharedPreferencesWrapper() {
        }
    }
}

