/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.ads.token;

import com.unity3d.services.ads.token.TokenEvent;
import com.unity3d.services.core.webview.WebViewApp;
import com.unity3d.services.core.webview.WebViewEventCategory;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.json.JSONArray;
import org.json.JSONException;

public class TokenStorage {
    private static ConcurrentLinkedQueue<String> _queue;
    private static int _accessCounter;
    private static boolean _peekMode;

    public static synchronized void createTokens(JSONArray tokens) throws JSONException {
        _queue = new ConcurrentLinkedQueue();
        _accessCounter = 0;
        for (int i = 0; i < tokens.length(); ++i) {
            _queue.add(tokens.getString(i));
        }
    }

    public static synchronized void appendTokens(JSONArray tokens) throws JSONException {
        if (_queue == null) {
            _queue = new ConcurrentLinkedQueue();
            _accessCounter = 0;
        }
        for (int i = 0; i < tokens.length(); ++i) {
            _queue.add(tokens.getString(i));
        }
    }

    public static synchronized void deleteTokens() {
        _queue = null;
        _accessCounter = 0;
    }

    public static synchronized String getToken() {
        if (_queue == null) {
            return null;
        }
        if (_queue.isEmpty()) {
            WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.TOKEN, TokenEvent.QUEUE_EMPTY, new Object[0]);
            return null;
        }
        if (_peekMode) {
            WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.TOKEN, TokenEvent.TOKEN_ACCESS, _accessCounter++);
            return _queue.peek();
        }
        WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.TOKEN, TokenEvent.TOKEN_ACCESS, _accessCounter++);
        return _queue.poll();
    }

    public static synchronized void setPeekMode(boolean mode) {
        _peekMode = mode;
    }

    static {
        _accessCounter = 0;
        _peekMode = false;
    }
}

