/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.configuration;

import android.text.TextUtils;
import com.unity3d.services.core.configuration.IModuleConfiguration;
import com.unity3d.services.core.log.DeviceLog;
import com.unity3d.services.core.properties.SdkProperties;
import com.unity3d.services.core.request.WebRequest;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class Configuration {
    private String _webViewUrl;
    private String _webViewHash;
    private String _webViewVersion;
    private String _webViewData;
    private String _sdkVersion;
    private boolean _delayWebViewUpdate;
    private int _resetWebAppTimeout;
    private int _maxRetries;
    private long _retryDelay;
    private double _retryScalingFactor;
    private int _connectedEventThresholdInMs;
    private int _maximumConnectedEvents;
    private long _networkErrorTimeout;
    private int _showTimeout;
    private int _loadTimeout;
    private int _webViewBridgeTimeout;
    private String _metricsUrl;
    private double _metricSampleRate;
    private long _webViewAppCreateTimeout;
    private String _configJsonString;
    private String _configUrl;
    private Map<String, IModuleConfiguration> _moduleConfigurations;
    private String[] _moduleConfigurationList = new String[]{"com.unity3d.services.core.configuration.CoreModuleConfiguration", "com.unity3d.services.ads.configuration.AdsModuleConfiguration", "com.unity3d.services.monetization.core.configuration.MonetizationModuleConfiguration", "com.unity3d.services.purchasing.core.configuration.PurchasingModuleConfiguration", "com.unity3d.services.analytics.core.configuration.AnalyticsModuleConfiguration", "com.unity3d.services.ar.configuration.ARModuleConfiguration", "com.unity3d.services.banners.configuration.BannersModuleConfiguration", "com.unity3d.services.store.core.configuration.StoreModuleConfiguration"};
    private Class[] _webAppApiClassList;

    public Configuration() {
        this.setOptionalFields(new JSONObject());
    }

    public Configuration(String configUrl) {
        this._configUrl = configUrl;
        this.setOptionalFields(new JSONObject());
    }

    public Configuration(JSONObject configData) throws MalformedURLException {
        this.handleConfigurationData(configData);
    }

    public String getConfigUrl() {
        return this._configUrl;
    }

    public Class[] getWebAppApiClassList() {
        if (this._webAppApiClassList == null) {
            this.createWebAppApiClassList();
        }
        return this._webAppApiClassList;
    }

    public String[] getModuleConfigurationList() {
        return this._moduleConfigurationList;
    }

    public String getWebViewUrl() {
        return this._webViewUrl;
    }

    public void setWebViewUrl(String url) {
        this._webViewUrl = url;
    }

    public String getWebViewHash() {
        return this._webViewHash;
    }

    public void setWebViewHash(String hash) {
        this._webViewHash = hash;
    }

    public String getWebViewVersion() {
        return this._webViewVersion;
    }

    public String getWebViewData() {
        return this._webViewData;
    }

    public void setWebViewData(String data) {
        this._webViewData = data;
    }

    public String getSdkVersion() {
        return this._sdkVersion;
    }

    public boolean getDelayWebViewUpdate() {
        return this._delayWebViewUpdate;
    }

    public int getResetWebappTimeout() {
        return this._resetWebAppTimeout;
    }

    public int getMaxRetries() {
        return this._maxRetries;
    }

    public long getRetryDelay() {
        return this._retryDelay;
    }

    public double getRetryScalingFactor() {
        return this._retryScalingFactor;
    }

    public int getConnectedEventThreshold() {
        return this._connectedEventThresholdInMs;
    }

    public int getMaximumConnectedEvents() {
        return this._maximumConnectedEvents;
    }

    public long getNetworkErrorTimeout() {
        return this._networkErrorTimeout;
    }

    public int getShowTimeout() {
        return this._showTimeout;
    }

    public int getLoadTimeout() {
        return this._loadTimeout;
    }

    public int getWebViewBridgeTimeout() {
        return this._webViewBridgeTimeout;
    }

    public String getMetricsUrl() {
        return this._metricsUrl;
    }

    public double getMetricSampleRate() {
        return this._metricSampleRate;
    }

    public long getWebViewAppCreateTimeout() {
        return this._webViewAppCreateTimeout;
    }

    public IModuleConfiguration getModuleConfiguration(String moduleName) {
        if (this._moduleConfigurations != null && this._moduleConfigurations.containsKey(moduleName)) {
            return this._moduleConfigurations.get(moduleName);
        }
        try {
            IModuleConfiguration module = (IModuleConfiguration)Class.forName(moduleName).newInstance();
            if (module != null) {
                if (this._moduleConfigurations == null) {
                    this._moduleConfigurations = new HashMap<String, IModuleConfiguration>();
                    this._moduleConfigurations.put(moduleName, module);
                }
                return module;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getJSONString() {
        return this._configJsonString;
    }

    protected String buildQueryString() {
        return "?ts=" + System.currentTimeMillis() + "&sdkVersion=" + SdkProperties.getVersionCode() + "&sdkVersionName=" + SdkProperties.getVersionName();
    }

    protected void makeRequest() throws Exception {
        if (this._configUrl == null) {
            throw new MalformedURLException("Base URL is null");
        }
        String url = this._configUrl + this.buildQueryString();
        DeviceLog.debug("Requesting configuration with: " + url);
        WebRequest request = new WebRequest(url, "GET", null);
        String data = request.makeRequest();
        this.handleConfigurationData(new JSONObject(data));
    }

    private void handleConfigurationData(JSONObject configData) throws MalformedURLException {
        String url = null;
        try {
            url = !configData.isNull("url") ? configData.getString("url") : null;
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        if (TextUtils.isEmpty(url)) {
            throw new MalformedURLException("WebView URL is null or empty");
        }
        this._webViewUrl = url;
        try {
            this._webViewHash = !configData.isNull("hash") ? configData.getString("hash") : null;
        }
        catch (JSONException e) {
            this._webViewHash = null;
        }
        this.setOptionalFields(configData);
        this._configJsonString = configData.toString();
    }

    private void setOptionalFields(JSONObject configData) {
        this._webViewVersion = configData.optString("version", null);
        this._delayWebViewUpdate = configData.optBoolean("dwu", false);
        this._resetWebAppTimeout = configData.optInt("rwt", 10000);
        this._maxRetries = configData.optInt("mr", 6);
        this._retryDelay = configData.optLong("rd", 5000L);
        this._retryScalingFactor = configData.optDouble("rcf", 2.0);
        this._connectedEventThresholdInMs = configData.optInt("cet", 10000);
        this._maximumConnectedEvents = configData.optInt("mce", 500);
        this._networkErrorTimeout = configData.optLong("net", 60000L);
        this._sdkVersion = configData.optString("sdkv", "");
        this._showTimeout = configData.optInt("sto", 10000);
        this._loadTimeout = configData.optInt("lto", 30000);
        this._webViewBridgeTimeout = configData.optInt("wto", 5000);
        this._metricsUrl = configData.optString("murl", "");
        this._metricSampleRate = configData.optDouble("msr", 100.0);
        this._webViewAppCreateTimeout = configData.optLong("wct", 60000L);
    }

    private void createWebAppApiClassList() {
        ArrayList<Class> apiList = new ArrayList<Class>();
        for (String moduleConfigClass : this.getModuleConfigurationList()) {
            IModuleConfiguration moduleConfiguration = this.getModuleConfiguration(moduleConfigClass);
            if (moduleConfiguration == null || moduleConfiguration.getWebAppApiClassList() == null) continue;
            apiList.addAll(Arrays.asList(moduleConfiguration.getWebAppApiClassList()));
        }
        this._webAppApiClassList = apiList.toArray(new Class[apiList.size()]);
    }
}

