/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.webview;

import android.os.Build;
import android.os.ConditionVariable;
import android.os.Looper;
import android.view.View;
import android.webkit.RenderProcessGoneDetail;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebViewClient;
import com.unity3d.services.ads.api.AdUnit;
import com.unity3d.services.core.configuration.Configuration;
import com.unity3d.services.core.configuration.InitializeThread;
import com.unity3d.services.core.log.DeviceLog;
import com.unity3d.services.core.misc.Utilities;
import com.unity3d.services.core.misc.ViewUtilities;
import com.unity3d.services.core.properties.ClientProperties;
import com.unity3d.services.core.properties.SdkProperties;
import com.unity3d.services.core.request.SDKMetrics;
import com.unity3d.services.core.webview.WebView;
import com.unity3d.services.core.webview.bridge.CallbackStatus;
import com.unity3d.services.core.webview.bridge.IWebViewBridgeInvoker;
import com.unity3d.services.core.webview.bridge.Invocation;
import com.unity3d.services.core.webview.bridge.NativeCallback;
import com.unity3d.services.core.webview.bridge.WebViewBridge;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.json.JSONArray;
import org.json.JSONException;

public class WebViewApp
implements IWebViewBridgeInvoker {
    private static WebViewApp _currentApp;
    private static ConditionVariable _conditionVariable;
    private static final int INVOKE_JS_CHARS_LENGTH = 22;
    private boolean _webAppLoaded = false;
    private WebView _webView;
    private Configuration _configuration;
    private HashMap<String, NativeCallback> _nativeCallbacks;
    private static AtomicReference<Boolean> _initialized;
    private static AtomicReference<String> _webAppFailureMessage;
    private static AtomicReference<Integer> _webAppFailureCode;

    private WebViewApp(Configuration configuration) {
        this.setConfiguration(configuration);
        WebViewBridge.setClassTable(this.getConfiguration().getWebAppApiClassList());
        this._webView = new WebView(ClientProperties.getApplicationContext());
        this._webView.setWebViewClient(new WebAppClient());
        this._webView.setWebChromeClient(new WebAppChromeClient());
    }

    public WebViewApp() {
    }

    public void setWebAppLoaded(boolean loaded) {
        this._webAppLoaded = loaded;
    }

    public boolean isWebAppLoaded() {
        return this._webAppLoaded;
    }

    public void setWebAppFailureMessage(String message) {
        _webAppFailureMessage.set(message);
    }

    public void setWebAppFailureCode(int code) {
        _webAppFailureCode.set(code);
    }

    public String getWebAppFailureMessage() {
        return _webAppFailureMessage.get();
    }

    public int getWebAppFailureCode() {
        return _webAppFailureCode.get();
    }

    public void setWebAppInitialized(boolean initialized) {
        _initialized.set(initialized);
        _conditionVariable.open();
    }

    public void resetWebViewAppInitialization() {
        this._webAppLoaded = false;
        _webAppFailureCode.set(-1);
        _webAppFailureMessage.set("");
        _initialized.set(false);
    }

    public boolean isWebAppInitialized() {
        return _initialized.get();
    }

    public WebView getWebView() {
        return this._webView;
    }

    public void setWebView(WebView webView) {
        this._webView = webView;
    }

    public Configuration getConfiguration() {
        return this._configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this._configuration = configuration;
    }

    private void invokeJavascriptMethod(String className, String methodName, JSONArray params) throws JSONException {
        String paramsString = params.toString();
        int stringLength = 22 + className.length() + methodName.length() + paramsString.length();
        StringBuilder sb = new StringBuilder(stringLength);
        sb.append("javascript:window.");
        sb.append(className);
        sb.append(".");
        sb.append(methodName);
        sb.append("(");
        sb.append(paramsString);
        sb.append(");");
        String javaScriptString = sb.toString();
        DeviceLog.debug("Invoking javascript: " + javaScriptString);
        this.getWebView().invokeJavascript(javaScriptString);
    }

    public boolean sendEvent(Enum eventCategory, Enum eventId, Object ... params) {
        if (!this.isWebAppLoaded()) {
            DeviceLog.debug("sendEvent ignored because web app is not loaded");
            return false;
        }
        JSONArray paramList = new JSONArray();
        paramList.put((Object)eventCategory.name());
        paramList.put((Object)eventId.name());
        for (Object o : params) {
            paramList.put(o);
        }
        try {
            this.invokeJavascriptMethod("nativebridge", "handleEvent", paramList);
        }
        catch (Exception e) {
            DeviceLog.exception("Error while sending event to WebView", e);
            return false;
        }
        return true;
    }

    @Override
    public boolean invokeMethod(String className, String methodName, Method callback, Object ... params) {
        if (!this.isWebAppLoaded()) {
            DeviceLog.debug("invokeMethod ignored because web app is not loaded");
            return false;
        }
        JSONArray paramList = new JSONArray();
        paramList.put((Object)className);
        paramList.put((Object)methodName);
        if (callback != null) {
            Object[] nativeCallback = new NativeCallback(callback);
            this.addCallback((NativeCallback)nativeCallback);
            paramList.put((Object)nativeCallback.getId());
        } else {
            paramList.put(null);
        }
        if (params != null) {
            for (Object o : params) {
                paramList.put(o);
            }
        }
        try {
            this.invokeJavascriptMethod("nativebridge", "handleInvocation", paramList);
        }
        catch (Exception e) {
            DeviceLog.exception("Error invoking javascript method", e);
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public boolean invokeCallback(Invocation invocation) {
        if (!this.isWebAppLoaded()) {
            DeviceLog.debug("invokeBatchCallback ignored because web app is not loaded");
            return false;
        }
        JSONArray responseList = new JSONArray();
        ArrayList<ArrayList<Object>> responses = invocation.getResponses();
        if (responses != null && !responses.isEmpty()) {
            for (ArrayList<Object> response : responses) {
                void var14_17;
                CallbackStatus status = (CallbackStatus)((Object)response.get(0));
                Enum error = (Enum)response.get(1);
                Object[] params = (Object[])response.get(2);
                String callbackId = (String)params[0];
                params = Arrays.copyOfRange(params, 1, params.length);
                ArrayList<String> tmp = new ArrayList<String>();
                tmp.add(callbackId);
                tmp.add(status.toString());
                JSONArray paramArray = new JSONArray();
                if (error != null) {
                    paramArray.put((Object)error.name());
                }
                Object[] objectArray = params;
                int n = objectArray.length;
                boolean bl = false;
                while (var14_17 < n) {
                    Object o = objectArray[var14_17];
                    paramArray.put(o);
                    ++var14_17;
                }
                tmp.add((String)paramArray);
                JSONArray paramList = new JSONArray();
                for (Object e : tmp) {
                    paramList.put(e);
                }
                responseList.put((Object)paramList);
            }
        }
        try {
            this.invokeJavascriptMethod("nativebridge", "handleCallback", responseList);
        }
        catch (Exception e) {
            DeviceLog.exception("Error while invoking batch response for WebView", e);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCallback(NativeCallback callback) {
        if (this._nativeCallbacks == null) {
            this._nativeCallbacks = new HashMap();
        }
        HashMap<String, NativeCallback> hashMap = this._nativeCallbacks;
        synchronized (hashMap) {
            this._nativeCallbacks.put(callback.getId(), callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCallback(NativeCallback callback) {
        if (this._nativeCallbacks == null) {
            return;
        }
        HashMap<String, NativeCallback> hashMap = this._nativeCallbacks;
        synchronized (hashMap) {
            this._nativeCallbacks.remove(callback.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NativeCallback getCallback(String callbackId) {
        HashMap<String, NativeCallback> hashMap = this._nativeCallbacks;
        synchronized (hashMap) {
            return this._nativeCallbacks.get(callbackId);
        }
    }

    public static WebViewApp getCurrentApp() {
        return _currentApp;
    }

    public static void setCurrentApp(WebViewApp app) {
        _currentApp = app;
    }

    public static boolean create(final Configuration configuration) throws IllegalThreadStateException {
        boolean createdSuccessfully;
        DeviceLog.entered();
        if (Thread.currentThread().equals(Looper.getMainLooper().getThread())) {
            throw new IllegalThreadStateException("Cannot call create() from main thread!");
        }
        Utilities.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                WebViewApp webViewApp;
                try {
                    webViewApp = new WebViewApp(configuration);
                }
                catch (Exception e) {
                    DeviceLog.error("Couldn't construct WebViewApp");
                    _conditionVariable.open();
                    return;
                }
                String queryString = "?platform=android";
                try {
                    if (configuration.getWebViewUrl() != null) {
                        queryString = queryString + "&origin=" + URLEncoder.encode(configuration.getWebViewUrl(), "UTF-8");
                    }
                }
                catch (UnsupportedEncodingException e) {
                    DeviceLog.exception("Unsupported charset when encoding origin url", e);
                }
                try {
                    if (configuration.getWebViewVersion() != null) {
                        queryString = queryString + "&version=" + URLEncoder.encode(configuration.getWebViewVersion(), "UTF-8");
                    }
                }
                catch (UnsupportedEncodingException e) {
                    DeviceLog.exception("Unsupported charset when encoding webview version", e);
                }
                webViewApp.getWebView().loadDataWithBaseURL("file://" + SdkProperties.getLocalWebViewFile() + queryString, configuration.getWebViewData(), "text/html", "UTF-8", null);
                WebViewApp.setCurrentApp(webViewApp);
            }
        });
        _conditionVariable = new ConditionVariable();
        final boolean webViewCreateDidNotTimeout = _conditionVariable.block(configuration.getWebViewAppCreateTimeout());
        final boolean webAppDefined = WebViewApp.getCurrentApp() != null;
        final boolean webAppInitialized = webAppDefined && WebViewApp.getCurrentApp().isWebAppInitialized();
        boolean bl = createdSuccessfully = webViewCreateDidNotTimeout && webAppDefined && webAppInitialized;
        if (!createdSuccessfully) {
            SDKMetrics.getInstance().sendEventWithTags("native_webview_creation_failed", (Map<String, String>)new HashMap<String, String>(){
                {
                    this.put("wto", "" + !webViewCreateDidNotTimeout);
                    this.put("wad", "" + webAppDefined);
                    this.put("wai", "" + webAppInitialized);
                }
            });
        }
        return createdSuccessfully;
    }

    static {
        _initialized = new AtomicReference<Boolean>(false);
        _webAppFailureMessage = new AtomicReference();
        _webAppFailureCode = new AtomicReference();
    }

    private class WebAppChromeClient
    extends WebChromeClient {
        private WebAppChromeClient() {
        }

        public void onConsoleMessage(String message, int lineNumber, String sourceID) {
            String sourceFile = sourceID;
            File tmp = null;
            try {
                tmp = new File(sourceID);
            }
            catch (Exception e) {
                DeviceLog.exception("Could not handle sourceId", e);
            }
            if (tmp != null) {
                sourceFile = tmp.getName();
            }
            if (Build.VERSION.SDK_INT < 19) {
                DeviceLog.debug("JavaScript (sourceId=" + sourceFile + ", line=" + lineNumber + "): " + message);
            }
        }
    }

    private class WebAppClient
    extends WebViewClient {
        private WebAppClient() {
        }

        public boolean onRenderProcessGone(android.webkit.WebView view, final RenderProcessGoneDetail detail) {
            Utilities.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (AdUnit.getAdUnitActivity() != null) {
                        AdUnit.getAdUnitActivity().finish();
                    }
                    if (WebViewApp.getCurrentApp() != null && WebViewApp.getCurrentApp().getWebView() != null) {
                        ViewUtilities.removeViewFromParent((View)WebViewApp.getCurrentApp().getWebView());
                    }
                    InitializeThread.reset();
                }
            });
            DeviceLog.error("UnityAds Sdk WebView onRenderProcessGone : " + detail.toString());
            SDKMetrics.getInstance().sendEventWithTags("native_webview_render_process_gone", (Map<String, String>)new HashMap<String, String>(){
                {
                    if (Build.VERSION.SDK_INT >= 26) {
                        this.put("dc", "" + detail.didCrash());
                        this.put("pae", "" + detail.rendererPriorityAtExit());
                    }
                }
            });
            return true;
        }

        public void onPageFinished(android.webkit.WebView webview, String url) {
            super.onPageFinished(webview, url);
            DeviceLog.debug("onPageFinished url: " + url);
        }

        public boolean shouldOverrideUrlLoading(android.webkit.WebView view, String url) {
            DeviceLog.debug("Trying to load url: " + url);
            return false;
        }

        public void onReceivedError(android.webkit.WebView view, WebResourceRequest request, WebResourceError error) {
            super.onReceivedError(view, request, error);
            if (view != null) {
                DeviceLog.error("WEBVIEW_ERROR: " + view.toString());
            }
            if (request != null) {
                DeviceLog.error("WEBVIEW_ERROR: " + request.toString());
            }
            if (error != null) {
                DeviceLog.error("WEBVIEW_ERROR: " + error.toString());
            }
        }
    }
}

