/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.purchasing.core;

import com.unity3d.services.purchasing.core.Store;
import com.unity3d.services.purchasing.core.TransactionError;
import java.util.HashMap;
import java.util.Map;

public class TransactionErrorDetails {
    private TransactionError transactionError;
    private String exceptionMessage;
    private Store store;
    private String storeSpecificErrorCode;
    private Map<String, Object> extras;

    private TransactionErrorDetails(Builder builder) {
        this.transactionError = builder.transactionError;
        this.exceptionMessage = builder.exceptionMessage;
        this.store = builder.store;
        this.storeSpecificErrorCode = builder.storeSpecificErrorCode;
        this.extras = builder.extras;
    }

    public TransactionError getTransactionError() {
        return this.transactionError;
    }

    public String getExceptionMessage() {
        return this.exceptionMessage;
    }

    public Store getStore() {
        return this.store;
    }

    public String getStoreSpecificErrorCode() {
        return this.storeSpecificErrorCode;
    }

    public Map<String, Object> getExtras() {
        return this.extras;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private TransactionError transactionError;
        private String exceptionMessage;
        private Store store;
        private String storeSpecificErrorCode;
        private Map<String, Object> extras = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder withTransactionError(TransactionError val) {
            this.transactionError = val;
            return this;
        }

        public Builder withExceptionMessage(String val) {
            this.exceptionMessage = val;
            return this;
        }

        public Builder withStore(Store val) {
            this.store = val;
            return this;
        }

        public Builder withStoreSpecificErrorCode(String val) {
            this.storeSpecificErrorCode = val;
            return this;
        }

        public Builder putExtras(Map<String, Object> val) {
            for (Map.Entry<String, Object> entry : val.entrySet()) {
                this.extras.put(entry.getKey(), entry.getValue());
            }
            return this;
        }

        public Builder putExtra(String key, Object val) {
            this.extras.put(key, val);
            return this;
        }

        public TransactionErrorDetails build() {
            return new TransactionErrorDetails(this);
        }
    }
}

