/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.store;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import com.unity3d.services.store.StoreMonitor;
import java.util.ArrayList;

@TargetApi(value=14)
public class StoreLifecycleListener
implements Application.ActivityLifecycleCallbacks {
    private boolean _trackAllActivities;
    private ArrayList<String> _exceptions;
    private ArrayList<String> _purchaseTypes;

    public StoreLifecycleListener(boolean trackAllActivities, ArrayList<String> exceptions, ArrayList<String> purchaseTypes) {
        this._trackAllActivities = trackAllActivities;
        this._exceptions = exceptions;
        this._purchaseTypes = purchaseTypes;
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
    }

    public void onActivityStarted(Activity activity) {
    }

    public void onActivityResumed(Activity activity) {
        boolean isException = false;
        if (this._exceptions != null && this._exceptions.contains(activity.getLocalClassName())) {
            isException = true;
        }
        if ((this._trackAllActivities && !isException || !this._trackAllActivities && isException) && this._purchaseTypes != null) {
            StoreMonitor.sendPurchaseStatusOnResume(activity.getLocalClassName(), this._purchaseTypes);
        }
    }

    public void onActivityPaused(Activity activity) {
    }

    public void onActivityStopped(Activity activity) {
        boolean isException = false;
        if (this._exceptions != null && this._exceptions.contains(activity.getLocalClassName())) {
            isException = true;
        }
        if ((this._trackAllActivities && !isException || !this._trackAllActivities && isException) && this._purchaseTypes != null) {
            StoreMonitor.sendPurchaseStatusOnStop(activity.getLocalClassName(), this._purchaseTypes);
        }
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    public void onActivityDestroyed(Activity activity) {
    }
}

