/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.store;

import android.annotation.TargetApi;
import android.app.Application;
import android.content.ComponentName;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import com.unity3d.services.core.properties.ClientProperties;
import com.unity3d.services.core.webview.WebViewApp;
import com.unity3d.services.core.webview.WebViewEventCategory;
import com.unity3d.services.store.StoreBilling;
import com.unity3d.services.store.StoreError;
import com.unity3d.services.store.StoreEvent;
import com.unity3d.services.store.StoreLifecycleListener;
import com.unity3d.services.store.core.StoreException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@TargetApi(value=14)
public class StoreMonitor {
    private static Object _billingService;
    private static StoreLifecycleListener _lifecycleListener;

    public static void initialize(String intentName, String intentPackage) {
        Intent intent = new Intent(intentName);
        intent.setPackage(intentPackage);
        ServiceConnection serviceConnection = new ServiceConnection(){

            public void onServiceConnected(ComponentName name, IBinder service) {
                _billingService = StoreBilling.asInterface(ClientProperties.getApplicationContext(), service);
                if (_billingService != null) {
                    WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.STORE, StoreEvent.INITIALIZED, new Object[0]);
                } else {
                    WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.STORE, StoreEvent.INITIALIZATION_FAILED, new Object[0]);
                }
            }

            public void onServiceDisconnected(ComponentName name) {
                _billingService = null;
                WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.STORE, StoreEvent.DISCONNECTED, new Object[0]);
            }
        };
        ClientProperties.getApplicationContext().bindService(intent, serviceConnection, 1);
    }

    public static boolean isInitialized() {
        return _billingService != null;
    }

    public static int isBillingSupported(String purchaseType) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, StoreException, InvocationTargetException {
        return StoreBilling.isBillingSupported(ClientProperties.getApplicationContext(), _billingService, purchaseType);
    }

    public static JSONObject getPurchases(String purchaseType) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, JSONException, IllegalAccessException, StoreException {
        return StoreBilling.getPurchases(ClientProperties.getApplicationContext(), _billingService, purchaseType);
    }

    public static JSONObject getPurchaseHistory(String purchaseType, int maxPurchases) throws NoSuchMethodException, StoreException, IllegalAccessException, JSONException, InvocationTargetException, ClassNotFoundException {
        return StoreBilling.getPurchaseHistory(ClientProperties.getApplicationContext(), _billingService, purchaseType, maxPurchases);
    }

    public static JSONArray getSkuDetails(String purchaseType, ArrayList<String> skuList) throws NoSuchMethodException, StoreException, IllegalAccessException, JSONException, InvocationTargetException, ClassNotFoundException {
        return StoreBilling.getSkuDetails(ClientProperties.getApplicationContext(), _billingService, purchaseType, skuList);
    }

    public static void startPurchaseTracking(boolean trackAllActivities, ArrayList<String> exceptions, ArrayList<String> purchaseTypes) {
        if (_lifecycleListener != null) {
            StoreMonitor.stopPurchaseTracking();
        }
        _lifecycleListener = new StoreLifecycleListener(trackAllActivities, exceptions, purchaseTypes);
        ClientProperties.getApplication().registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)_lifecycleListener);
    }

    public static void stopPurchaseTracking() {
        if (_lifecycleListener != null) {
            ClientProperties.getApplication().unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)_lifecycleListener);
            _lifecycleListener = null;
        }
    }

    public static void sendPurchaseStatusOnResume(String activityName, ArrayList<String> purchaseTypes) {
        if (!StoreMonitor.isInitialized()) {
            WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.STORE, StoreEvent.PURCHASE_STATUS_ON_RESUME_ERROR, new Object[]{StoreError.NOT_INITIALIZED, activityName, "StoreMonitor not initialized"});
            return;
        }
        try {
            JSONObject results = new JSONObject();
            if (purchaseTypes.contains("inapp")) {
                JSONObject inAppStatus = StoreMonitor.getPurchases("inapp");
                results.put("inapp", (Object)inAppStatus);
            }
            if (purchaseTypes.contains("subs")) {
                JSONObject subsStatus = StoreMonitor.getPurchases("subs");
                results.put("subs", (Object)subsStatus);
            }
            WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.STORE, StoreEvent.PURCHASE_STATUS_ON_RESUME, activityName, results);
        }
        catch (ClassNotFoundException e) {
            WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.STORE, StoreEvent.PURCHASE_STATUS_ON_RESUME_ERROR, new Object[]{StoreError.CLASS_NOT_FOUND, activityName, e.getMessage()});
        }
        catch (NoSuchMethodException e) {
            WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.STORE, StoreEvent.PURCHASE_STATUS_ON_RESUME_ERROR, new Object[]{StoreError.NO_SUCH_METHOD, activityName, e.getMessage()});
        }
        catch (InvocationTargetException e) {
            WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.STORE, StoreEvent.PURCHASE_STATUS_ON_RESUME_ERROR, new Object[]{StoreError.INVOCATION_TARGET, activityName, e.getMessage()});
        }
        catch (JSONException e) {
            WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.STORE, StoreEvent.PURCHASE_STATUS_ON_RESUME_ERROR, new Object[]{StoreError.JSON_ERROR, activityName, e.getMessage()});
        }
        catch (IllegalAccessException e) {
            WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.STORE, StoreEvent.PURCHASE_STATUS_ON_RESUME_ERROR, new Object[]{StoreError.ILLEGAL_ACCESS, activityName, e.getMessage()});
        }
        catch (StoreException e) {
            WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.STORE, StoreEvent.PURCHASE_STATUS_ON_RESUME_ERROR, new Object[]{StoreError.STORE_ERROR, activityName, e.getMessage(), e.getResultCode()});
        }
    }

    public static void sendPurchaseStatusOnStop(String activityName, ArrayList<String> purchaseTypes) {
        if (!StoreMonitor.isInitialized()) {
            WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.STORE, StoreEvent.PURCHASE_STATUS_ON_STOP_ERROR, new Object[]{StoreError.NOT_INITIALIZED, activityName, "StoreMonitor not initialized"});
            return;
        }
        try {
            JSONObject results = new JSONObject();
            if (purchaseTypes.contains("inapp")) {
                JSONObject inAppStatus = StoreMonitor.getPurchases("inapp");
                results.put("inapp", (Object)inAppStatus);
            }
            if (purchaseTypes.contains("subs")) {
                JSONObject subsStatus = StoreMonitor.getPurchases("subs");
                results.put("subs", (Object)subsStatus);
            }
            WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.STORE, StoreEvent.PURCHASE_STATUS_ON_STOP, activityName, results);
        }
        catch (ClassNotFoundException e) {
            WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.STORE, StoreEvent.PURCHASE_STATUS_ON_STOP_ERROR, new Object[]{StoreError.CLASS_NOT_FOUND, activityName, e.getMessage()});
        }
        catch (NoSuchMethodException e) {
            WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.STORE, StoreEvent.PURCHASE_STATUS_ON_STOP_ERROR, new Object[]{StoreError.NO_SUCH_METHOD, activityName, e.getMessage()});
        }
        catch (InvocationTargetException e) {
            WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.STORE, StoreEvent.PURCHASE_STATUS_ON_STOP_ERROR, new Object[]{StoreError.INVOCATION_TARGET, activityName, e.getMessage()});
        }
        catch (JSONException e) {
            WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.STORE, StoreEvent.PURCHASE_STATUS_ON_STOP_ERROR, new Object[]{StoreError.JSON_ERROR, activityName, e.getMessage()});
        }
        catch (IllegalAccessException e) {
            WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.STORE, StoreEvent.PURCHASE_STATUS_ON_STOP_ERROR, new Object[]{StoreError.ILLEGAL_ACCESS, activityName, e.getMessage()});
        }
        catch (StoreException e) {
            WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.STORE, StoreEvent.PURCHASE_STATUS_ON_STOP_ERROR, new Object[]{StoreError.STORE_ERROR, activityName, e.getMessage(), e.getResultCode()});
        }
    }
}

