/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.ads.adunit;

import android.annotation.TargetApi;
import android.content.Context;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.view.MotionEvent;
import android.widget.RelativeLayout;
import com.unity3d.services.ads.adunit.AdUnitMotionEvent;
import java.util.ArrayList;

public class AdUnitRelativeLayout
extends RelativeLayout {
    private final ArrayList<AdUnitMotionEvent> _motionEvents = new ArrayList();
    private int _maxEvents = 10000;
    private boolean _shouldCapture = false;

    public AdUnitRelativeLayout(Context context) {
        super(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=14)
    public boolean onInterceptTouchEvent(MotionEvent e) {
        super.onInterceptTouchEvent(e);
        if (this._shouldCapture && this._motionEvents.size() < this._maxEvents) {
            boolean isObscured = (e.getFlags() & 1) != 0;
            ArrayList<AdUnitMotionEvent> arrayList = this._motionEvents;
            synchronized (arrayList) {
                this._motionEvents.add(new AdUnitMotionEvent(e.getActionMasked(), isObscured, e.getToolType(0), e.getSource(), e.getDeviceId(), e.getX(0), e.getY(0), e.getEventTime(), e.getPressure(0), e.getSize(0)));
            }
        }
        return false;
    }

    public void startCapture(int maxEvents) {
        this._maxEvents = maxEvents;
        this._shouldCapture = true;
    }

    public void endCapture() {
        this._shouldCapture = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCapture() {
        ArrayList<AdUnitMotionEvent> arrayList = this._motionEvents;
        synchronized (arrayList) {
            this._motionEvents.clear();
        }
    }

    public int getMaxEventCount() {
        return this._maxEvents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCurrentEventCount() {
        ArrayList<AdUnitMotionEvent> arrayList = this._motionEvents;
        synchronized (arrayList) {
            return this._motionEvents.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SparseArray<SparseArray<AdUnitMotionEvent>> getEvents(SparseArray<ArrayList<Integer>> requestedInfos) {
        SparseIntArray countTable = new SparseIntArray();
        SparseArray returnData = new SparseArray();
        ArrayList<AdUnitMotionEvent> arrayList = this._motionEvents;
        synchronized (arrayList) {
            for (AdUnitMotionEvent currentEvent : this._motionEvents) {
                ArrayList currentRequestedInfos = (ArrayList)requestedInfos.get(currentEvent.getAction());
                if (currentRequestedInfos == null) continue;
                int currentRequestedInfoIndex = (Integer)currentRequestedInfos.get(0);
                if (countTable.get(currentEvent.getAction(), 0) == currentRequestedInfoIndex) {
                    if (returnData.get(currentEvent.getAction()) == null) {
                        returnData.put(currentEvent.getAction(), (Object)new SparseArray());
                    }
                    ((SparseArray)returnData.get(currentEvent.getAction())).put(currentRequestedInfoIndex, (Object)currentEvent);
                    currentRequestedInfos.remove(0);
                }
                countTable.put(currentEvent.getAction(), countTable.get(currentEvent.getAction()) + 1);
            }
        }
        return returnData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SparseIntArray getEventCount(ArrayList<Integer> eventTypes) {
        SparseIntArray returnArray = new SparseIntArray();
        ArrayList<AdUnitMotionEvent> arrayList = this._motionEvents;
        synchronized (arrayList) {
            block3: for (AdUnitMotionEvent currentEvent : this._motionEvents) {
                for (Integer currentType : eventTypes) {
                    if (currentEvent.getAction() != currentType.intValue()) continue;
                    returnArray.put(currentType.intValue(), returnArray.get(currentType.intValue(), 0) + 1);
                    continue block3;
                }
            }
        }
        return returnArray;
    }
}

