/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.ads.configuration;

import android.os.ConditionVariable;
import com.unity3d.services.ads.UnityAdsImplementation;
import com.unity3d.services.ads.adunit.AdUnitOpen;
import com.unity3d.services.ads.adunit.VideoPlayerHandler;
import com.unity3d.services.ads.adunit.WebPlayerHandler;
import com.unity3d.services.ads.adunit.WebViewHandler;
import com.unity3d.services.ads.api.AdUnit;
import com.unity3d.services.ads.api.GMAScar;
import com.unity3d.services.ads.api.Load;
import com.unity3d.services.ads.api.Show;
import com.unity3d.services.ads.api.Token;
import com.unity3d.services.ads.api.VideoPlayer;
import com.unity3d.services.ads.api.WebPlayer;
import com.unity3d.services.ads.configuration.IAdsModuleConfiguration;
import com.unity3d.services.ads.token.TokenStorage;
import com.unity3d.services.core.configuration.Configuration;
import com.unity3d.services.core.log.DeviceLog;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class AdsModuleConfiguration
implements IAdsModuleConfiguration {
    private InetAddress _address;

    @Override
    public Class[] getWebAppApiClassList() {
        Class[] list = new Class[]{AdUnit.class, VideoPlayer.class, WebPlayer.class, Load.class, Show.class, Token.class, GMAScar.class};
        return list;
    }

    @Override
    public boolean resetState(Configuration configuration) {
        AdUnitOpen.setConfiguration(configuration);
        UnityAdsImplementation.setConfiguration(configuration);
        TokenStorage.deleteTokens();
        return true;
    }

    @Override
    public boolean initModuleState(Configuration configuration) {
        String configHost;
        DeviceLog.debug("Unity Ads init: checking for ad blockers");
        try {
            configHost = new URL(configuration.getConfigUrl()).getHost();
        }
        catch (MalformedURLException e) {
            return true;
        }
        final ConditionVariable cv = new ConditionVariable();
        new Thread(){

            @Override
            public void run() {
                try {
                    AdsModuleConfiguration.this._address = InetAddress.getByName(configHost);
                    cv.open();
                }
                catch (Exception e) {
                    DeviceLog.exception("Couldn't get address. Host: " + configHost, e);
                    cv.open();
                }
            }
        }.start();
        boolean success = cv.block(2000L);
        if (success && this._address != null && this._address.isLoopbackAddress()) {
            DeviceLog.error("Unity Ads init: halting init because Unity Ads config resolves to loopback address (due to ad blocker?)");
            return false;
        }
        AdUnitOpen.setConfiguration(configuration);
        UnityAdsImplementation.setConfiguration(configuration);
        return true;
    }

    @Override
    public boolean initErrorState(Configuration configuration, String state, String errorMessage) {
        return true;
    }

    @Override
    public boolean initCompleteState(Configuration configuration) {
        AdUnitOpen.setConfiguration(configuration);
        UnityAdsImplementation.setConfiguration(configuration);
        return true;
    }

    @Override
    public Map<String, Class> getAdUnitViewHandlers() {
        HashMap<String, Class> handlers = new HashMap<String, Class>();
        handlers.put("videoplayer", VideoPlayerHandler.class);
        handlers.put("webplayer", WebPlayerHandler.class);
        handlers.put("webview", WebViewHandler.class);
        return handlers;
    }
}

