/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.ads.gmascar.handlers;

import com.unity3d.scar.adapter.common.GMAEvent;
import com.unity3d.scar.adapter.common.IScarInterstitialAdListenerWrapper;
import com.unity3d.scar.adapter.common.scarads.ScarAdMetadata;
import com.unity3d.services.core.webview.WebViewApp;
import com.unity3d.services.core.webview.WebViewEventCategory;
import java.util.Timer;
import java.util.TimerTask;

public class ScarInterstitialAdHandler
implements IScarInterstitialAdListenerWrapper {
    private ScarAdMetadata _scarAdMetadata;
    private boolean _finishedPlaying = false;
    private boolean _hasSentStartEvents = false;
    private Timer _playbackTimer;
    private TimerTask _playbackTimerTask = new TimerTask(){

        @Override
        public void run() {
            ScarInterstitialAdHandler.this._finishedPlaying = true;
        }
    };

    public ScarInterstitialAdHandler(ScarAdMetadata scarAdMetadata) {
        this._scarAdMetadata = scarAdMetadata;
        this._playbackTimer = new Timer();
    }

    public void onAdLoaded() {
        WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.GMA, (Enum)GMAEvent.AD_LOADED, this._scarAdMetadata.getPlacementId(), this._scarAdMetadata.getQueryId());
    }

    public void onAdFailedToLoad(int errorCode, String errorString) {
        WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.GMA, (Enum)GMAEvent.LOAD_ERROR, this._scarAdMetadata.getPlacementId(), this._scarAdMetadata.getQueryId(), errorString, errorCode);
    }

    public void onAdOpened() {
        if (!this._hasSentStartEvents) {
            WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.GMA, (Enum)GMAEvent.AD_STARTED, new Object[0]);
            WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.GMA, (Enum)GMAEvent.FIRST_QUARTILE, new Object[0]);
            WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.GMA, (Enum)GMAEvent.MIDPOINT, new Object[0]);
            this._hasSentStartEvents = true;
        }
        this._finishedPlaying = false;
        this._playbackTimer.schedule(this._playbackTimerTask, this._scarAdMetadata.getVideoLengthMs().intValue());
    }

    public void onAdFailedToShow(int errorCode, String errorString) {
        WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.GMA, (Enum)GMAEvent.INTERSTITIAL_SHOW_ERROR, this._scarAdMetadata.getPlacementId(), this._scarAdMetadata.getQueryId(), errorString, errorCode);
    }

    public void onAdClicked() {
        WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.GMA, (Enum)GMAEvent.AD_CLICKED, new Object[0]);
    }

    public void onAdClosed() {
        if (!this._finishedPlaying) {
            WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.GMA, (Enum)GMAEvent.AD_SKIPPED, new Object[0]);
            this._playbackTimer.cancel();
        }
        WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.GMA, (Enum)GMAEvent.AD_CLOSED, new Object[0]);
    }

    public void onAdLeftApplication() {
    }

    public void onAdImpression() {
        WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.GMA, (Enum)GMAEvent.INTERSTITIAL_IMPRESSION_RECORDED, this._scarAdMetadata.getPlacementId(), this._scarAdMetadata.getQueryId());
    }
}

