/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.request;

import android.text.TextUtils;
import com.unity3d.services.core.configuration.Configuration;
import com.unity3d.services.core.device.Device;
import com.unity3d.services.core.log.DeviceLog;
import com.unity3d.services.core.properties.SdkProperties;
import com.unity3d.services.core.request.ISDKMetrics;
import com.unity3d.services.core.request.WebRequest;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.json.JSONObject;

public final class SDKMetrics {
    private static ISDKMetrics _instance = new NullInstance();

    public static void setConfiguration(Configuration configuration) {
        if (configuration == null) {
            DeviceLog.debug("Metrics will not be sent from the device for this session due to misconfiguration");
            return;
        }
        if (_instance instanceof MetricInstance) {
            ((MetricInstance)_instance).shutdown();
        }
        Random random = new Random();
        if (configuration.getMetricSampleRate() >= (double)(random.nextInt(99) + 1)) {
            _instance = new MetricInstance(configuration.getMetricsUrl());
        } else {
            DeviceLog.debug("Metrics will not be sent from the device for this session");
            _instance = new NullInstance();
        }
    }

    public static ISDKMetrics getInstance() {
        return _instance;
    }

    private static final class MetricInstance
    implements ISDKMetrics {
        private final String _metricsUrl;
        private final ExecutorService _executorService;

        public MetricInstance(String url) {
            this._metricsUrl = url;
            this._executorService = Executors.newSingleThreadExecutor();
        }

        protected void shutdown() {
            this._executorService.shutdown();
        }

        @Override
        public void sendEvent(String event) {
            this.sendEventWithTags(event, null);
        }

        @Override
        public void sendEventWithTags(final String event, final Map<String, String> tags) {
            if (TextUtils.isEmpty((CharSequence)event)) {
                DeviceLog.debug("Metric event not sent due to being nil or empty: " + event);
                return;
            }
            if (TextUtils.isEmpty((CharSequence)this._metricsUrl)) {
                DeviceLog.debug("Metric: " + event + " was not sent to nil or empty endpoint: " + this._metricsUrl);
                return;
            }
            if (this._executorService.isShutdown()) {
                DeviceLog.debug("Metric " + event + " was not sent due to misconfiguration");
                return;
            }
            this._executorService.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        boolean is2XXResponseCode;
                        String tagString = "";
                        if (tags != null) {
                            JSONObject jsonTags = new JSONObject(tags);
                            tagString = ",\"t\":" + jsonTags.toString();
                        }
                        String postBody = "{\"m\":[{\"n\":\"" + event + "\"" + tagString + "}],\"t\":{\"iso\":\"" + Device.getNetworkCountryISO() + "\",\"plt\":\"android\",\"sdv\":\"" + SdkProperties.getVersionName() + "\"}}";
                        WebRequest request = new WebRequest(MetricInstance.this._metricsUrl, "POST", null);
                        request.setBody(postBody);
                        request.makeRequest();
                        boolean bl = is2XXResponseCode = request.getResponseCode() / 100 == 2;
                        if (is2XXResponseCode) {
                            DeviceLog.debug("Metric " + event + " sent to " + MetricInstance.this._metricsUrl);
                        } else {
                            DeviceLog.debug("Metric " + event + " failed to send with response code: " + request.getResponseCode());
                        }
                    }
                    catch (Exception e) {
                        DeviceLog.debug("Metric " + event + " failed to send from exception: " + e.getMessage());
                    }
                }
            });
        }
    }

    private static final class NullInstance
    implements ISDKMetrics {
        private NullInstance() {
        }

        @Override
        public void sendEvent(String event) {
            DeviceLog.debug("Metric " + event + " was skipped from being sent");
        }

        @Override
        public void sendEventWithTags(String event, Map<String, String> tags) {
            this.sendEvent(event);
        }
    }
}

