package com.unity3d.ads.core.domain

import com.unity3d.ads.core.data.model.InitializationState
import com.unity3d.ads.core.data.repository.SessionRepository
import kotlinx.coroutines.flow.filter
import kotlinx.coroutines.flow.first
import kotlinx.coroutines.withTimeoutOrNull

class CommonAwaitInitialization (
    private val sessionRepository: SessionRepository
) : AwaitInitialization {
    override suspend fun invoke(timeout: Long): InitializationState? = withTimeoutOrNull(timeout) {
        sessionRepository.observeInitializationState
            .filter { it == InitializationState.INITIALIZED || it == InitializationState.FAILED }
            .first()
    }
}