package com.unity3d.ads.core.domain

import com.unity3d.ads.core.data.model.exception.GatewayException
import com.unity3d.ads.core.data.repository.DeviceInfoRepository
import com.unity3d.ads.core.data.repository.SessionRepository
import com.unity3d.ads.core.domain.SendDiagnosticEvent.Companion.REASON_GATEWAY
import gatewayprotocol.v1.UniversalResponseOuterClass.UniversalResponse
import kotlinx.coroutines.flow.update

internal class AndroidHandleGatewayUniversalResponse(
    private val sessionRepository: SessionRepository,
    private val deviceInfoRepository: DeviceInfoRepository
) : HandleGatewayUniversalResponse {
    override suspend fun invoke(response: UniversalResponse) {
        if (response.hasError()) {
            sessionRepository.shouldInitialize = false
            throw GatewayException(
                message = response.error.errorText,
                throwable = IllegalStateException(response.error.errorText),
                reason = "${REASON_GATEWAY}_${GatewayException.GATEWAY_RESPONSE_DEPTH_UNIVERSAL}",
                reasonDebug = response.error.errorText,
            )
        }

        if (response.hasMutableData()) {
            val mutableData = response.mutableData

            deviceInfoRepository.allowedPii.update { mutableData.allowedPii }

            sessionRepository.gatewayState = mutableData.currentState

            if (mutableData.hasSessionToken()) {
                sessionRepository.sessionToken = mutableData.sessionToken
            }
            if (mutableData.hasPrivacy()) {
                sessionRepository.setPrivacy(mutableData.privacy)
            }
            if (mutableData.hasSessionCounters()) {
                sessionRepository.sessionCounters = mutableData.sessionCounters
            }
            if (mutableData.hasCache()) {
                sessionRepository.setGatewayCache(mutableData.cache)
            }
            if (mutableData.hasPrivacyFsm()) {
                sessionRepository.setPrivacyFsm(mutableData.privacyFsm)
            }
        }
    }
}