package com.unity3d.ads.core.domain

import com.google.protobuf.ByteString
import com.unity3d.ads.core.data.model.OperationType
import com.unity3d.ads.gatewayclient.GatewayClient
import com.unity3d.services.core.di.ServiceProvider.NAMED_OTHER_REQ
import gatewayprotocol.v1.PrivacyUpdateResponseOuterClass.PrivacyUpdateResponse




class SendPrivacyUpdateRequest(
    private val getPrivacyUpdateRequest: GetPrivacyUpdateRequest,
    private val getRequestPolicy: GetRequestPolicy,
    private val gatewayClient: GatewayClient,
) {
    suspend operator fun invoke(
        privacyUpdateVersion: Int,
        privacyUpdateContent: ByteString
    ): PrivacyUpdateResponse {
        val universalPrivacyUpdateRequest = getPrivacyUpdateRequest(privacyUpdateVersion, privacyUpdateContent)
        val requestPolicy = getRequestPolicy()
        val response = gatewayClient.request(request = universalPrivacyUpdateRequest, requestPolicy = requestPolicy, operationType = OperationType.PRIVACY_UPDATE)
        return response.payload.privacyUpdateResponse
    }
}