package com.unity3d.ads.core.domain.events

import com.google.protobuf.ByteString
import com.unity3d.ads.core.domain.GetSharedDataTimestamps
import gatewayprotocol.v1.DiagnosticEventRequestOuterClass.DiagnosticEventType
import gatewayprotocol.v1.DiagnosticEventRequestOuterClass.DiagnosticEvent
import gatewayprotocol.v1.diagnosticEvent
import gatewayprotocol.v1.DiagnosticEventRequestOuterClass.DiagnosticAdType

internal class GetDiagnosticEventRequest(
    private val getSharedDataTimestamps: GetSharedDataTimestamps
) {
    operator fun invoke(
        eventName: String,
        tags: Map<String, String>?,
        intTags: Map<String, Int>?,
        value: Double?,
        hb: Boolean?,
        opportunityId: ByteString?,
        placement: String?,
        adType: DiagnosticAdType?
    ): DiagnosticEvent {
        return diagnosticEvent {
            eventType = DiagnosticEventType.DIAGNOSTIC_EVENT_TYPE_CUSTOM
            timestamps = getSharedDataTimestamps()
            customEventType = eventName
            tags?.let { stringTags.putAll(it) }
            intTags?.let { this.intTags.putAll(it) }
            value?.let { timeValue = it }
            hb?.let { isHeaderBidding = it }
            opportunityId?.let { impressionOpportunityId = it }
            placement?.let { placementId = it }
            adType?.let { this.adType = it }
        }
    }
}