package com.unity3d.services.core.request.metrics;

import java.util.HashMap;

public class InitMetric {

	private static final String INIT_GAME_ID_CHANGED = "native_initialize_game_id_changed";

	private static final String INIT_GAME_ID_SAME = "native_initialize_game_id_same";

	private static final String INIT_TEST_MODE_CHANGED = "native_initialize_test_mode_changed";

	private static final String INIT_TEST_MODE_SAME = "native_initialize_test_mode_same";

	private static final String INIT_TAG_GAME_ID = "game_id";

	private static final String INIT_TAG_PREVIOUS_GAME_ID = "previous_game_id";

	private static final String INIT_TAG_TEST_MODE = "test_mode";

	private static final String INIT_TAG_PREVIOUS_TEST_MODE = "previous_test_mode";

	public static Metric newInitGameIdChanged(String previousGameId, String gameId) {
		return new Metric(
			INIT_GAME_ID_CHANGED,
			null,
			new HashMap<String, String>() {
				{
					put(INIT_TAG_GAME_ID, gameId);
					put(INIT_TAG_PREVIOUS_GAME_ID, previousGameId);
				}
			});
	}

	public static Metric newInitGameIdSame(String previousGameId, String gameId) {
		return new Metric(
			INIT_GAME_ID_SAME,
			null,
			new HashMap<String, String>() {
				{
					put(INIT_TAG_GAME_ID, gameId);
					put(INIT_TAG_PREVIOUS_GAME_ID, previousGameId);
				}
			});
	}

	public static Metric newInitTestModeChanged(Boolean previousTestMode, Boolean testMode) {
		return new Metric(
			INIT_TEST_MODE_CHANGED,
			null,
			new HashMap<String, String>() {
				{
					put(INIT_TAG_TEST_MODE, testMode.toString());
					put(INIT_TAG_PREVIOUS_TEST_MODE, previousTestMode.toString());
				}
			});
	}

	public static Metric newInitTestModeSame(Boolean previousTestMode, Boolean testMode) {
		return new Metric(
			INIT_TEST_MODE_SAME,
			null,
			new HashMap<String, String>() {
				{
					put(INIT_TAG_TEST_MODE, testMode.toString());
					put(INIT_TAG_PREVIOUS_TEST_MODE, previousTestMode.toString());
				}
			});
	}
}
