/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.misc;

import com.unity3d.services.core.log.DeviceLog;
import com.unity3d.services.core.misc.JsonFlattenerRules;
import java.util.Iterator;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonFlattener {
    private final JSONObject _jsonData;

    public JsonFlattener(JSONObject jsonData) {
        this._jsonData = jsonData;
    }

    public JSONObject flattenJson(String separator, JsonFlattenerRules jsonFlattenerRules) {
        if (jsonFlattenerRules == null) {
            return new JSONObject();
        }
        return this.flattenJson(separator, jsonFlattenerRules.getTopLevelToInclude(), jsonFlattenerRules.getReduceKeys(), jsonFlattenerRules.getSkipKeys());
    }

    public JSONObject flattenJson(String separator, List<String> topLevelToInclude, List<String> reduceKeys, List<String> skipKeys) {
        JSONObject flattenedJson = new JSONObject();
        try {
            Iterator keyItor = this._jsonData.keys();
            while (keyItor.hasNext()) {
                String key = (String)keyItor.next();
                if (!this.shouldIncludeKey(key, topLevelToInclude, skipKeys)) continue;
                Object value = this._jsonData.opt(key);
                if (value instanceof JSONObject) {
                    JsonFlattener jsonFlattener = new JsonFlattener((JSONObject)value);
                    jsonFlattener.flattenJson(separator, key, flattenedJson, reduceKeys, skipKeys);
                    continue;
                }
                flattenedJson.put(key, value);
            }
        }
        catch (JSONException e) {
            DeviceLog.error("Could not flatten JSON: %s", e.getMessage());
        }
        return flattenedJson;
    }

    public void flattenJson(String separator, String parentName, JSONObject outputDictionary, List<String> reduceKeys, List<String> skipKeys) throws JSONException {
        Iterator keyItor = this._jsonData.keys();
        while (keyItor.hasNext()) {
            String key = (String)keyItor.next();
            if (skipKeys.contains(key)) continue;
            Object value = this._jsonData.get(key);
            String newKey = reduceKeys.contains(key) ? parentName : String.format("%s%s%s", parentName, separator, key);
            if (value instanceof JSONObject) {
                JsonFlattener jsonFlattener = new JsonFlattener((JSONObject)value);
                jsonFlattener.flattenJson(separator, newKey, outputDictionary, reduceKeys, skipKeys);
                continue;
            }
            outputDictionary.put(newKey, value);
        }
    }

    private boolean shouldIncludeKey(String keyToInclude, List<String> includeList, List<String> skipKeys) {
        if (skipKeys.contains(keyToInclude)) {
            return false;
        }
        if (includeList.size() <= 0) {
            return false;
        }
        return includeList.contains(keyToInclude);
    }
}

