/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.configuration;

import com.unity3d.services.core.configuration.Configuration;
import com.unity3d.services.core.configuration.ConfigurationRequestFactory;
import com.unity3d.services.core.configuration.IConfigurationLoader;
import com.unity3d.services.core.configuration.IConfigurationLoaderListener;
import com.unity3d.services.core.configuration.IPrivacyConfigurationListener;
import com.unity3d.services.core.configuration.InitializeEventsMetricSender;
import com.unity3d.services.core.configuration.PrivacyCallError;
import com.unity3d.services.core.configuration.PrivacyConfig;
import com.unity3d.services.core.configuration.PrivacyConfigStatus;
import com.unity3d.services.core.configuration.PrivacyConfigStorage;
import com.unity3d.services.core.extensions.AbortRetryException;
import com.unity3d.services.core.log.DeviceLog;
import com.unity3d.services.core.misc.Utilities;
import com.unity3d.services.core.network.core.HttpClient;
import com.unity3d.services.core.network.mapper.WebRequestToHttpRequestKt;
import com.unity3d.services.core.network.model.HttpRequest;
import com.unity3d.services.core.network.model.HttpResponse;
import com.unity3d.services.core.properties.ClientProperties;
import com.unity3d.services.core.request.WebRequest;
import java.util.concurrent.atomic.AtomicBoolean;
import org.json.JSONObject;

public class PrivacyConfigurationLoader
implements IConfigurationLoader {
    private final IConfigurationLoader _configurationLoader;
    private final ConfigurationRequestFactory _configurationRequestFactory;
    private final PrivacyConfigStorage _privacyConfigStorage;
    private final HttpClient _httpClient = (HttpClient)Utilities.getService(HttpClient.class);

    public PrivacyConfigurationLoader(IConfigurationLoader configurationLoader, ConfigurationRequestFactory configurationRequestFactory, PrivacyConfigStorage privacyConfigStorage) {
        this._configurationLoader = configurationLoader;
        this._configurationRequestFactory = configurationRequestFactory;
        this._privacyConfigStorage = privacyConfigStorage;
    }

    @Override
    public void loadConfiguration(IConfigurationLoaderListener configurationLoaderListener) throws Exception {
        final AtomicBoolean gameDisabled = new AtomicBoolean(false);
        if (this._privacyConfigStorage.getPrivacyConfig().getPrivacyStatus() == PrivacyConfigStatus.UNKNOWN) {
            this.load(new IPrivacyConfigurationListener(){

                @Override
                public void onSuccess(PrivacyConfig privacyMode) {
                    PrivacyConfigurationLoader.this._privacyConfigStorage.setPrivacyConfig(privacyMode);
                }

                @Override
                public void onError(PrivacyCallError privacyCallError, String errorMsg) {
                    DeviceLog.warning("Couldn't fetch privacy configuration: " + errorMsg);
                    PrivacyConfigurationLoader.this._privacyConfigStorage.setPrivacyConfig(new PrivacyConfig());
                    if (privacyCallError == PrivacyCallError.LOCKED_423) {
                        gameDisabled.set(true);
                    }
                }
            });
        }
        if (gameDisabled.get()) {
            throw new AbortRetryException("Game is disabled");
        }
        this._configurationLoader.loadConfiguration(configurationLoaderListener);
    }

    @Override
    public Configuration getLocalConfiguration() {
        return this._configurationLoader.getLocalConfiguration();
    }

    private void load(IPrivacyConfigurationListener privacyLoaderListener) throws Exception {
        WebRequest request;
        try {
            request = this._configurationRequestFactory.getWebRequest();
        }
        catch (Exception ex) {
            privacyLoaderListener.onError(PrivacyCallError.NETWORK_ISSUE, "Could not create web request: " + ex);
            return;
        }
        HttpRequest httpRequest = WebRequestToHttpRequestKt.toHttpRequest(request);
        InitializeEventsMetricSender.getInstance().didPrivacyConfigRequestStart();
        HttpResponse response = this._httpClient.executeBlocking(httpRequest);
        try {
            boolean is2XXResponseCode;
            boolean bl = is2XXResponseCode = response.getStatusCode() / 100 == 2;
            if (is2XXResponseCode) {
                InitializeEventsMetricSender.getInstance().didPrivacyConfigRequestEnd(true);
                privacyLoaderListener.onSuccess(new PrivacyConfig(new JSONObject(response.getBody().toString())));
            } else if (response.getStatusCode() == 423) {
                InitializeEventsMetricSender.getInstance().didPrivacyConfigRequestEnd(false);
                privacyLoaderListener.onError(PrivacyCallError.LOCKED_423, "Game ID is disabled " + ClientProperties.getGameId());
            } else {
                InitializeEventsMetricSender.getInstance().didPrivacyConfigRequestEnd(false);
                privacyLoaderListener.onError(PrivacyCallError.NETWORK_ISSUE, "Privacy request failed with code: " + response.getStatusCode());
            }
        }
        catch (Exception e) {
            InitializeEventsMetricSender.getInstance().didPrivacyConfigRequestEnd(false);
            privacyLoaderListener.onError(PrivacyCallError.NETWORK_ISSUE, "Could not create web request");
        }
    }
}

