/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.webview;

import com.unity3d.services.core.configuration.Configuration;
import com.unity3d.services.core.log.DeviceLog;
import com.unity3d.services.core.misc.Utilities;
import com.unity3d.services.core.request.metrics.SDKMetricsSender;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class WebViewUrlBuilder {
    private final String _urlWithQueryString;
    private final SDKMetricsSender _sdkMetricsSender = (SDKMetricsSender)Utilities.getService(SDKMetricsSender.class);

    public WebViewUrlBuilder(String baseUrl, Configuration configuration) {
        String queryString = "?platform=android";
        queryString = queryString + this.buildQueryParam("origin", configuration.getWebViewUrl());
        queryString = queryString + this.buildQueryParam("version", configuration.getWebViewVersion());
        queryString = queryString + this.buildQueryParam("isNativeCollectingMetrics", String.valueOf(this._sdkMetricsSender.areMetricsEnabledForCurrentSession()));
        this._urlWithQueryString = baseUrl + queryString;
    }

    public String getUrlWithQueryString() {
        return this._urlWithQueryString;
    }

    private String buildQueryParam(String fieldName, String fieldData) {
        String queryString = "";
        try {
            if (fieldData != null) {
                queryString = queryString + "&" + fieldName + "=" + URLEncoder.encode(fieldData, "UTF-8");
            }
        }
        catch (UnsupportedEncodingException e) {
            DeviceLog.exception(String.format("Unsupported charset when encoding %s", fieldName), e);
        }
        return queryString;
    }
}

