/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren;

import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import com.google.gson.annotations.SerializedName;
import com.vungle.warren.BaseAdConfig;

public class AdConfig
extends BaseAdConfig {
    @SerializedName(value="ordinal")
    private int ordinal;
    public static final int IMMEDIATE_BACK = 2;
    public static final int IMMERSIVE = 4;
    public static final int TRANSITION_ANIMATE = 8;
    @SerializedName(value="adOrientation")
    @Orientation
    private int adOrientation = 2;
    public static final int PORTRAIT = 0;
    public static final int LANDSCAPE = 1;
    public static final int AUTO_ROTATE = 2;
    public static final int MATCH_VIDEO = 3;

    public AdConfig() {
    }

    public AdConfig(AdSize adSize) {
        super(adSize);
    }

    public AdConfig(BaseAdConfig baseAdConfig) {
        super(baseAdConfig);
    }

    public void setBackButtonImmediatelyEnabled(boolean isBackButtonImmediatelyEnabled) {
        this.settings = isBackButtonImmediatelyEnabled ? (this.settings |= 2) : (this.settings &= 0xFFFFFFFD);
    }

    public void setImmersiveMode(boolean isImmersiveMode) {
        this.settings = isImmersiveMode ? (this.settings |= 4) : (this.settings &= 0xFFFFFFFB);
    }

    public void setTransitionAnimationEnabled(boolean isTransitionAnimationEnabled) {
        this.settings = isTransitionAnimationEnabled ? (this.settings |= 8) : (this.settings &= 0xFFFFFFF7);
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public void setOrdinal(int ordinal) {
        this.ordinal = ordinal;
    }

    @Orientation
    public int getAdOrientation() {
        return this.adOrientation;
    }

    public void setAdOrientation(@Orientation int adOrientation) {
        this.adOrientation = adOrientation;
    }

    public static @interface Orientation {
    }

    @Keep
    public static enum AdSize {
        VUNGLE_MREC("mrec", 300, 250),
        VUNGLE_DEFAULT("default", -1, -1),
        BANNER("banner", 320, 50),
        BANNER_SHORT("banner_short", 300, 50),
        BANNER_LEADERBOARD("banner_leaderboard", 728, 90);

        private final int width;
        private final int height;
        private final String name;

        private AdSize(String name, int width, int height) {
            this.width = width;
            this.height = height;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public static AdSize fromName(String name) {
            for (AdSize e2 : AdSize.values()) {
                if (!e2.name.equals(name)) continue;
                return e2;
            }
            return VUNGLE_DEFAULT;
        }

        public static boolean isDefaultAdSize(@NonNull AdSize adSize) {
            return adSize == VUNGLE_DEFAULT || adSize == VUNGLE_MREC;
        }

        public static boolean isBannerAdSize(@NonNull AdSize adSize) {
            return adSize == BANNER || adSize == BANNER_LEADERBOARD || adSize == BANNER_SHORT || adSize == VUNGLE_MREC;
        }

        public static boolean isNonMrecBannerAdSize(@NonNull AdSize adSize) {
            return adSize != VUNGLE_MREC && AdSize.isBannerAdSize(adSize);
        }
    }

    public static @interface Settings {
    }
}

