/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren;

import androidx.annotation.Nullable;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.vungle.warren.model.JsonUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;

public final class AdMarkup
implements Serializable {
    private final String eventId;
    private final String[] impression;
    private final int version;

    private AdMarkup(String eventId, String[] impression, int version) {
        this.eventId = eventId;
        this.impression = impression;
        this.version = version;
    }

    @Nullable
    public String getEventId() {
        return this.eventId;
    }

    @Nullable
    public String[] getImpression() {
        return this.impression;
    }

    public int getVersion() {
        return this.version;
    }

    public String toString() {
        return "AdMarkup{eventId='" + this.eventId + '\'' + ", impression=" + Arrays.toString(this.impression) + ", version=" + this.version + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AdMarkup adMarkup = (AdMarkup)o;
        return this.eventId != null ? this.eventId.equals(adMarkup.eventId) : adMarkup.eventId == null;
    }

    public int hashCode() {
        return this.eventId != null ? this.eventId.hashCode() : 0;
    }

    @Nullable
    public static AdMarkup fromString(String string) {
        JsonArray jsonArray;
        JsonObject jsonObject;
        if (string == null) {
            return null;
        }
        try {
            jsonObject = (JsonObject)new GsonBuilder().create().fromJson(string, JsonObject.class);
        }
        catch (JsonSyntaxException ignored) {
            return null;
        }
        if (jsonObject == null) {
            return null;
        }
        ArrayList<String> impression = null;
        if (JsonUtil.hasNonNull((JsonElement)jsonObject, "impression") && (jsonArray = jsonObject.getAsJsonArray("impression")).isJsonArray()) {
            impression = new ArrayList<String>();
            for (JsonElement element : jsonArray.getAsJsonArray()) {
                impression.add(element.getAsString());
            }
        }
        return new AdMarkup(JsonUtil.getAsString((JsonElement)jsonObject, "event_id", null), impression != null ? impression.toArray(new String[0]) : null, JsonUtil.getAsInt((JsonElement)jsonObject, "version", 0));
    }
}

