/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.vungle.warren.AdConfig;
import com.vungle.warren.AdMarkup;
import com.vungle.warren.AdRequest;
import com.vungle.warren.BannerAdConfig;
import com.vungle.warren.LoadAdCallback;
import com.vungle.warren.PlayAdCallback;
import com.vungle.warren.PlayAdCallbackWrapper;
import com.vungle.warren.RuntimeValues;
import com.vungle.warren.ServiceLocator;
import com.vungle.warren.Vungle;
import com.vungle.warren.VungleBanner;
import com.vungle.warren.VungleLogger;
import com.vungle.warren.VungleSettings;
import com.vungle.warren.error.VungleException;
import com.vungle.warren.model.Advertisement;
import com.vungle.warren.model.Placement;
import com.vungle.warren.persistence.FutureResult;
import com.vungle.warren.persistence.Repository;
import com.vungle.warren.utility.Executors;
import com.vungle.warren.utility.TimeoutProvider;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

public final class Banners {
    private static final String TAG = Banners.class.getSimpleName();

    public static boolean canPlayAd(@NonNull String placementId, @NonNull AdConfig.AdSize adSize) {
        return Banners.canPlayAd(placementId, null, adSize);
    }

    public static boolean canPlayAd(final @NonNull String placementId, final @Nullable String markup, final @NonNull AdConfig.AdSize adSize) {
        if (!AdConfig.AdSize.isBannerAdSize(adSize)) {
            Log.e((String)TAG, (String)"Invalid Ad Size. Cannot check loaded status of non banner size placements.");
            return false;
        }
        final Context context = Vungle.appContext();
        if (context == null) {
            Log.e((String)TAG, (String)"Context is null");
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)placementId)) {
            Log.e((String)TAG, (String)"PlacementId is null");
            return false;
        }
        ServiceLocator serviceLocator = ServiceLocator.getInstance(context);
        Executors sdkExecutors = serviceLocator.getService(Executors.class);
        TimeoutProvider provider = serviceLocator.getService(TimeoutProvider.class);
        FutureResult<Boolean> futureResult = new FutureResult<Boolean>(sdkExecutors.getApiExecutor().submit(new Callable<Boolean>(){

            @Override
            public Boolean call() {
                boolean skipSizeCheck;
                if (!Vungle.isInitialized()) {
                    Log.e((String)TAG, (String)"Vungle is not initialized");
                    return false;
                }
                ServiceLocator serviceLocator = ServiceLocator.getInstance(context);
                Repository repository = serviceLocator.getService(Repository.class);
                AdRequest request = new AdRequest(placementId, AdMarkup.fromString(markup));
                Placement placement = repository.load(placementId, Placement.class).get();
                if (placement == null) {
                    return false;
                }
                if (placement.isMultipleHBPEnabled() && request.getEventId() == null) {
                    return false;
                }
                Advertisement advertisement = repository.findValidAdvertisementForPlacement(placementId, request.getEventId()).get();
                if (advertisement == null) {
                    return false;
                }
                AdConfig.AdSize plSize = placement.getAdSize();
                AdConfig.AdSize advSize = advertisement.getAdConfig().getAdSize();
                boolean bl = skipSizeCheck = adSize == AdConfig.AdSize.VUNGLE_MREC && AdConfig.AdSize.isDefaultAdSize(plSize) && AdConfig.AdSize.isDefaultAdSize(advSize) && placement.getPlacementAdType() == 3;
                if (placement.isMultipleHBPEnabled() && AdConfig.AdSize.isNonMrecBannerAdSize(plSize) && AdConfig.AdSize.isNonMrecBannerAdSize(advSize)) {
                    skipSizeCheck = true;
                }
                if (!(skipSizeCheck || adSize == plSize && adSize == advSize)) {
                    return false;
                }
                return Vungle.canPlayAd(advertisement);
            }
        }));
        return Boolean.TRUE.equals(futureResult.get(provider.getTimeout(), TimeUnit.MILLISECONDS));
    }

    @Deprecated
    @Nullable
    public static VungleBanner getBanner(@NonNull String placementId, @NonNull AdConfig.AdSize adSize, @Nullable PlayAdCallback playAdCallback) {
        return Banners.getBanner(placementId, new BannerAdConfig(adSize), playAdCallback);
    }

    @Nullable
    public static VungleBanner getBanner(@NonNull String placementId, @NonNull BannerAdConfig bannerAdConfig, @Nullable PlayAdCallback playAdCallback) {
        return Banners.getBanner(placementId, null, bannerAdConfig, playAdCallback);
    }

    @Nullable
    public static VungleBanner getBanner(final @NonNull String placementId, final @Nullable String markup, @NonNull BannerAdConfig bannerAdConfig, @Nullable PlayAdCallback playAdCallback) {
        int refreshDuration;
        VungleLogger.debug("VungleBanner#getBanner", "getBanner call invoked");
        Context appContext = Vungle.appContext();
        if (appContext == null) {
            Log.e((String)TAG, (String)"Vungle is not initialized, returned VungleNativeAd = null");
            Banners.onPlaybackError(placementId, playAdCallback, 9);
            return null;
        }
        final AdConfig.AdSize adSize = bannerAdConfig.getAdSize();
        final ServiceLocator serviceLocator = ServiceLocator.getInstance(appContext);
        Executors sdkExecutors = serviceLocator.getService(Executors.class);
        TimeoutProvider provider = serviceLocator.getService(TimeoutProvider.class);
        VungleSettings settings = ServiceLocator.getInstance((Context)appContext).getService(RuntimeValues.class).settings.get();
        final PlayAdCallbackWrapper listener = new PlayAdCallbackWrapper(sdkExecutors.getUIExecutor(), playAdCallback);
        FutureResult<Pair<Boolean, Placement>> futureResult = new FutureResult<Pair<Boolean, Placement>>(sdkExecutors.getBackgroundExecutor().submit(new Callable<Pair<Boolean, Placement>>(){

            @Override
            public Pair<Boolean, Placement> call() throws Exception {
                if (!Vungle.isInitialized()) {
                    Log.e((String)TAG, (String)"Vungle is not initialized.");
                    Banners.onPlaybackError(placementId, listener, 9);
                    return new Pair((Object)false, null);
                }
                if (TextUtils.isEmpty((CharSequence)placementId)) {
                    Banners.onPlaybackError(placementId, listener, 13);
                    return new Pair((Object)false, null);
                }
                Repository repository = serviceLocator.getService(Repository.class);
                Placement placement = repository.load(placementId, Placement.class).get();
                if (placement == null) {
                    Banners.onPlaybackError(placementId, listener, 13);
                    return new Pair((Object)false, null);
                }
                if (!AdConfig.AdSize.isBannerAdSize(adSize)) {
                    Banners.onPlaybackError(placementId, listener, 30);
                    return new Pair((Object)false, (Object)placement);
                }
                if (!Banners.canPlayAd(placementId, markup, adSize)) {
                    Banners.onPlaybackError(placementId, listener, 10);
                    return new Pair((Object)false, (Object)placement);
                }
                return new Pair((Object)true, (Object)placement);
            }
        }));
        Pair<Boolean, Placement> placementWillPlay = futureResult.get(provider.getTimeout(), TimeUnit.MILLISECONDS);
        if (placementWillPlay == null) {
            Banners.onPlaybackError(placementId, playAdCallback, 13);
            return null;
        }
        boolean canPlay = (Boolean)placementWillPlay.first;
        if (!canPlay) {
            return null;
        }
        int n = refreshDuration = adSize != AdConfig.AdSize.VUNGLE_MREC ? ((Placement)placementWillPlay.second).getAdRefreshDuration() : 0;
        if (settings != null && settings.getBannerRefreshDisabled()) {
            refreshDuration = 0;
        }
        return new VungleBanner(appContext, placementId, AdMarkup.fromString(markup), refreshDuration, bannerAdConfig, playAdCallback);
    }

    public static void loadBanner(@NonNull String placementId, @NonNull BannerAdConfig bannerAdConfig, @Nullable LoadAdCallback callback) {
        Banners.loadBanner(placementId, null, bannerAdConfig, callback);
    }

    @Deprecated
    public static void loadBanner(@NonNull String placementId, @NonNull AdConfig.AdSize adSize, @Nullable LoadAdCallback callback) {
        if (adSize == null) {
            Banners.onLoadError(placementId, callback, 28);
            return;
        }
        Banners.loadBanner(placementId, new BannerAdConfig(adSize), callback);
    }

    public static void loadBanner(@NonNull String placementId, @Nullable String markup, @NonNull BannerAdConfig bannerAdConfig, @Nullable LoadAdCallback callback) {
        VungleLogger.debug("Banners#loadBanner", "loadBanner API call invoked");
        Context appCtx = Vungle.appContext();
        if (appCtx == null || !Vungle.isInitialized()) {
            Banners.onLoadError(placementId, callback, 9);
            return;
        }
        AdConfig adConfig = new AdConfig(bannerAdConfig);
        if (!AdConfig.AdSize.isBannerAdSize(adConfig.getAdSize())) {
            Banners.onLoadError(placementId, callback, 30);
            return;
        }
        Vungle.loadAdInternal(placementId, AdMarkup.fromString(markup), adConfig, callback);
    }

    private static void onPlaybackError(@NonNull String placementId, @Nullable PlayAdCallback playAdCallback, @VungleException.ExceptionCode int code) {
        VungleException ex = new VungleException(code);
        if (playAdCallback != null) {
            playAdCallback.onError(placementId, ex);
        }
        VungleLogger.error("Banners#onPlaybackError", "Banner play error: " + ex.getLocalizedMessage());
    }

    private static void onLoadError(@NonNull String placementId, @Nullable LoadAdCallback callback, @VungleException.ExceptionCode int code) {
        VungleException ex = new VungleException(code);
        if (callback != null) {
            callback.onError(placementId, ex);
        }
        VungleLogger.error("Banners#onLoadError", "Banner load error: " + ex.getLocalizedMessage());
    }
}

