/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren;

import android.os.Bundle;
import android.os.SystemClock;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.vungle.warren.CacheBustCallback;
import com.vungle.warren.VungleLogger;
import com.vungle.warren.tasks.CacheBustJob;
import com.vungle.warren.tasks.CleanupJob;
import com.vungle.warren.tasks.JobRunner;
import com.vungle.warren.utility.ActivityManager;

public class CacheBustManager
implements CacheBustCallback {
    public static final String NEXT_CACHE_BUST = "next_cache_bust";
    public static final String CACHE_BUST_INTERVAL = "cache_bust_interval";
    public static final int NO_VALUE = Integer.MIN_VALUE;
    private JobRunner jobRunner;
    private static final int DEFAULT_REFRESH_RATE = 0;
    @VisibleForTesting
    long refreshRate = 0L;
    private long overrideRefreshRate = Integer.MIN_VALUE;
    @VisibleForTesting
    static final long MINIMUM_REFRESH_RATE = 900000L;
    private boolean hasStopped;

    protected CacheBustManager(@NonNull JobRunner runner) {
        this.jobRunner = runner;
        if (ActivityManager.getInstance().isInitialized()) {
            this.setLifecycleListener();
        } else {
            Log.e((String)CacheBustManager.class.getSimpleName(), (String)"No lifecycle listener set");
            VungleLogger.error(CacheBustManager.class.getSimpleName() + "#deliverError", "No lifecycle listener set");
        }
    }

    public void startBust() {
        if (this.refreshRate == 0L) {
            this.jobRunner.execute(CacheBustJob.makeJobInfo());
        } else {
            Bundle bundle = new Bundle();
            bundle.putLong(CACHE_BUST_INTERVAL, this.refreshRate);
            bundle.putLong(NEXT_CACHE_BUST, SystemClock.elapsedRealtime() + this.refreshRate);
            this.jobRunner.execute(CacheBustJob.makeJobInfo().setReschedulePolicy(this.refreshRate, 0).setExtras(bundle));
        }
    }

    @VisibleForTesting
    void overrideRefreshRate(long refreshRate) {
        this.overrideRefreshRate = refreshRate;
        this.refreshRate = refreshRate;
    }

    public void setRefreshRate(long refreshRate) {
        if (this.overrideRefreshRate != Integer.MIN_VALUE) {
            this.refreshRate = this.overrideRefreshRate;
            return;
        }
        this.refreshRate = refreshRate > 0L ? Math.max(refreshRate, 900000L) : 0L;
    }

    @Override
    public void onCacheBust() {
        this.jobRunner.execute(CleanupJob.makeJobInfo());
    }

    private void setLifecycleListener() {
        ActivityManager.getInstance().addListener(new ActivityManager.LifeCycleCallback(){

            @Override
            public void onStart() {
                super.onStart();
                if (CacheBustManager.this.hasStopped && CacheBustManager.this.refreshRate != 0L) {
                    CacheBustManager.this.hasStopped = false;
                    Bundle bundle = new Bundle();
                    bundle.putLong(CacheBustManager.CACHE_BUST_INTERVAL, CacheBustManager.this.refreshRate);
                    bundle.putLong(CacheBustManager.NEXT_CACHE_BUST, SystemClock.elapsedRealtime() + CacheBustManager.this.refreshRate);
                    CacheBustManager.this.jobRunner.execute(CacheBustJob.makeJobInfo().setDelay(CacheBustManager.this.refreshRate).setReschedulePolicy(CacheBustManager.this.refreshRate, 0).setExtras(bundle));
                }
            }

            @Override
            public void onStop() {
                super.onStop();
                CacheBustManager.this.jobRunner.cancelPendingJob(CacheBustJob.TAG);
                CacheBustManager.this.hasStopped = true;
            }
        });
    }
}

