/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren;

import androidx.annotation.Nullable;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.SerializedName;
import com.vungle.warren.model.JsonUtil;

public class CleverCacheSettings {
    static final String KEY_ENABLED = "enabled";
    static final String KEY_TIMESTAMP = "clear_shared_cache_timestamp";
    static final String KEY_CLEVER_CACHE = "clever_cache";
    static final boolean DEFAULT_ENABLED = true;
    static final long DEFAULT_TIMESTAMP = -1L;
    @SerializedName(value="enabled")
    private final boolean enabled;
    @SerializedName(value="clear_shared_cache_timestamp")
    private final long timestamp;

    private CleverCacheSettings(boolean enabled, long timestamp) {
        this.enabled = enabled;
        this.timestamp = timestamp;
    }

    public String serializeToString() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add(KEY_CLEVER_CACHE, new GsonBuilder().create().toJsonTree((Object)this));
        return jsonObject.toString();
    }

    @Nullable
    public static CleverCacheSettings fromJson(JsonObject jsonObject) {
        JsonElement element;
        if (!JsonUtil.hasNonNull((JsonElement)jsonObject, KEY_CLEVER_CACHE)) {
            return null;
        }
        long timestamp = -1L;
        boolean enabled = true;
        JsonObject ccSettings = jsonObject.getAsJsonObject(KEY_CLEVER_CACHE);
        try {
            if (ccSettings.has(KEY_TIMESTAMP)) {
                timestamp = ccSettings.get(KEY_TIMESTAMP).getAsLong();
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (ccSettings.has(KEY_ENABLED) && (element = ccSettings.get(KEY_ENABLED)).isJsonPrimitive() && "false".equalsIgnoreCase(element.getAsString())) {
            enabled = false;
        }
        return new CleverCacheSettings(enabled, timestamp);
    }

    @Nullable
    static CleverCacheSettings deserializeFromString(String input) {
        JsonObject jsonObject;
        if (input == null) {
            return null;
        }
        try {
            jsonObject = (JsonObject)new GsonBuilder().create().fromJson(input, JsonObject.class);
        }
        catch (JsonSyntaxException ex) {
            return null;
        }
        return CleverCacheSettings.fromJson(jsonObject);
    }

    static CleverCacheSettings getDefault() {
        return new CleverCacheSettings(true, -1L);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CleverCacheSettings settings = (CleverCacheSettings)o;
        if (this.enabled != settings.enabled) {
            return false;
        }
        return this.timestamp == settings.timestamp;
    }

    public int hashCode() {
        int result = this.enabled ? 1 : 0;
        result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
        return result;
    }
}

