/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.vungle.warren.AdLoader;
import com.vungle.warren.AdRequest;
import com.vungle.warren.error.VungleException;
import com.vungle.warren.model.Advertisement;
import com.vungle.warren.model.Placement;
import java.util.concurrent.ExecutorService;

class DownloadCallbackWrapper
implements AdLoader.DownloadCallback {
    private final AdLoader.DownloadCallback downloadCallback;
    private final ExecutorService executorService;

    public DownloadCallbackWrapper(ExecutorService executorService, AdLoader.DownloadCallback downloadCallback) {
        this.downloadCallback = downloadCallback;
        this.executorService = executorService;
    }

    @Override
    public void onDownloadCompleted(final @NonNull AdRequest request, final @NonNull String advertisementId) {
        if (this.downloadCallback == null) {
            return;
        }
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                DownloadCallbackWrapper.this.downloadCallback.onDownloadCompleted(request, advertisementId);
            }
        });
    }

    @Override
    public void onDownloadFailed(final @NonNull VungleException exception, final @NonNull AdRequest request, final @Nullable String advertisementId) {
        if (this.downloadCallback == null) {
            return;
        }
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                DownloadCallbackWrapper.this.downloadCallback.onDownloadFailed(exception, request, advertisementId);
            }
        });
    }

    @Override
    public void onReady(final @NonNull AdRequest request, final @NonNull Placement placement, final @Nullable Advertisement advertisement) {
        if (this.downloadCallback == null) {
            return;
        }
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                DownloadCallbackWrapper.this.downloadCallback.onReady(request, placement, advertisement);
            }
        });
    }
}

