/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren;

import com.vungle.warren.LoadAdCallback;
import com.vungle.warren.error.VungleException;
import java.util.concurrent.ExecutorService;

class LoadAdCallbackWrapper
implements LoadAdCallback {
    private final LoadAdCallback loadAdCallback;
    private final ExecutorService executorService;

    public LoadAdCallbackWrapper(ExecutorService executorService, LoadAdCallback loadAdCallback) {
        this.loadAdCallback = loadAdCallback;
        this.executorService = executorService;
    }

    @Override
    public void onAdLoad(final String placementId) {
        if (this.loadAdCallback == null) {
            return;
        }
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                LoadAdCallbackWrapper.this.loadAdCallback.onAdLoad(placementId);
            }
        });
    }

    @Override
    public void onError(final String placementId, final VungleException exception) {
        if (this.loadAdCallback == null) {
            return;
        }
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                LoadAdCallbackWrapper.this.loadAdCallback.onError(placementId, exception);
            }
        });
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LoadAdCallbackWrapper that = (LoadAdCallbackWrapper)o;
        if (this.loadAdCallback != null ? !this.loadAdCallback.equals(that.loadAdCallback) : that.loadAdCallback != null) {
            return false;
        }
        return this.executorService != null ? this.executorService.equals(that.executorService) : that.executorService == null;
    }

    public int hashCode() {
        int result = this.loadAdCallback != null ? this.loadAdCallback.hashCode() : 0;
        result = 31 * result + (this.executorService != null ? this.executorService.hashCode() : 0);
        return result;
    }
}

