/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren;

import android.annotation.SuppressLint;
import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.vungle.warren.AdLoader;
import com.vungle.warren.AdvertisementPresentationFactory;
import com.vungle.warren.CacheBustManager;
import com.vungle.warren.DownloaderSizeProvider;
import com.vungle.warren.OperationSequence;
import com.vungle.warren.PresentationFactory;
import com.vungle.warren.RuntimeValues;
import com.vungle.warren.VisionController;
import com.vungle.warren.Vungle;
import com.vungle.warren.VungleApiClient;
import com.vungle.warren.VungleJobRunner;
import com.vungle.warren.VungleStaticApi;
import com.vungle.warren.analytics.VungleAnalytics;
import com.vungle.warren.downloader.AssetDownloader;
import com.vungle.warren.downloader.CleverCache;
import com.vungle.warren.downloader.Downloader;
import com.vungle.warren.downloader.DownloaderCache;
import com.vungle.warren.downloader.LRUCachePolicy;
import com.vungle.warren.log.LogManager;
import com.vungle.warren.omsdk.OMInjector;
import com.vungle.warren.omsdk.OMTracker;
import com.vungle.warren.persistence.CacheManager;
import com.vungle.warren.persistence.Designer;
import com.vungle.warren.persistence.FilePreferences;
import com.vungle.warren.persistence.GraphicDesigner;
import com.vungle.warren.persistence.Repository;
import com.vungle.warren.tasks.JobCreator;
import com.vungle.warren.tasks.JobRunner;
import com.vungle.warren.tasks.ReconfigJob;
import com.vungle.warren.tasks.VungleJobCreator;
import com.vungle.warren.tasks.utility.JobRunnerThreadPriorityHelper;
import com.vungle.warren.utility.AppSession;
import com.vungle.warren.utility.ConcurrencyTimeoutProvider;
import com.vungle.warren.utility.Executors;
import com.vungle.warren.utility.NetworkProvider;
import com.vungle.warren.utility.SDKExecutors;
import com.vungle.warren.utility.TimeoutProvider;
import com.vungle.warren.utility.platform.AndroidPlatform;
import com.vungle.warren.utility.platform.Platform;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

class ServiceLocator {
    @SuppressLint(value={"StaticFieldLeak"})
    private static ServiceLocator INSTANCE;
    private final Context ctx;
    private Map<Class, Creator> creators = new HashMap<Class, Creator>();
    private Map<Class, Object> cache = new HashMap<Class, Object>();
    @VisibleForTesting
    static final VungleStaticApi VUNGLE_STATIC_API;
    private static final ReconfigJob.ReconfigCall RECONFIG_CALL;

    private ServiceLocator(@NonNull Context context) {
        this.ctx = context.getApplicationContext();
        this.buildCreators();
    }

    static synchronized ServiceLocator getInstance(@NonNull Context context) {
        if (INSTANCE == null) {
            INSTANCE = new ServiceLocator(context);
        }
        return INSTANCE;
    }

    static synchronized void deInit() {
        INSTANCE = null;
    }

    synchronized <T> T getService(Class<T> serviceClass) {
        return this.getOrBuild(serviceClass);
    }

    synchronized <T> boolean isCreated(Class<T> serviceClass) {
        return this.cache.containsKey(this.getServiceClass(serviceClass));
    }

    private <T> T getOrBuild(@NonNull Class<T> serviceClass) {
        Class target = this.getServiceClass(serviceClass);
        Object value = this.cache.get(target);
        if (value == null) {
            Creator creator = this.creators.get(target);
            if (creator == null) {
                throw new IllegalArgumentException("Unknown class");
            }
            value = creator.create();
            if (creator.isSingleton()) {
                this.cache.put(target, value);
            }
        }
        return (T)value;
    }

    @NonNull
    private Class getServiceClass(@NonNull Class serviceClass) {
        for (Class clazz : this.creators.keySet()) {
            if (!clazz.isAssignableFrom(serviceClass)) continue;
            return clazz;
        }
        throw new IllegalArgumentException("Unknown dependency for " + serviceClass);
    }

    @VisibleForTesting
    synchronized <T> void bindService(Class<T> tClass, T service) {
        Class target = this.getServiceClass(tClass);
        this.cache.put(target, service);
    }

    private void buildCreators() {
        this.creators.put(JobCreator.class, new Creator(){

            public JobCreator create() {
                return new VungleJobCreator((Repository)ServiceLocator.this.getOrBuild(Repository.class), (Designer)ServiceLocator.this.getOrBuild(Designer.class), (VungleApiClient)ServiceLocator.this.getOrBuild(VungleApiClient.class), new VungleAnalytics((VungleApiClient)ServiceLocator.this.getOrBuild(VungleApiClient.class), (Repository)ServiceLocator.this.getOrBuild(Repository.class)), RECONFIG_CALL, (AdLoader)ServiceLocator.this.getOrBuild(AdLoader.class), VUNGLE_STATIC_API, (LogManager)ServiceLocator.this.getOrBuild(LogManager.class), ((Executors)ServiceLocator.this.getOrBuild(Executors.class)).getBackgroundExecutor());
            }
        });
        this.creators.put(JobRunner.class, new Creator(){

            public JobRunner create() {
                return new VungleJobRunner((JobCreator)ServiceLocator.this.getOrBuild(JobCreator.class), ((Executors)ServiceLocator.this.getOrBuild(Executors.class)).getJobExecutor(), new JobRunnerThreadPriorityHelper(), NetworkProvider.getInstance(ServiceLocator.this.ctx));
            }
        });
        this.creators.put(AdLoader.class, new Creator(){

            public AdLoader create() {
                return new AdLoader((Executors)ServiceLocator.this.getOrBuild(Executors.class), (Repository)ServiceLocator.this.getOrBuild(Repository.class), (VungleApiClient)ServiceLocator.this.getOrBuild(VungleApiClient.class), (CacheManager)ServiceLocator.this.getOrBuild(CacheManager.class), (Downloader)ServiceLocator.this.getOrBuild(Downloader.class), (RuntimeValues)ServiceLocator.this.getOrBuild(RuntimeValues.class), (VungleStaticApi)ServiceLocator.this.getOrBuild(VungleStaticApi.class), (VisionController)ServiceLocator.this.getOrBuild(VisionController.class), (OperationSequence)ServiceLocator.this.getOrBuild(OperationSequence.class), (OMInjector)ServiceLocator.this.getOrBuild(OMInjector.class));
            }
        });
        this.creators.put(Downloader.class, new Creator(){

            public Downloader create() {
                return new AssetDownloader((DownloaderCache)ServiceLocator.this.getOrBuild(DownloaderCache.class), AssetDownloader.VERIFICATION_WINDOW, 4, NetworkProvider.getInstance(ServiceLocator.this.ctx), ((Executors)ServiceLocator.this.getOrBuild(Executors.class)).getUIExecutor());
            }
        });
        this.creators.put(VungleApiClient.class, new Creator(){

            public VungleApiClient create() {
                return new VungleApiClient(ServiceLocator.this.ctx, (CacheManager)ServiceLocator.this.getOrBuild(CacheManager.class), (Repository)ServiceLocator.this.getOrBuild(Repository.class), (OMInjector)ServiceLocator.this.getOrBuild(OMInjector.class));
            }
        });
        this.creators.put(Repository.class, new Creator(){

            public Repository create() {
                Executors sdkExecutors = (Executors)ServiceLocator.this.getOrBuild(Executors.class);
                return new Repository(ServiceLocator.this.ctx, (Designer)ServiceLocator.this.getOrBuild(Designer.class), sdkExecutors.getIOExecutor(), sdkExecutors.getUIExecutor());
            }
        });
        this.creators.put(LogManager.class, new Creator(){

            Object create() {
                Executors sdkExecutors = (Executors)ServiceLocator.this.getOrBuild(Executors.class);
                return new LogManager(ServiceLocator.this.ctx, (CacheManager)ServiceLocator.this.getOrBuild(CacheManager.class), (VungleApiClient)ServiceLocator.this.getOrBuild(VungleApiClient.class), (Executor)sdkExecutors.getLoggerExecutor(), (FilePreferences)ServiceLocator.this.getOrBuild(FilePreferences.class));
            }
        });
        this.creators.put(Designer.class, new Creator(){

            public Designer create() {
                return new GraphicDesigner((CacheManager)ServiceLocator.this.getOrBuild(CacheManager.class));
            }
        });
        this.creators.put(CacheManager.class, new Creator(){

            public CacheManager create() {
                return new CacheManager(ServiceLocator.this.ctx, (FilePreferences)ServiceLocator.this.getOrBuild(FilePreferences.class));
            }
        });
        this.creators.put(Platform.class, new Creator<Platform>(){

            @Override
            public Platform create() {
                return new AndroidPlatform();
            }
        });
        this.creators.put(Executors.class, new Creator(){

            public Executors create() {
                return new SDKExecutors();
            }
        });
        this.creators.put(RuntimeValues.class, new Creator(){

            public RuntimeValues create() {
                return new RuntimeValues();
            }
        });
        this.creators.put(VungleStaticApi.class, new Creator(){

            public VungleStaticApi create() {
                return VUNGLE_STATIC_API;
            }
        });
        this.creators.put(PresentationFactory.class, new Creator(){

            public PresentationFactory create() {
                return new AdvertisementPresentationFactory((AdLoader)ServiceLocator.this.getOrBuild(AdLoader.class), (VungleStaticApi)ServiceLocator.this.getOrBuild(VungleStaticApi.class), (Repository)ServiceLocator.this.getOrBuild(Repository.class), (VungleApiClient)ServiceLocator.this.getOrBuild(VungleApiClient.class), (JobRunner)ServiceLocator.this.getOrBuild(JobRunner.class), (RuntimeValues)ServiceLocator.this.getOrBuild(RuntimeValues.class), (OMTracker.Factory)ServiceLocator.this.getOrBuild(OMTracker.Factory.class), ((Executors)ServiceLocator.this.getOrBuild(Executors.class)).getTaskExecutor());
            }

            @Override
            boolean isSingleton() {
                return false;
            }
        });
        this.creators.put(DownloaderCache.class, new Creator(){

            Object create() {
                CacheManager cacheManager = (CacheManager)ServiceLocator.this.getOrBuild(CacheManager.class);
                return new CleverCache(cacheManager, new LRUCachePolicy(cacheManager, "clever_cache"), new DownloaderSizeProvider(cacheManager, (RuntimeValues)ServiceLocator.this.getOrBuild(RuntimeValues.class), 0.1f), TimeUnit.DAYS.toMillis(90L));
            }
        });
        this.creators.put(VisionController.class, new Creator(){

            public VisionController create() {
                return new VisionController((Repository)ServiceLocator.this.getOrBuild(Repository.class), NetworkProvider.getInstance(ServiceLocator.this.ctx));
            }
        });
        this.creators.put(TimeoutProvider.class, new Creator(){

            public TimeoutProvider create() {
                return new ConcurrencyTimeoutProvider();
            }
        });
        this.creators.put(OperationSequence.class, new Creator(){

            public OperationSequence create() {
                return new OperationSequence();
            }
        });
        this.creators.put(AppSession.class, new Creator<AppSession>(){

            @Override
            AppSession create() {
                return new AppSession();
            }
        });
        this.creators.put(OMInjector.class, new Creator<OMInjector>(){

            @Override
            public OMInjector create() {
                return new OMInjector(ServiceLocator.this.ctx);
            }
        });
        this.creators.put(OMTracker.Factory.class, new Creator<OMTracker.Factory>(){

            @Override
            public OMTracker.Factory create() {
                return new OMTracker.Factory();
            }
        });
        this.creators.put(CacheBustManager.class, new Creator<CacheBustManager>(){

            @Override
            public CacheBustManager create() {
                return new CacheBustManager((JobRunner)ServiceLocator.this.getOrBuild(JobRunner.class));
            }
        });
        this.creators.put(FilePreferences.class, new Creator<FilePreferences>(){

            @Override
            public FilePreferences create() {
                return new FilePreferences(ServiceLocator.this.ctx, ((Executors)ServiceLocator.this.getOrBuild(Executors.class)).getIOExecutor());
            }
        });
    }

    static {
        VUNGLE_STATIC_API = new VungleStaticApi(){

            @Override
            public boolean isInitialized() {
                return Vungle.isInitialized();
            }

            @Override
            public Collection<String> getValidPlacements() {
                return Vungle.getValidPlacements();
            }
        };
        RECONFIG_CALL = new ReconfigJob.ReconfigCall(){

            @Override
            public void reConfigVungle() {
                Vungle.reConfigure();
            }
        };
    }

    private abstract class Creator<T> {
        private Creator() {
        }

        abstract T create();

        boolean isSingleton() {
            return true;
        }
    }
}

