/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren;

import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.vungle.warren.tasks.JobCreator;
import com.vungle.warren.tasks.JobInfo;
import com.vungle.warren.tasks.JobRunner;
import com.vungle.warren.tasks.runnable.JobRunnable;
import com.vungle.warren.tasks.utility.ThreadPriorityHelper;
import com.vungle.warren.utility.NetworkProvider;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;

class VungleJobRunner
implements JobRunner {
    private static Handler handler = new Handler(Looper.getMainLooper());
    private static final String TAG = VungleJobRunner.class.getSimpleName();
    private final ThreadPriorityHelper threadPriorityHelper;
    private final NetworkProvider networkProvider;
    private JobCreator creator;
    private Executor executor;
    private List<PendingJob> pendingJobs;
    private Runnable pendingRunnable;
    private long nextCheck = Long.MAX_VALUE;
    private final NetworkProvider.NetworkListener networkListener = new NetworkProvider.NetworkListener(){

        @Override
        public void onChanged(int type) {
            VungleJobRunner.this.executePendingJobs();
        }
    };

    VungleJobRunner(@NonNull JobCreator jobCreator, @NonNull Executor executor, @Nullable ThreadPriorityHelper threadPriorityHelper, @NonNull NetworkProvider networkProvider) {
        this.creator = jobCreator;
        this.executor = executor;
        this.threadPriorityHelper = threadPriorityHelper;
        this.pendingJobs = new CopyOnWriteArrayList<PendingJob>();
        this.networkProvider = networkProvider;
        this.pendingRunnable = new PendingRunnable(new WeakReference<VungleJobRunner>(this));
    }

    @Override
    public synchronized void execute(@NonNull JobInfo jobInfo) {
        JobInfo jobInfoCopy = jobInfo.copy();
        String jobTag = jobInfoCopy.getJobTag();
        long delay = jobInfoCopy.getDelay();
        jobInfoCopy.setDelay(0L);
        if (jobInfoCopy.getUpdateCurrent()) {
            for (PendingJob job : this.pendingJobs) {
                if (!job.info.getJobTag().equals(jobTag)) continue;
                Log.d((String)TAG, (String)("replacing pending job with new " + jobTag));
                this.pendingJobs.remove(job);
            }
        }
        this.pendingJobs.add(new PendingJob(SystemClock.uptimeMillis() + delay, jobInfoCopy));
        this.executePendingJobs();
    }

    @Override
    public synchronized void cancelPendingJob(@NonNull String tag) {
        ArrayList<PendingJob> jobsToRemove = new ArrayList<PendingJob>();
        for (PendingJob pendingJob : this.pendingJobs) {
            if (!pendingJob.info.getJobTag().equals(tag)) continue;
            jobsToRemove.add(pendingJob);
        }
        this.pendingJobs.removeAll(jobsToRemove);
    }

    private synchronized void executePendingJobs() {
        long now = SystemClock.uptimeMillis();
        long nextCheck = Long.MAX_VALUE;
        long waitingForNetwork = 0L;
        for (PendingJob job : this.pendingJobs) {
            if (now >= job.uptimeMillis) {
                boolean canRun = true;
                if (job.info.getRequiredNetworkType() == 1 && this.networkProvider.getCurrentNetworkType() == -1) {
                    canRun = false;
                    ++waitingForNetwork;
                }
                if (!canRun) continue;
                this.pendingJobs.remove(job);
                this.executor.execute(new JobRunnable(job.info, this.creator, this, this.threadPriorityHelper));
                continue;
            }
            nextCheck = Math.min(nextCheck, job.uptimeMillis);
        }
        if (nextCheck != Long.MAX_VALUE && nextCheck != this.nextCheck) {
            handler.removeCallbacks(this.pendingRunnable);
            handler.postAtTime(this.pendingRunnable, (Object)TAG, nextCheck);
        }
        this.nextCheck = nextCheck;
        if (waitingForNetwork > 0L) {
            this.networkProvider.addListener(this.networkListener);
        } else {
            this.networkProvider.removeListener(this.networkListener);
        }
    }

    private static class PendingRunnable
    implements Runnable {
        WeakReference<VungleJobRunner> runner;

        PendingRunnable(WeakReference<VungleJobRunner> runner) {
            this.runner = runner;
        }

        @Override
        public void run() {
            VungleJobRunner ref = (VungleJobRunner)this.runner.get();
            if (ref != null) {
                ref.executePendingJobs();
            }
        }
    }

    private static class PendingJob {
        private final long uptimeMillis;
        JobInfo info;

        PendingJob(long uptimeMillis, JobInfo info) {
            this.uptimeMillis = uptimeMillis;
            this.info = info;
        }
    }
}

