/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren;

import android.util.Log;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.vungle.warren.log.LogManager;

public class VungleLogger {
    private static final String TAG = VungleLogger.class.getSimpleName();
    private static final VungleLogger _instance = new VungleLogger();
    public static final int LOGGER_MAX_ENTRIES = 100;
    private LoggerLevel loggingLevel = LoggerLevel.DEBUG;
    private LogManager logManager;

    private VungleLogger() {
    }

    static void setupLoggerWithLogLevel(@NonNull LogManager logManager, @NonNull LoggerLevel level, int maxEntries) {
        VungleLogger._instance.loggingLevel = level;
        VungleLogger._instance.logManager = logManager;
        VungleLogger._instance.logManager.setMaxEntries(maxEntries);
    }

    public static void verbose(@NonNull String context, @NonNull String message) {
        VungleLogger.log(LoggerLevel.VERBOSE, context, message);
    }

    public static void verbose(boolean withConsoleLog, @Nullable String tag, @NonNull String context, @NonNull String message) {
        if (withConsoleLog) {
            Log.v((String)tag, (String)("[" + context + "] " + message));
        }
        VungleLogger.verbose(context, message);
    }

    public static void info(@NonNull String context, @NonNull String message) {
        VungleLogger.log(LoggerLevel.INFO, context, message);
    }

    public static void info(boolean withConsoleLog, @Nullable String tag, @NonNull String context, @NonNull String message) {
        if (withConsoleLog) {
            Log.i((String)tag, (String)("[" + context + "] " + message));
        }
        VungleLogger.info(context, message);
    }

    public static void debug(@NonNull String context, @NonNull String message) {
        VungleLogger.log(LoggerLevel.DEBUG, context, message);
    }

    public static void debug(boolean withConsoleLog, @Nullable String tag, @NonNull String context, @NonNull String message) {
        if (withConsoleLog) {
            Log.d((String)tag, (String)("[" + context + "] " + message));
        }
        VungleLogger.debug(context, message);
    }

    public static void warn(@NonNull String context, @NonNull String message) {
        VungleLogger.log(LoggerLevel.WARNING, context, message);
    }

    public static void warn(boolean withConsoleLog, @Nullable String tag, @NonNull String context, @NonNull String message) {
        if (withConsoleLog) {
            Log.w((String)tag, (String)("[" + context + "] " + message));
        }
        VungleLogger.warn(context, message);
    }

    public static void error(@NonNull String context, @NonNull String message) {
        VungleLogger.log(LoggerLevel.ERROR, context, message);
    }

    public static void error(boolean withConsoleLog, @Nullable String tag, @NonNull String context, @NonNull String message) {
        if (withConsoleLog) {
            Log.e((String)tag, (String)("[" + context + "] " + message));
        }
        VungleLogger.error(context, message);
    }

    public static void addCustomData(@NonNull String key, @NonNull String value) {
        if (VungleLogger._instance.logManager == null) {
            Log.d((String)TAG, (String)"Please setup Logger first.");
            return;
        }
        VungleLogger._instance.logManager.addCustomData(key, value);
    }

    public static void removeCustomData(@NonNull String key) {
        if (VungleLogger._instance.logManager == null) {
            Log.d((String)TAG, (String)"Please setup Logger first.");
            return;
        }
        VungleLogger._instance.logManager.removeCustomData(key);
    }

    private static boolean isLoggable(@NonNull LoggerLevel level) {
        return level.level >= VungleLogger._instance.loggingLevel.level;
    }

    private static void log(@NonNull LoggerLevel level, @NonNull String context, @NonNull String message) {
        if (VungleLogger._instance.logManager == null) {
            Log.d((String)TAG, (String)"Please setup Logger first.");
            return;
        }
        if (!VungleLogger._instance.logManager.isLoggingEnabled()) {
            return;
        }
        if (!VungleLogger.isLoggable(level)) {
            return;
        }
        VungleLogger._instance.logManager.saveLog(level, context, message, null, null);
    }

    @Keep
    public static enum LoggerLevel {
        VERBOSE(0, "verbose"),
        DEBUG(1, "debug"),
        INFO(2, "info"),
        WARNING(3, "warn"),
        ERROR(4, "error"),
        CRASH(5, "crash");

        private int level;
        private String levelString;

        private LoggerLevel(int level, String levelString) {
            this.level = level;
            this.levelString = levelString;
        }

        @NonNull
        public String toString() {
            return this.levelString;
        }
    }
}

