/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren.analytics;

import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import com.google.gson.JsonObject;
import com.vungle.warren.VungleApiClient;
import com.vungle.warren.analytics.AdAnalytics;
import com.vungle.warren.model.AnalyticUrl;
import com.vungle.warren.network.Call;
import com.vungle.warren.network.Callback;
import com.vungle.warren.network.Response;
import com.vungle.warren.persistence.DatabaseHelper;
import com.vungle.warren.persistence.Repository;
import com.vungle.warren.utility.VungleUrlUtility;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;

public class VungleAnalytics
implements AdAnalytics {
    private static final String TAG = VungleAnalytics.class.getSimpleName();
    private final VungleApiClient client;
    private final Repository repository;

    public VungleAnalytics(VungleApiClient client, Repository repository) {
        this.client = client;
        this.repository = repository;
    }

    @Override
    public String[] ping(@NonNull String[] urls) {
        if (urls.length == 0) {
            return urls;
        }
        ArrayList<String> failed = new ArrayList<String>();
        for (String url : urls) {
            if (TextUtils.isEmpty((CharSequence)url)) continue;
            try {
                if (!this.client.pingTPAT(url)) {
                    failed.add(url);
                    continue;
                }
                this.repository.delete(new AnalyticUrl(url));
            }
            catch (VungleApiClient.ClearTextTrafficException e2) {
                Log.e((String)TAG, (String)("Cleartext Network Traffic is Blocked : " + url));
            }
            catch (MalformedURLException e3) {
                try {
                    this.repository.delete(new AnalyticUrl(url));
                }
                catch (DatabaseHelper.DBException dbException) {
                    Log.e((String)TAG, (String)("DBException deleting : " + url));
                }
                Log.e((String)TAG, (String)("Invalid Url : " + url));
            }
            catch (DatabaseHelper.DBException e4) {
                Log.e((String)TAG, (String)("Can't delete sent ping URL : " + url));
            }
        }
        return failed.toArray(new String[0]);
    }

    @Override
    public void ri(JsonObject object) {
        if (object == null) {
            return;
        }
        this.client.ri(object).enqueue(new Callback<JsonObject>(){

            @Override
            public void onResponse(@NonNull Call<JsonObject> call, Response<JsonObject> response) {
                Log.d((String)TAG, (String)"send RI success");
            }

            @Override
            public void onFailure(Call<JsonObject> call, Throwable t) {
                Log.d((String)TAG, (String)"send RI Failure");
            }
        });
    }

    @Override
    public String[] retryUnsent() {
        List<AnalyticUrl> analyticUrls = this.repository.loadAll(AnalyticUrl.class).get();
        if (analyticUrls != null && analyticUrls.size() > 0) {
            String[] urls = new String[analyticUrls.size()];
            for (int i = 0; i < urls.length; ++i) {
                urls[i] = analyticUrls.get((int)i).url;
            }
            return this.ping(urls);
        }
        return new String[0];
    }

    @Override
    public void saveVungleUrls(String[] urls) {
        for (String url : urls) {
            if (!VungleUrlUtility.isVungleUrl(url)) continue;
            try {
                this.repository.save(new AnalyticUrl(url));
            }
            catch (DatabaseHelper.DBException e2) {
                Log.e((String)TAG, (String)("Can't save failed to ping URL : " + url));
            }
        }
    }
}

