/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren.downloader;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.core.util.Pair;
import com.vungle.warren.VungleLogger;
import com.vungle.warren.downloader.AssetDownloadListener;
import com.vungle.warren.downloader.AssetPriority;
import com.vungle.warren.downloader.DownloadRequest;
import com.vungle.warren.downloader.DownloadRequestMediator;
import com.vungle.warren.downloader.Downloader;
import com.vungle.warren.downloader.DownloaderCache;
import com.vungle.warren.downloader.RangeResponse;
import com.vungle.warren.utility.FileUtility;
import com.vungle.warren.utility.NetworkProvider;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLException;
import okhttp3.Headers;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.http.HttpHeaders;
import okhttp3.internal.http.RealResponseBody;
import okio.GzipSource;
import okio.Okio;
import okio.Sink;
import okio.Source;

@SuppressLint(value={"LogNotTimber"})
public class AssetDownloader
implements Downloader {
    public static final long VERIFICATION_WINDOW = TimeUnit.HOURS.toMillis(24L);
    static final String DOWNLOAD_COMPLETE = "DOWNLOAD_COMPLETE";
    static final String LAST_MODIFIED = "Last-Modified";
    static final String ETAG = "ETag";
    static final String LAST_CACHE_VERIFICATION = "Last-Cache-Verification";
    static final String LAST_DOWNLOAD = "Last-Download";
    static final String DOWNLOAD_URL = "Download_URL";
    private static final String BYTES = "bytes";
    private static final String RANGE = "Range";
    private static final String ACCEPT_RANGES = "Accept-Ranges";
    private static final String CONTENT_ENCODING = "Content-Encoding";
    private static final String CONTENT_RANGE = "Content-Range";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String ACCEPT_ENCODING = "Accept-Encoding";
    private static final String IF_NONE_MATCH = "If-None-Match";
    private static final String IF_MODIFIED_SINCE = "If-Modified-Since";
    private static final String IF_RANGE = "If-Range";
    private static final String IDENTITY = "identity";
    private static final String GZIP = "gzip";
    private static final String META_POSTFIX_EXT = ".vng_meta";
    private static final String LOAD_CONTEXT = "AssetDownloader#load; loadAd sequence";
    private static final String KEY_TEMPLATE = "template";
    private static final int TIMEOUT = 30;
    private static final int PROGRESS_STEP = 5;
    private static final String TAG = AssetDownloader.class.getSimpleName();
    private static final int RETRY_COUNT_ON_CONNECTION_LOST = 5;
    private static final int CONNECTION_RETRY_TIMEOUT = 300;
    private static final int MAX_RECONNECT_ATTEMPTS = 10;
    private static final int RANGE_NOT_SATISFIABLE = 416;
    private static final long MAX_PERCENT = 100L;
    @Nullable
    private final DownloaderCache cache;
    private final long timeWindow;
    int retryCountOnConnectionLost = 5;
    int maxReconnectAttempts = 10;
    int reconnectTimeout = 300;
    private final NetworkProvider networkProvider;
    private final ThreadPoolExecutor downloadExecutor;
    private final OkHttpClient okHttpClient;
    private final ExecutorService uiExecutor;
    private static final int DOWNLOAD_CHUNK_SIZE = 2048;
    private Map<String, DownloadRequestMediator> mediators = new ConcurrentHashMap<String, DownloadRequestMediator>();
    private List<DownloadRequest> transitioning = new ArrayList<DownloadRequest>();
    private final Object addLock = new Object();
    private volatile int progressStep = 5;
    private boolean isCacheEnabled = true;
    private final NetworkProvider.NetworkListener networkListener = new NetworkProvider.NetworkListener(){

        @Override
        public void onChanged(int type) {
            Log.d((String)TAG, (String)("Network changed: " + type));
            AssetDownloader.this.onNetworkChanged(type);
        }
    };

    public AssetDownloader(int concurrentDownloads, @NonNull NetworkProvider networkProvider, @NonNull ExecutorService uiExecutor) {
        this(null, 0L, concurrentDownloads, networkProvider, uiExecutor);
    }

    public AssetDownloader(@Nullable DownloaderCache cache, long timeWindow, int concurrentDownloads, @NonNull NetworkProvider networkProvider, @NonNull ExecutorService uiExecutor) {
        this.cache = cache;
        int concurrentNum = Math.max(concurrentDownloads, 1);
        ThreadPoolExecutor executor = new ThreadPoolExecutor(concurrentNum, concurrentNum, 1L, TimeUnit.SECONDS, new PriorityBlockingQueue<Runnable>());
        executor.allowCoreThreadTimeOut(true);
        this.timeWindow = timeWindow;
        this.downloadExecutor = executor;
        this.networkProvider = networkProvider;
        this.uiExecutor = uiExecutor;
        OkHttpClient.Builder builder = new OkHttpClient.Builder().readTimeout(30L, TimeUnit.SECONDS).connectTimeout(30L, TimeUnit.SECONDS).cache(null).followRedirects(true).followSslRedirects(true);
        this.okHttpClient = builder.build();
    }

    @Override
    public synchronized void download(final DownloadRequest downloadRequest, final AssetDownloadListener downloadListener) {
        if (downloadRequest == null) {
            VungleLogger.error("AssetDownloader#download; loadAd sequence", "downloadRequest is null");
            if (downloadListener != null) {
                this.deliverError(null, downloadListener, new AssetDownloadListener.DownloadError(-1, new IllegalArgumentException("DownloadRequest is null"), 1));
            }
            return;
        }
        VungleLogger.verbose(true, TAG, "ttDownloadContext", String.format("Waiting for download asset %1$s, at: %2$d", downloadRequest, System.currentTimeMillis()));
        this.transitioning.add(downloadRequest);
        this.downloadExecutor.execute(new DownloadPriorityRunnable(new AssetPriority(-2147483647, 0)){

            @Override
            public void run() {
                VungleLogger.verbose(true, TAG, "ttDownloadContext", String.format("Start to download asset %1$s, at: %2$d", downloadRequest, System.currentTimeMillis()));
                try {
                    AssetDownloader.this.launchRequest(downloadRequest, downloadListener);
                }
                catch (IOException e2) {
                    VungleLogger.error("AssetDownloader#download; loadAd sequence", "cannot launch request due to " + e2);
                    Log.e((String)TAG, (String)"Error on launching request", (Throwable)e2);
                    AssetDownloader.this.deliverError(downloadRequest, downloadListener, new AssetDownloadListener.DownloadError(-1, e2, 1));
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void launchRequest(DownloadRequest downloadRequest, AssetDownloadListener downloadListener) throws IOException {
        Object object = this.addLock;
        synchronized (object) {
            DownloadRequestMediator mediator;
            AssetDownloader assetDownloader = this;
            synchronized (assetDownloader) {
                if (downloadRequest.isCancelled()) {
                    this.transitioning.remove(downloadRequest);
                    Log.d((String)TAG, (String)("Request " + downloadRequest.url + " is cancelled before starting"));
                    AssetDownloadListener.Progress progress = new AssetDownloadListener.Progress();
                    progress.status = 3;
                    this.deliverError(downloadRequest, downloadListener, new AssetDownloadListener.DownloadError(-1, new IOException("Cancelled"), 1));
                    return;
                }
                mediator = this.mediators.get(this.mediatorKeyFromRequest(downloadRequest));
                if (mediator == null) {
                    this.transitioning.remove(downloadRequest);
                    mediator = this.makeNewMediator(downloadRequest, downloadListener);
                    this.mediators.put(mediator.key, mediator);
                    this.load(mediator);
                    return;
                }
            }
            try {
                mediator.lock();
                assetDownloader = this;
                synchronized (assetDownloader) {
                    this.transitioning.remove(downloadRequest);
                    if (mediator.is(6) || mediator.is(3) && !downloadRequest.isCancelled()) {
                        DownloadRequestMediator mediatorNew = this.makeNewMediator(downloadRequest, downloadListener);
                        this.mediators.put(mediator.key, mediatorNew);
                        this.load(mediatorNew);
                    } else if (mediator.isCacheable) {
                        mediator.add(downloadRequest, downloadListener);
                        if (mediator.is(2)) {
                            this.load(mediator);
                        }
                    } else {
                        VungleLogger.warn("AssetDownloader#launchRequest; loadAd sequence", "request " + downloadRequest + " is already running");
                        this.deliverError(downloadRequest, downloadListener, new AssetDownloadListener.DownloadError(-1, new IllegalArgumentException("DownloadRequest is already running"), 1));
                    }
                }
            }
            finally {
                mediator.unlock();
            }
        }
    }

    private DownloadRequestMediator makeNewMediator(DownloadRequest downloadRequest, AssetDownloadListener downloadListener) throws IOException {
        String key;
        File metaFile;
        File fileToSave;
        boolean cacheable = false;
        if (!this.isCacheEnabled()) {
            fileToSave = new File(downloadRequest.path);
            metaFile = new File(fileToSave.getPath() + META_POSTFIX_EXT);
            key = downloadRequest.url + " " + downloadRequest.path;
        } else {
            fileToSave = this.cache.getFile(downloadRequest.url);
            metaFile = this.cache.getMetaFile(fileToSave);
            cacheable = true;
            key = downloadRequest.url;
        }
        Log.d((String)TAG, (String)("Destination file " + fileToSave.getPath()));
        return new DownloadRequestMediator(downloadRequest, downloadListener, fileToSave.getPath(), metaFile.getPath(), cacheable, key);
    }

    @Override
    public synchronized List<DownloadRequest> getAllRequests() {
        ArrayList<DownloadRequest> requests = new ArrayList<DownloadRequest>();
        ArrayList<DownloadRequestMediator> mediatorList = new ArrayList<DownloadRequestMediator>(this.mediators.values());
        for (DownloadRequestMediator mediator : mediatorList) {
            requests.addAll(mediator.requests());
        }
        requests.addAll(this.transitioning);
        return requests;
    }

    private synchronized void load(final DownloadRequestMediator mediator) {
        this.addNetworkListener();
        mediator.set(1);
        this.downloadExecutor.execute(new DownloadPriorityRunnable(mediator){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            @Override
            public void run() {
                mediator.setRunnable(null);
                reconnectRetries = 0;
                done = false;
                progress = new AssetDownloadListener.Progress();
                progress.timestampDownloadStart = System.currentTimeMillis();
                downloadError = null;
                isPaused = false;
                url = mediator.url;
                path = mediator.filePath;
                metPath = mediator.metaPath;
                file = new File(path);
                metaFile = new File(metPath);
                if (AssetDownloader.access$300(AssetDownloader.this) != null && mediator.isCacheable) {
                    AssetDownloader.access$300(AssetDownloader.this).startTracking(file);
                }
                while (!done) {
                    block163: {
                        block162: {
                            block161: {
                                block160: {
                                    block159: {
                                        done = true;
                                        Log.d((String)AssetDownloader.access$000(), (String)("Start load: url: " + url));
                                        sink = null;
                                        source = null;
                                        totalRead = 0L;
                                        call = null;
                                        code = -1;
                                        response = null;
                                        if (mediator.is(1)) break block159;
                                        Log.w((String)AssetDownloader.access$000(), (String)("Abort download, wrong state " + AssetDownloader.access$400(AssetDownloader.this, mediator)));
                                        if (response != null && response.body() != null) {
                                            response.body().close();
                                        }
                                        if (call != null) {
                                            call.cancel();
                                        }
                                        Log.d((String)AssetDownloader.access$000(), (String)("request is done " + AssetDownloader.access$400(AssetDownloader.this, mediator)));
                                        if (done) {
                                            switch (mediator.getStatus()) {
                                                case 2: {
                                                    break;
                                                }
                                                case 4: {
                                                    AssetDownloader.access$2400(AssetDownloader.this, file, mediator);
                                                    break;
                                                }
                                                case 5: {
                                                    AssetDownloader.access$2500(AssetDownloader.this, downloadError, mediator);
                                                    break;
                                                }
                                                case 3: {
                                                    AssetDownloader.access$2600(AssetDownloader.this, mediator);
                                                    break;
                                                }
                                                default: {
                                                    if (isPaused) break;
                                                    AssetDownloader.access$2700(AssetDownloader.this, mediator);
                                                }
                                            }
                                            Log.d((String)AssetDownloader.access$000(), (String)("Done with request in state " + mediator.getStatus() + " " + AssetDownloader.access$400(AssetDownloader.this, mediator)));
                                        } else {
                                            Log.d((String)AssetDownloader.access$000(), (String)("Not removing connections and listener " + AssetDownloader.access$400(AssetDownloader.this, mediator)));
                                        }
                                        var20_18 = AssetDownloader.this;
                                        synchronized (var20_18) {
                                            AssetDownloader.access$2800(AssetDownloader.this);
                                        }
                                        FileUtility.closeQuietly(sink);
                                        FileUtility.closeQuietly(source);
                                        if (done && AssetDownloader.access$300(AssetDownloader.this) != null && mediator.isCacheable) {
                                            AssetDownloader.access$300(AssetDownloader.this).stopTracking(file);
                                            if (!AssetDownloader.this.isCacheEnabled()) {
                                                AssetDownloader.access$300(AssetDownloader.this).clear();
                                            } else {
                                                AssetDownloader.access$300(AssetDownloader.this).purge();
                                            }
                                        }
                                        return;
                                    }
                                    if (!AssetDownloader.access$500(AssetDownloader.this, mediator)) {
                                        Log.d((String)AssetDownloader.access$000(), (String)"Request is not connected to required network");
                                        VungleLogger.warn("AssetDownloader#load; loadAd sequence", String.format("No connected to required network requests in %s", new Object[]{AssetDownloader.access$400(AssetDownloader.this, mediator)}));
                                        throw new IOException("Not connected to correct network");
                                    }
                                    mediator.setConnected(true);
                                    if (file.getParentFile() != null && !file.getParentFile().exists()) {
                                        file.getParentFile().mkdirs();
                                    }
                                    downloaded = file.exists() != false ? file.length() : 0L;
                                    Log.d((String)AssetDownloader.access$000(), (String)("already downloaded : " + downloaded + ", file exists = " + file.exists() + AssetDownloader.access$400(AssetDownloader.this, mediator)));
                                    metaMap = AssetDownloader.access$600(AssetDownloader.this, metaFile);
                                    if (!AssetDownloader.access$700(AssetDownloader.this, mediator, file, (Map)metaMap)) break block160;
                                    mediator.set(4);
                                    Log.d((String)AssetDownloader.access$000(), (String)"Using cache without verification, dispatch existing file");
                                    if (response != null && response.body() != null) {
                                        response.body().close();
                                    }
                                    if (call != null) {
                                        call.cancel();
                                    }
                                    Log.d((String)AssetDownloader.access$000(), (String)("request is done " + AssetDownloader.access$400(AssetDownloader.this, mediator)));
                                    if (done) {
                                        switch (mediator.getStatus()) {
                                            case 2: {
                                                break;
                                            }
                                            case 4: {
                                                AssetDownloader.access$2400(AssetDownloader.this, file, mediator);
                                                break;
                                            }
                                            case 5: {
                                                AssetDownloader.access$2500(AssetDownloader.this, downloadError, mediator);
                                                break;
                                            }
                                            case 3: {
                                                AssetDownloader.access$2600(AssetDownloader.this, mediator);
                                                break;
                                            }
                                            default: {
                                                if (isPaused) break;
                                                AssetDownloader.access$2700(AssetDownloader.this, mediator);
                                            }
                                        }
                                        Log.d((String)AssetDownloader.access$000(), (String)("Done with request in state " + mediator.getStatus() + " " + AssetDownloader.access$400(AssetDownloader.this, mediator)));
                                    } else {
                                        Log.d((String)AssetDownloader.access$000(), (String)("Not removing connections and listener " + AssetDownloader.access$400(AssetDownloader.this, mediator)));
                                    }
                                    var21_21 = AssetDownloader.this;
                                    synchronized (var21_21) {
                                        AssetDownloader.access$2800(AssetDownloader.this);
                                    }
                                    FileUtility.closeQuietly(sink);
                                    FileUtility.closeQuietly(source);
                                    if (done && AssetDownloader.access$300(AssetDownloader.this) != null && mediator.isCacheable) {
                                        AssetDownloader.access$300(AssetDownloader.this).stopTracking(file);
                                        if (!AssetDownloader.this.isCacheEnabled()) {
                                            AssetDownloader.access$300(AssetDownloader.this).clear();
                                        } else {
                                            AssetDownloader.access$300(AssetDownloader.this).purge();
                                        }
                                    }
                                    return;
                                }
                                VungleLogger.verbose(true, AssetDownloader.access$000(), "ttDownloadContext", String.format("Send network request: %1$s, at: %2$d", new Object[]{url, System.currentTimeMillis()}));
                                requestBuilder = new Request.Builder().url(url);
                                AssetDownloader.access$800(AssetDownloader.this, downloaded, file, (HashMap)metaMap, requestBuilder);
                                call = AssetDownloader.access$900(AssetDownloader.this).newCall(requestBuilder.build());
                                response = call.execute();
                                contentLength = AssetDownloader.access$1000(AssetDownloader.this, response);
                                Log.d((String)AssetDownloader.access$000(), (String)("Response code: " + response.code() + " " + mediator));
                                code = response.code();
                                if (!AssetDownloader.access$1100(AssetDownloader.this, file, response, mediator, (HashMap)metaMap) && !AssetDownloader.access$1200(AssetDownloader.this, mediator, file, (Map)metaMap, code)) break block161;
                                if (code == 304) {
                                    metaMap.put("Last-Cache-Verification", String.valueOf(System.currentTimeMillis()));
                                    AssetDownloader.access$1300(AssetDownloader.this, metaFile, (HashMap)metaMap);
                                    Log.d((String)AssetDownloader.access$000(), (String)"Verification success, dispatch existing file");
                                } else {
                                    Log.d((String)AssetDownloader.access$000(), (String)("Using local cache file despite response code = " + response.code()));
                                }
                                mediator.set(4);
                                if (response != null && response.body() != null) {
                                    response.body().close();
                                }
                                if (call != null) {
                                    call.cancel();
                                }
                                Log.d((String)AssetDownloader.access$000(), (String)("request is done " + AssetDownloader.access$400(AssetDownloader.this, mediator)));
                                if (done) {
                                    switch (mediator.getStatus()) {
                                        case 2: {
                                            break;
                                        }
                                        case 4: {
                                            AssetDownloader.access$2400(AssetDownloader.this, file, mediator);
                                            break;
                                        }
                                        case 5: {
                                            AssetDownloader.access$2500(AssetDownloader.this, downloadError, mediator);
                                            break;
                                        }
                                        case 3: {
                                            AssetDownloader.access$2600(AssetDownloader.this, mediator);
                                            break;
                                        }
                                        default: {
                                            if (isPaused) break;
                                            AssetDownloader.access$2700(AssetDownloader.this, mediator);
                                        }
                                    }
                                    Log.d((String)AssetDownloader.access$000(), (String)("Done with request in state " + mediator.getStatus() + " " + AssetDownloader.access$400(AssetDownloader.this, mediator)));
                                } else {
                                    Log.d((String)AssetDownloader.access$000(), (String)("Not removing connections and listener " + AssetDownloader.access$400(AssetDownloader.this, mediator)));
                                }
                                var24_29 = AssetDownloader.this;
                                synchronized (var24_29) {
                                    AssetDownloader.access$2800(AssetDownloader.this);
                                }
                                FileUtility.closeQuietly(sink);
                                FileUtility.closeQuietly((Closeable)source);
                                if (done && AssetDownloader.access$300(AssetDownloader.this) != null && mediator.isCacheable) {
                                    AssetDownloader.access$300(AssetDownloader.this).stopTracking(file);
                                    if (!AssetDownloader.this.isCacheEnabled()) {
                                        AssetDownloader.access$300(AssetDownloader.this).clear();
                                    } else {
                                        AssetDownloader.access$300(AssetDownloader.this).purge();
                                    }
                                }
                                return;
                            }
                            if (!AssetDownloader.access$1400(AssetDownloader.this, downloaded, code, response, mediator)) ** GOTO lbl255
                            if (reconnectRetries++ >= AssetDownloader.this.maxReconnectAttempts) break block162;
                            AssetDownloader.access$1500(AssetDownloader.this, file, metaFile, false);
                            done = false;
                            if (response != null && response.body() != null) {
                                response.body().close();
                            }
                            if (call != null) {
                                call.cancel();
                            }
                            Log.d((String)AssetDownloader.access$000(), (String)("request is done " + AssetDownloader.access$400(AssetDownloader.this, mediator)));
                            if (done) {
                                switch (mediator.getStatus()) {
                                    case 2: {
                                        break;
                                    }
                                    case 4: {
                                        AssetDownloader.access$2400(AssetDownloader.this, file, mediator);
                                        break;
                                    }
                                    case 5: {
                                        AssetDownloader.access$2500(AssetDownloader.this, downloadError, mediator);
                                        break;
                                    }
                                    case 3: {
                                        AssetDownloader.access$2600(AssetDownloader.this, mediator);
                                        break;
                                    }
                                    default: {
                                        if (isPaused) break;
                                        AssetDownloader.access$2700(AssetDownloader.this, mediator);
                                    }
                                }
                                Log.d((String)AssetDownloader.access$000(), (String)("Done with request in state " + mediator.getStatus() + " " + AssetDownloader.access$400(AssetDownloader.this, mediator)));
                            } else {
                                Log.d((String)AssetDownloader.access$000(), (String)("Not removing connections and listener " + AssetDownloader.access$400(AssetDownloader.this, mediator)));
                            }
                            var24_29 = AssetDownloader.this;
                            synchronized (var24_29) {
                                AssetDownloader.access$2800(AssetDownloader.this);
                            }
                            FileUtility.closeQuietly(sink);
                            FileUtility.closeQuietly((Closeable)source);
                            if (!done || AssetDownloader.access$300(AssetDownloader.this) == null || !mediator.isCacheable) continue;
                            AssetDownloader.access$300(AssetDownloader.this).stopTracking(file);
                            if (!AssetDownloader.this.isCacheEnabled()) {
                                AssetDownloader.access$300(AssetDownloader.this).clear();
                                continue;
                            }
                            AssetDownloader.access$300(AssetDownloader.this).purge();
                            continue;
                        }
                        try {
                            throw new Downloader.RequestException("Code: " + code);
lbl255:
                            // 1 sources

                            if (!response.isSuccessful()) {
                                throw new Downloader.RequestException("Code: " + code);
                            }
                            if (code != 206) {
                                downloaded = 0L;
                                AssetDownloader.access$1500(AssetDownloader.this, file, metaFile, false);
                            }
                            FileUtility.deleteAndLogIfFailed(metaFile);
                            headers = response.headers();
                            AssetDownloader.access$1600(AssetDownloader.this, file, metaFile, headers);
                            metaMap = AssetDownloader.access$1700(AssetDownloader.this, metaFile, headers, url);
                            if (!HttpHeaders.hasBody((Response)response)) {
                                VungleLogger.error("AssetDownloader#load; loadAd sequence", String.format("response has no body %s", new Object[]{response}));
                                throw new IOException("Response body is null");
                            }
                            if (AssetDownloader.access$300(AssetDownloader.this) != null) {
                                AssetDownloader.access$300(AssetDownloader.this).setCacheLastUpdateTimestamp(file, System.currentTimeMillis());
                            }
                            body = AssetDownloader.access$1800(AssetDownloader.this, response);
                            source = body.source();
                            Log.d((String)AssetDownloader.access$000(), (String)("Start download from bytes: " + downloaded + AssetDownloader.access$400(AssetDownloader.this, mediator)));
                            offset = downloaded;
                            contentLength += offset;
                            Log.d((String)AssetDownloader.access$000(), (String)("final offset = " + offset));
                            sink = Okio.buffer((Sink)(offset == 0L ? Okio.sink((File)file) : Okio.appendingSink((File)file)));
                            progress.status = 0;
                            progress.sizeBytes = body.contentLength();
                            progress.startBytes = offset;
                            AssetDownloader.access$1900(AssetDownloader.this, mediator, progress);
                            current = 0;
                            while (mediator.is(1) && (read = source.read(sink.buffer(), 2048L)) != -1L) {
                                if (!file.exists()) {
                                    VungleLogger.error("AssetDownloader#load; loadAd sequence", String.format("file %s does not exist", new Object[]{file}));
                                    throw new Downloader.RequestException("File is not existing");
                                }
                                sink.emit();
                                downloaded = offset + (totalRead += read);
                                if (contentLength > 0L) {
                                    current = (int)(downloaded * 100L / contentLength);
                                }
                                if (!mediator.isConnected()) {
                                    VungleLogger.error("AssetDownloader#load; loadAd sequence", String.format("mediator %s is not connected", new Object[]{AssetDownloader.access$400(AssetDownloader.this, mediator)}));
                                    throw new IOException("Request is not connected");
                                }
                                while (progress.progressPercent + AssetDownloader.access$2000(AssetDownloader.this) <= current && (long)(progress.progressPercent + AssetDownloader.access$2000(AssetDownloader.this)) <= 100L) {
                                    progress.status = 1;
                                    progress.progressPercent += AssetDownloader.access$2000(AssetDownloader.this);
                                    AssetDownloader.access$1900(AssetDownloader.this, mediator, progress);
                                }
                            }
                            sink.flush();
                            if (mediator.is(1)) {
                                now = System.currentTimeMillis();
                                metaMap.put("DOWNLOAD_COMPLETE", Boolean.TRUE.toString());
                                metaMap.put("Last-Cache-Verification", String.valueOf(now));
                                metaMap.put("Last-Download", String.valueOf(now));
                                AssetDownloader.access$1300(AssetDownloader.this, metaFile, (HashMap)metaMap);
                                mediator.set(4);
                                break block163;
                            }
                            progress.status = 6;
                            AssetDownloader.access$1900(AssetDownloader.this, mediator, progress);
                            Log.d((String)AssetDownloader.access$000(), (String)("State has changed, cancelling download " + AssetDownloader.access$400(AssetDownloader.this, mediator)));
                        }
                        catch (Throwable throwable) {
                            block166: {
                                block164: {
                                    block165: {
                                        VungleLogger.error("AssetDownloader#load; loadAd sequence", String.format("exception, cannot load due to %1$s, state is %2$s", new Object[]{throwable, AssetDownloader.access$400(AssetDownloader.this, mediator)}));
                                        Log.e((String)AssetDownloader.access$000(), (String)"Exception on download", (Throwable)throwable);
                                        if (!mediator.is(3)) {
                                            mediator.set(5);
                                        }
                                        if (!(throwable instanceof IOException)) ** GOTO lbl456
                                        connected = AssetDownloader.access$500(AssetDownloader.this, mediator);
                                        if (connected || response != null || !AssetDownloader.access$1200(AssetDownloader.this, mediator, file, AssetDownloader.access$600(AssetDownloader.this, metaFile), -1)) break block164;
                                        if (mediator.is(3)) break block165;
                                        mediator.set(4);
                                    }
                                    if (response != null && response.body() != null) {
                                        response.body().close();
                                    }
                                    if (call != null) {
                                        call.cancel();
                                    }
                                    Log.d((String)AssetDownloader.access$000(), (String)("request is done " + AssetDownloader.access$400(AssetDownloader.this, mediator)));
                                    if (done) {
                                        switch (mediator.getStatus()) {
                                            case 2: {
                                                break;
                                            }
                                            case 4: {
                                                AssetDownloader.access$2400(AssetDownloader.this, file, mediator);
                                                break;
                                            }
                                            case 5: {
                                                AssetDownloader.access$2500(AssetDownloader.this, downloadError, mediator);
                                                break;
                                            }
                                            case 3: {
                                                AssetDownloader.access$2600(AssetDownloader.this, mediator);
                                                break;
                                            }
                                            default: {
                                                if (isPaused) break;
                                                AssetDownloader.access$2700(AssetDownloader.this, mediator);
                                            }
                                        }
                                        Log.d((String)AssetDownloader.access$000(), (String)("Done with request in state " + mediator.getStatus() + " " + AssetDownloader.access$400(AssetDownloader.this, mediator)));
                                    } else {
                                        Log.d((String)AssetDownloader.access$000(), (String)("Not removing connections and listener " + AssetDownloader.access$400(AssetDownloader.this, mediator)));
                                    }
                                    contentLength = AssetDownloader.this;
                                    synchronized (contentLength) {
                                        AssetDownloader.access$2800(AssetDownloader.this);
                                    }
                                    FileUtility.closeQuietly(sink);
                                    FileUtility.closeQuietly(source);
                                    if (done && AssetDownloader.access$300(AssetDownloader.this) != null && mediator.isCacheable) {
                                        AssetDownloader.access$300(AssetDownloader.this).stopTracking(file);
                                        if (!AssetDownloader.this.isCacheEnabled()) {
                                            AssetDownloader.access$300(AssetDownloader.this).clear();
                                        } else {
                                            AssetDownloader.access$300(AssetDownloader.this).purge();
                                        }
                                    }
                                    return;
                                }
                                try {
                                    mediator.setConnected(connected);
                                    downloadError = new AssetDownloadListener.DownloadError(code, throwable, AssetDownloader.access$2100(AssetDownloader.this, throwable, connected));
                                    if (!connected) {
                                        progress.status = 5;
                                        AssetDownloader.access$1900(AssetDownloader.this, mediator, progress);
                                        if (!mediator.is(3) && reconnectRetries++ < AssetDownloader.this.maxReconnectAttempts) {
                                            for (i = 0; i < AssetDownloader.this.retryCountOnConnectionLost; ++i) {
                                                AssetDownloader.access$2200(AssetDownloader.this, AssetDownloader.this.reconnectTimeout);
                                                if (mediator.is(3)) break;
                                                Log.d((String)AssetDownloader.access$000(), (String)"Trying to reconnect");
                                                if (AssetDownloader.access$500(AssetDownloader.this, mediator)) {
                                                    Log.d((String)AssetDownloader.access$000(), (String)"Reconnected, starting download again");
                                                    done = false;
                                                    mediator.setConnected(true);
                                                    mediator.set(1);
                                                    break;
                                                }
                                                mediator.setConnected(false);
                                            }
                                        }
                                    }
                                    var22_28 = AssetDownloader.this;
                                    synchronized (var22_28) {
                                        if (done && !mediator.isConnected() && mediator.isPausable()) {
                                            if (AssetDownloader.access$500(AssetDownloader.this, mediator)) {
                                                Log.d((String)AssetDownloader.access$000(), (String)"Reconnected, starting download again");
                                                done = false;
                                                mediator.setConnected(true);
                                                mediator.set(1);
                                            } else {
                                                isPaused = AssetDownloader.access$2300(AssetDownloader.this, mediator, progress, downloadError);
                                            }
                                        }
                                        break block166;
                                    }
lbl456:
                                    // 1 sources

                                    if (throwable instanceof Downloader.RequestException) {
                                        AssetDownloader.access$1500(AssetDownloader.this, file, metaFile, true);
                                        downloadError = new AssetDownloadListener.DownloadError(code, throwable, 1);
                                        break block166;
                                    }
                                    AssetDownloader.access$1500(AssetDownloader.this, file, metaFile, true);
                                    downloadError = new AssetDownloadListener.DownloadError(code, throwable, 4);
                                }
                                catch (Throwable var37_41) {
                                    if (response != null && response.body() != null) {
                                        response.body().close();
                                    }
                                    if (call != null) {
                                        call.cancel();
                                    }
                                    Log.d((String)AssetDownloader.access$000(), (String)("request is done " + AssetDownloader.access$400(AssetDownloader.this, mediator)));
                                    if (done) {
                                        switch (mediator.getStatus()) {
                                            case 2: {
                                                break;
                                            }
                                            case 4: {
                                                AssetDownloader.access$2400(AssetDownloader.this, file, mediator);
                                                break;
                                            }
                                            case 5: {
                                                AssetDownloader.access$2500(AssetDownloader.this, downloadError, mediator);
                                                break;
                                            }
                                            case 3: {
                                                AssetDownloader.access$2600(AssetDownloader.this, mediator);
                                                break;
                                            }
                                            default: {
                                                if (isPaused) break;
                                                AssetDownloader.access$2700(AssetDownloader.this, mediator);
                                            }
                                        }
                                        Log.d((String)AssetDownloader.access$000(), (String)("Done with request in state " + mediator.getStatus() + " " + AssetDownloader.access$400(AssetDownloader.this, mediator)));
                                    } else {
                                        Log.d((String)AssetDownloader.access$000(), (String)("Not removing connections and listener " + AssetDownloader.access$400(AssetDownloader.this, mediator)));
                                    }
                                    var38_42 = AssetDownloader.this;
                                    synchronized (var38_42) {
                                        AssetDownloader.access$2800(AssetDownloader.this);
                                    }
                                    FileUtility.closeQuietly(sink);
                                    FileUtility.closeQuietly(source);
                                    if (done && AssetDownloader.access$300(AssetDownloader.this) != null && mediator.isCacheable) {
                                        AssetDownloader.access$300(AssetDownloader.this).stopTracking(file);
                                        if (!AssetDownloader.this.isCacheEnabled()) {
                                            AssetDownloader.access$300(AssetDownloader.this).clear();
                                        } else {
                                            AssetDownloader.access$300(AssetDownloader.this).purge();
                                        }
                                    }
                                    throw var37_41;
                                }
                            }
                            if (response != null && response.body() != null) {
                                response.body().close();
                            }
                            if (call != null) {
                                call.cancel();
                            }
                            Log.d((String)AssetDownloader.access$000(), (String)("request is done " + AssetDownloader.access$400(AssetDownloader.this, mediator)));
                            if (done) {
                                switch (mediator.getStatus()) {
                                    case 2: {
                                        break;
                                    }
                                    case 4: {
                                        AssetDownloader.access$2400(AssetDownloader.this, file, mediator);
                                        break;
                                    }
                                    case 5: {
                                        AssetDownloader.access$2500(AssetDownloader.this, downloadError, mediator);
                                        break;
                                    }
                                    case 3: {
                                        AssetDownloader.access$2600(AssetDownloader.this, mediator);
                                        break;
                                    }
                                    default: {
                                        if (isPaused) break;
                                        AssetDownloader.access$2700(AssetDownloader.this, mediator);
                                    }
                                }
                                Log.d((String)AssetDownloader.access$000(), (String)("Done with request in state " + mediator.getStatus() + " " + AssetDownloader.access$400(AssetDownloader.this, mediator)));
                            } else {
                                Log.d((String)AssetDownloader.access$000(), (String)("Not removing connections and listener " + AssetDownloader.access$400(AssetDownloader.this, mediator)));
                            }
                            var20_18 = AssetDownloader.this;
                            synchronized (var20_18) {
                                AssetDownloader.access$2800(AssetDownloader.this);
                            }
                            FileUtility.closeQuietly(sink);
                            FileUtility.closeQuietly(source);
                            if (!done || AssetDownloader.access$300(AssetDownloader.this) == null || !mediator.isCacheable) continue;
                            AssetDownloader.access$300(AssetDownloader.this).stopTracking(file);
                            if (!AssetDownloader.this.isCacheEnabled()) {
                                AssetDownloader.access$300(AssetDownloader.this).clear();
                                continue;
                            }
                            AssetDownloader.access$300(AssetDownloader.this).purge();
                            continue;
                        }
                    }
                    if (response != null && response.body() != null) {
                        response.body().close();
                    }
                    if (call != null) {
                        call.cancel();
                    }
                    Log.d((String)AssetDownloader.access$000(), (String)("request is done " + AssetDownloader.access$400(AssetDownloader.this, mediator)));
                    if (done) {
                        switch (mediator.getStatus()) {
                            case 2: {
                                break;
                            }
                            case 4: {
                                AssetDownloader.access$2400(AssetDownloader.this, file, mediator);
                                break;
                            }
                            case 5: {
                                AssetDownloader.access$2500(AssetDownloader.this, downloadError, mediator);
                                break;
                            }
                            case 3: {
                                AssetDownloader.access$2600(AssetDownloader.this, mediator);
                                break;
                            }
                            default: {
                                if (isPaused) break;
                                AssetDownloader.access$2700(AssetDownloader.this, mediator);
                            }
                        }
                        Log.d((String)AssetDownloader.access$000(), (String)("Done with request in state " + mediator.getStatus() + " " + AssetDownloader.access$400(AssetDownloader.this, mediator)));
                    } else {
                        Log.d((String)AssetDownloader.access$000(), (String)("Not removing connections and listener " + AssetDownloader.access$400(AssetDownloader.this, mediator)));
                    }
                    metaMap = AssetDownloader.this;
                    synchronized (metaMap) {
                        AssetDownloader.access$2800(AssetDownloader.this);
                    }
                    FileUtility.closeQuietly((Closeable)sink);
                    FileUtility.closeQuietly((Closeable)source);
                    if (!done || AssetDownloader.access$300(AssetDownloader.this) == null || !mediator.isCacheable) continue;
                    AssetDownloader.access$300(AssetDownloader.this).stopTracking(file);
                    if (!AssetDownloader.this.isCacheEnabled()) {
                        AssetDownloader.access$300(AssetDownloader.this).clear();
                        continue;
                    }
                    AssetDownloader.access$300(AssetDownloader.this).purge();
                }
            }
        });
    }

    private boolean useCacheOnFail(DownloadRequestMediator mediator, File file, Map<String, String> meta, int code) {
        return this.cache != null && mediator.isCacheable && code != 200 && code != 416 && code != 206 && Boolean.parseBoolean(meta.get(DOWNLOAD_COMPLETE)) && file.exists() && file.length() > 0L;
    }

    private synchronized void removeMediator(DownloadRequestMediator mediator) {
        this.mediators.remove(mediator.key);
    }

    private void addNetworkListener() {
        Log.d((String)TAG, (String)"Adding network listner");
        this.networkProvider.addListener(this.networkListener);
    }

    private boolean pause(DownloadRequestMediator mediator, AssetDownloadListener.Progress progress, AssetDownloadListener.DownloadError error) {
        if (mediator.is(3) || this.isAnyConnected(mediator)) {
            return false;
        }
        boolean anyPaused = false;
        progress.status = 2;
        AssetDownloadListener.Progress copy = AssetDownloadListener.Progress.copy(progress);
        for (Pair<DownloadRequest, AssetDownloadListener> pair : mediator.values()) {
            DownloadRequest request = (DownloadRequest)pair.first;
            if (request == null) continue;
            if (!request.pauseOnConnectionLost) {
                mediator.remove(request);
                this.deliverError(request, (AssetDownloadListener)pair.second, error);
                continue;
            }
            mediator.set(2);
            anyPaused = true;
            Log.d((String)TAG, (String)("Pausing download " + this.debugString(request)));
            this.deliverProgress(copy, (DownloadRequest)pair.first, (AssetDownloadListener)pair.second);
        }
        if (!anyPaused) {
            mediator.set(5);
        }
        Log.d((String)TAG, (String)("Attempted to pause - " + (mediator.getStatus() == 2)));
        return anyPaused;
    }

    private void sleep(long time) {
        try {
            Thread.sleep(Math.max(0L, time));
        }
        catch (InterruptedException ie) {
            Log.e((String)TAG, (String)"InterruptedException ", (Throwable)ie);
            Thread.currentThread().interrupt();
        }
    }

    private HashMap<String, String> makeMeta(File metaFile, Headers headers, String URL2) {
        HashMap<String, String> metaMap = new HashMap<String, String>();
        metaMap.put(DOWNLOAD_URL, URL2);
        metaMap.put(ETAG, headers.get(ETAG));
        metaMap.put(LAST_MODIFIED, headers.get(LAST_MODIFIED));
        metaMap.put(ACCEPT_RANGES, headers.get(ACCEPT_RANGES));
        metaMap.put(CONTENT_ENCODING, headers.get(CONTENT_ENCODING));
        this.saveMeta(metaFile, metaMap);
        return metaMap;
    }

    private void checkEncoding(File file, File metaFile, Headers headers) throws IOException {
        String contentEncoding = headers.get(CONTENT_ENCODING);
        if (contentEncoding != null && !GZIP.equalsIgnoreCase(contentEncoding) && !IDENTITY.equalsIgnoreCase(contentEncoding)) {
            this.deleteFileAndMeta(file, metaFile, false);
            VungleLogger.error("AssetDownloader#checkEncoding; loadAd sequence", String.format("unknown %1$s %2$s ", CONTENT_ENCODING, contentEncoding));
            throw new IOException("Unknown Content-Encoding");
        }
    }

    private boolean useCacheWithoutVerification(DownloadRequestMediator mediator, File file, Map<String, String> meta) {
        long timeStamp;
        if (meta == null || this.cache == null || !mediator.isCacheable) {
            return false;
        }
        String lastCheck = meta.get(LAST_CACHE_VERIFICATION);
        if (lastCheck == null || !file.exists() || !Boolean.parseBoolean(meta.get(DOWNLOAD_COMPLETE))) {
            return false;
        }
        try {
            timeStamp = Long.parseLong(lastCheck);
        }
        catch (NumberFormatException ex) {
            return false;
        }
        return this.timeWindow >= Long.MAX_VALUE - timeStamp || timeStamp + this.timeWindow >= System.currentTimeMillis();
    }

    private boolean partialMalformed(long downloaded, int code, Response response, DownloadRequestMediator mediator) {
        return code == 206 && !this.satisfiesPartialDownload(response, downloaded, mediator) || code == 416;
    }

    private void appendHeaders(long downloaded, @NonNull File file, @NonNull HashMap<String, String> metaMap, @NonNull Request.Builder requestBuilder) {
        requestBuilder.addHeader(ACCEPT_ENCODING, IDENTITY);
        if (!file.exists() || metaMap.isEmpty()) {
            return;
        }
        String eTag = metaMap.get(ETAG);
        String lastModified = metaMap.get(LAST_MODIFIED);
        if (Boolean.parseBoolean(metaMap.get(DOWNLOAD_COMPLETE))) {
            if (!TextUtils.isEmpty((CharSequence)eTag)) {
                requestBuilder.addHeader(IF_NONE_MATCH, eTag);
            }
            if (!TextUtils.isEmpty((CharSequence)lastModified)) {
                requestBuilder.addHeader(IF_MODIFIED_SINCE, lastModified);
            }
            return;
        }
        if (!BYTES.equalsIgnoreCase(metaMap.get(ACCEPT_RANGES))) {
            return;
        }
        if (metaMap.get(CONTENT_ENCODING) != null && !IDENTITY.equalsIgnoreCase(metaMap.get(CONTENT_ENCODING))) {
            return;
        }
        requestBuilder.addHeader(RANGE, "bytes=" + downloaded + "-");
        if (!TextUtils.isEmpty((CharSequence)eTag)) {
            requestBuilder.addHeader(IF_RANGE, eTag);
        } else if (!TextUtils.isEmpty((CharSequence)lastModified)) {
            requestBuilder.addHeader(IF_RANGE, lastModified);
        }
    }

    private ResponseBody decodeGzipIfNeeded(Response networkResponse) {
        if (GZIP.equalsIgnoreCase(networkResponse.header(CONTENT_ENCODING)) && HttpHeaders.hasBody((Response)networkResponse) && networkResponse.body() != null) {
            GzipSource responseBody = new GzipSource((Source)networkResponse.body().source());
            String contentType = networkResponse.header(CONTENT_TYPE);
            return new RealResponseBody(contentType, -1L, Okio.buffer((Source)responseBody));
        }
        return networkResponse.body();
    }

    private synchronized void onCancelledMediator(@NonNull DownloadRequestMediator mediator) {
        List<DownloadRequest> all = mediator.requests();
        for (DownloadRequest request : all) {
            this.onCancelled(request);
        }
    }

    private void onCancelled(@NonNull DownloadRequest request) {
        if (request.isCancelled()) {
            return;
        }
        request.cancel();
        DownloadRequestMediator mediator = this.findMediatorForCancellation(request);
        if (mediator != null && mediator.getStatus() != 3) {
            AssetDownloadListener listener;
            Pair<DownloadRequest, AssetDownloadListener> pair = mediator.remove(request);
            DownloadRequest childRequest = pair == null ? null : (DownloadRequest)pair.first;
            AssetDownloadListener assetDownloadListener = listener = pair == null ? null : (AssetDownloadListener)pair.second;
            if (mediator.values().isEmpty()) {
                mediator.set(3);
            }
            if (childRequest == null) {
                return;
            }
            AssetDownloadListener.Progress progressEnd = new AssetDownloadListener.Progress();
            progressEnd.status = 3;
            this.deliverProgress(progressEnd, childRequest, listener);
        }
        this.removeNetworkListener();
    }

    private synchronized DownloadRequestMediator findMediatorForCancellation(DownloadRequest request) {
        ArrayList<DownloadRequestMediator> mediatorList = new ArrayList<DownloadRequestMediator>(2);
        mediatorList.add(this.mediators.get(this.getCacheableKey(request)));
        mediatorList.add(this.mediators.get(this.getNonCacheableKey(request)));
        for (DownloadRequestMediator candidate : mediatorList) {
            if (candidate == null) continue;
            for (DownloadRequest downloadRequest : candidate.requests()) {
                if (!downloadRequest.equals(request)) continue;
                return candidate;
            }
        }
        return null;
    }

    private void removeNetworkListener() {
        if (this.mediators.isEmpty()) {
            Log.d((String)TAG, (String)"Removing listener");
            this.networkProvider.removeListener(this.networkListener);
        }
    }

    private int mapExceptionToReason(Throwable e2, boolean connected) {
        int reason = e2 instanceof RuntimeException ? 4 : (!connected || e2 instanceof SocketException || e2 instanceof SocketTimeoutException ? 0 : (e2 instanceof UnknownHostException || e2 instanceof SSLException ? 1 : 2));
        return reason;
    }

    private long getContentLength(Response response) {
        if (response == null) {
            return -1L;
        }
        String header = response.headers().get("Content-Length");
        if (TextUtils.isEmpty((CharSequence)header)) {
            return -1L;
        }
        try {
            return Long.parseLong(header);
        }
        catch (Throwable t) {
            return -1L;
        }
    }

    private boolean notModified(@NonNull File file, @Nullable Response response, @NonNull DownloadRequestMediator mediator, @NonNull HashMap<String, String> metaMap) {
        if (response == null || !file.exists() || file.length() <= 0L || !mediator.isCacheable) {
            return false;
        }
        int code = response.code();
        boolean downloadComplete = Boolean.parseBoolean(metaMap.get(DOWNLOAD_COMPLETE));
        if (downloadComplete && code == 304) {
            Log.d((String)TAG, (String)("304 code, data size matches file size " + this.debugString(mediator)));
            return true;
        }
        return false;
    }

    private boolean satisfiesPartialDownload(Response response, long bytesLoaded, DownloadRequestMediator downloadRequest) {
        RangeResponse rangeResponse = new RangeResponse(response.headers().get(CONTENT_RANGE));
        boolean result = response.code() == 206 && BYTES.equalsIgnoreCase(rangeResponse.dimension) && rangeResponse.rangeStart >= 0L && bytesLoaded == rangeResponse.rangeStart;
        Log.d((String)TAG, (String)("satisfies partial download: " + result + " " + this.debugString(downloadRequest)));
        return result;
    }

    private String debugString(DownloadRequestMediator mediator) {
        return ", mediator url - " + mediator.url + ", path - " + mediator.filePath + ", th - " + Thread.currentThread().getName() + "id " + mediator;
    }

    private String debugString(DownloadRequest request) {
        return ", single request url - " + request.url + ", path - " + request.path + ", th - " + Thread.currentThread().getName() + "id " + request.id;
    }

    private boolean isAnyConnected(DownloadRequestMediator mediator) {
        for (DownloadRequest request : mediator.requests()) {
            if (request == null) {
                Log.d((String)TAG, (String)"Request is null");
                continue;
            }
            if (!this.isConnected(request)) continue;
            return true;
        }
        return false;
    }

    @TargetApi(value=21)
    private boolean isConnected(@NonNull DownloadRequest request) {
        int mapped;
        int conType = this.networkProvider.getCurrentNetworkType();
        if (conType >= 0 && request.networkType == 3) {
            return true;
        }
        switch (conType) {
            case 1: 
            case 6: 
            case 9: {
                mapped = 2;
                break;
            }
            case 0: 
            case 4: 
            case 7: 
            case 17: {
                mapped = 1;
                break;
            }
            default: {
                mapped = -1;
            }
        }
        boolean connected = mapped > 0 && (request.networkType & mapped) == mapped;
        Log.d((String)TAG, (String)("checking pause for type: " + conType + " connected " + connected + this.debugString(request)));
        return connected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancelAndAwait(@Nullable DownloadRequest request, long timeout) {
        if (request == null) {
            return false;
        }
        this.cancel(request);
        long until = System.currentTimeMillis() + Math.max(0L, timeout);
        while (System.currentTimeMillis() < until) {
            DownloadRequestMediator mediator = this.findMediatorForCancellation(request);
            AssetDownloader assetDownloader = this;
            synchronized (assetDownloader) {
                if (!(this.transitioning.contains(request) || mediator != null && mediator.requests().contains(request))) {
                    return true;
                }
            }
            this.sleep(10L);
        }
        return false;
    }

    @Override
    public synchronized void cancel(@Nullable DownloadRequest request) {
        if (request == null) {
            return;
        }
        this.onCancelled(request);
    }

    @Override
    public synchronized void cancelAll() {
        Log.d((String)TAG, (String)"Cancelling all");
        for (DownloadRequest downloadRequest : this.transitioning) {
            Log.d((String)TAG, (String)("Cancel in transtiotion " + downloadRequest.url));
            this.cancel(downloadRequest);
        }
        Log.d((String)TAG, (String)("Cancel in mediator " + this.mediators.values().size()));
        for (DownloadRequestMediator request : this.mediators.values()) {
            Log.d((String)TAG, (String)("Cancel in mediator " + request.key));
            this.onCancelledMediator(request);
        }
    }

    @Override
    public void setProgressStep(int value) {
        if (value != 0) {
            this.progressStep = value;
        }
    }

    @Override
    public synchronized void init() {
        if (this.cache != null) {
            this.cache.init();
        }
    }

    @Override
    public synchronized void clearCache() {
        if (this.cache != null) {
            this.cache.clear();
        }
    }

    private synchronized void onNetworkChanged(int connectionType) {
        Log.d((String)TAG, (String)("Num of connections: " + this.mediators.values().size()));
        for (DownloadRequestMediator mediator : this.mediators.values()) {
            if (mediator.is(3)) {
                Log.d((String)TAG, (String)"Result cancelled");
                continue;
            }
            boolean connected = this.isAnyConnected(mediator);
            Log.d((String)TAG, (String)("Connected = " + connected + " for " + connectionType));
            mediator.setConnected(connected);
            if (!mediator.isPausable() || !connected || !mediator.is(2)) continue;
            this.load(mediator);
            Log.d((String)TAG, (String)("resumed " + mediator.key + " " + mediator));
        }
    }

    private boolean responseVersionMatches(Response response, HashMap<String, String> metaMap) {
        Headers headers = response.headers();
        String etag = headers.get(ETAG);
        String lastModified = headers.get(LAST_MODIFIED);
        Log.d((String)TAG, (String)("server etag: " + etag));
        Log.d((String)TAG, (String)("server lastModified: " + lastModified));
        if (etag != null && !etag.equals(metaMap.get(ETAG))) {
            Log.d((String)TAG, (String)("etags miss match current: " + metaMap.get(ETAG)));
            return false;
        }
        if (lastModified != null && !lastModified.equals(metaMap.get(LAST_MODIFIED))) {
            Log.d((String)TAG, (String)("lastModified miss match current: " + metaMap.get(LAST_MODIFIED)));
            return false;
        }
        return true;
    }

    synchronized void shutdown() {
        this.cancel(null);
        this.transitioning.clear();
        this.mediators.clear();
        this.uiExecutor.shutdownNow();
        this.downloadExecutor.shutdownNow();
        try {
            this.downloadExecutor.awaitTermination(2L, TimeUnit.SECONDS);
            this.uiExecutor.awaitTermination(2L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e2) {
            Log.e((String)TAG, (String)"InterruptedException ", (Throwable)e2);
            Thread.currentThread().interrupt();
        }
    }

    private HashMap<String, String> extractMeta(File file) {
        return FileUtility.readMap(file.getPath());
    }

    private void saveMeta(@NonNull File metaFile, @NonNull HashMap<String, String> meta) {
        FileUtility.writeMap(metaFile.getPath(), meta);
    }

    @VisibleForTesting
    synchronized void setDownloadedForTests(boolean downloaded, String url, String path) {
        ArrayList<File> files = new ArrayList<File>(2);
        if (this.cache != null) {
            try {
                files.add(this.cache.getMetaFile(this.cache.getFile(url)));
            }
            catch (IOException e2) {
                Log.e((String)TAG, (String)"Cannot add or get meta file", (Throwable)e2);
                throw new RuntimeException("Failed to get file for request");
            }
        }
        files.add(new File(path + META_POSTFIX_EXT));
        for (File file : files) {
            HashMap<String, String> meta = this.extractMeta(file);
            meta.put(DOWNLOAD_COMPLETE, Boolean.valueOf(downloaded).toString());
            FileUtility.writeSerializable(file, meta);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyToDestination(File from, File to, Pair<DownloadRequest, AssetDownloadListener> pair) {
        if (to.exists()) {
            FileUtility.deleteAndLogIfFailed(to);
        }
        FileInputStream inStream = null;
        FileOutputStream outStream = null;
        if (to.getParentFile() != null && !to.getParentFile().exists()) {
            to.getParentFile().mkdirs();
        }
        try {
            inStream = new FileInputStream(from);
            outStream = new FileOutputStream(to);
            FileChannel inChannel = inStream.getChannel();
            FileChannel outChannel = outStream.getChannel();
            inChannel.transferTo(0L, inChannel.size(), outChannel);
            Log.d((String)TAG, (String)("Copying: finished " + ((DownloadRequest)pair.first).url + " copying to " + to.getPath()));
        }
        catch (IOException e2) {
            try {
                VungleLogger.error("AssetDownloader#copyToDestination; loadAd sequence", String.format("cannot copy from %1$s(%2$s) to %3$s due to %4$s", from.getPath(), ((DownloadRequest)pair.first).url, to.getPath(), e2));
                this.deliverError((DownloadRequest)pair.first, (AssetDownloadListener)pair.second, new AssetDownloadListener.DownloadError(-1, e2, 2));
                Log.d((String)TAG, (String)("Copying: error" + ((DownloadRequest)pair.first).url + " copying to " + to.getPath()));
            }
            catch (Throwable throwable) {
                FileUtility.closeQuietly(inStream);
                FileUtility.closeQuietly(outStream);
                throw throwable;
            }
            FileUtility.closeQuietly(inStream);
            FileUtility.closeQuietly(outStream);
        }
        FileUtility.closeQuietly(inStream);
        FileUtility.closeQuietly(outStream);
    }

    private void deliverSuccess(Pair<DownloadRequest, AssetDownloadListener> pair, File dest) {
        if (pair.second != null) {
            ((AssetDownloadListener)pair.second).onSuccess(dest, (DownloadRequest)pair.first);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onSuccessMediator(@NonNull File file, @NonNull DownloadRequestMediator mediator) {
        Log.d((String)TAG, (String)("OnComplete - Removing connections and listener " + mediator));
        try {
            mediator.lock();
            List<Pair<DownloadRequest, AssetDownloadListener>> children = mediator.values();
            if (!file.exists()) {
                VungleLogger.error("AssetDownloader#onSuccessMediator; loadAd sequence", String.format("File %1$s does not exist; mediator %2$s ", file.getPath(), this.debugString(mediator)));
                this.onErrorMediator(new AssetDownloadListener.DownloadError(-1, new IOException("File is deleted"), 2), mediator);
                return;
            }
            if (this.cache != null && mediator.isCacheable) {
                this.cache.onCacheHit(file, children.size());
                this.cache.setCacheLastUpdateTimestamp(file, System.currentTimeMillis());
            }
            for (Pair<DownloadRequest, AssetDownloadListener> pair : children) {
                File destFile = new File(((DownloadRequest)pair.first).path);
                if (!destFile.equals(file)) {
                    this.copyToDestination(file, destFile, pair);
                } else {
                    destFile = file;
                }
                Log.d((String)TAG, (String)("Deliver success:" + ((DownloadRequest)pair.first).url + " dest file: " + destFile.getPath()));
                this.deliverSuccess(pair, destFile);
            }
            this.removeMediator(mediator);
            mediator.set(6);
            Log.d((String)TAG, (String)("Finished " + this.debugString(mediator)));
        }
        finally {
            mediator.unlock();
        }
    }

    private String mediatorKeyFromRequest(@NonNull DownloadRequest request) {
        return this.isCacheEnabled() ? this.getCacheableKey(request) : this.getNonCacheableKey(request);
    }

    private String getNonCacheableKey(DownloadRequest request) {
        return request.url + " " + request.path;
    }

    private String getCacheableKey(DownloadRequest request) {
        return request.url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onErrorMediator(@Nullable AssetDownloadListener.DownloadError downloadError, @NonNull DownloadRequestMediator mediator) {
        VungleLogger.error("AssetDownloader#onErrorMediator; loadAd sequence", String.format("Error %1$s occured; mediator %2$s", downloadError, this.debugString(mediator)));
        if (downloadError == null) {
            downloadError = new AssetDownloadListener.DownloadError(-1, new RuntimeException(), 4);
        }
        try {
            mediator.lock();
            for (Pair<DownloadRequest, AssetDownloadListener> pair : mediator.values()) {
                this.deliverError((DownloadRequest)pair.first, (AssetDownloadListener)pair.second, downloadError);
            }
            this.removeMediator(mediator);
            mediator.set(6);
        }
        finally {
            mediator.unlock();
        }
    }

    private void deliverError(final @Nullable DownloadRequest downloadRequest, final @Nullable AssetDownloadListener downloadListener, final @NonNull AssetDownloadListener.DownloadError error) {
        VungleLogger.error("AssetDownloader#deliverError; loadAd sequence", String.format("Delivering error %1$s; request %2$s", error, downloadRequest != null ? this.debugString(downloadRequest) : "null"));
        if (downloadListener != null) {
            this.uiExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    downloadListener.onError(error, downloadRequest);
                }
            });
        }
    }

    private void onProgressMediator(DownloadRequestMediator mediator, AssetDownloadListener.Progress progress) {
        if (mediator == null) {
            return;
        }
        AssetDownloadListener.Progress copy = AssetDownloadListener.Progress.copy(progress);
        Log.d((String)TAG, (String)("Progress " + progress.progressPercent + " status " + progress.status + " " + mediator + " " + mediator.filePath));
        for (Pair<DownloadRequest, AssetDownloadListener> pair : mediator.values()) {
            this.deliverProgress(copy, (DownloadRequest)pair.first, (AssetDownloadListener)pair.second);
        }
    }

    private void deliverProgress(final AssetDownloadListener.Progress copy, final DownloadRequest downloadRequest, final AssetDownloadListener listener) {
        if (listener != null) {
            this.uiExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    Log.d((String)TAG, (String)("On progress " + downloadRequest));
                    listener.onProgress(copy, downloadRequest);
                }
            });
        }
    }

    private void deleteFileAndMeta(File file, File metaFile, boolean removeFromCache) {
        if (file == null) {
            return;
        }
        FileUtility.deleteAndLogIfFailed(file);
        if (metaFile != null) {
            FileUtility.deleteAndLogIfFailed(metaFile);
        }
        if (this.cache != null && this.isCacheEnabled()) {
            if (removeFromCache) {
                this.cache.deleteAndRemove(file);
            } else {
                this.cache.deleteContents(file);
            }
        }
    }

    @Override
    public boolean dropCache(@Nullable String serverPath) {
        if (this.cache != null && serverPath != null) {
            try {
                File file = this.cache.getFile(serverPath);
                Log.d((String)TAG, (String)("Broken asset, deleting " + file.getPath()));
                return this.cache.deleteAndRemove(file);
            }
            catch (IOException e2) {
                VungleLogger.error("AssetDownloader#dropCache; loadAd sequence", String.format("Error %1$s occured", e2));
                Log.e((String)TAG, (String)"There was an error to get file", (Throwable)e2);
            }
        }
        return false;
    }

    @Override
    public synchronized boolean isCacheEnabled() {
        return this.cache != null && this.isCacheEnabled;
    }

    @Override
    public synchronized void setCacheEnabled(boolean isEnabled) {
        this.isCacheEnabled = isEnabled;
    }

    @Override
    public void updatePriority(DownloadRequest request) {
        Runnable runnable;
        DownloadRequestMediator mediator = this.findMediatorForCancellation(request);
        if (mediator != null && (runnable = mediator.getRunnable()) != null && this.downloadExecutor.remove(runnable)) {
            Log.d((String)TAG, (String)("prio: updated to " + mediator.getPriority()));
            this.downloadExecutor.execute(runnable);
        }
    }

    static /* synthetic */ DownloaderCache access$300(AssetDownloader x0) {
        return x0.cache;
    }

    static /* synthetic */ String access$400(AssetDownloader x0, DownloadRequestMediator x1) {
        return x0.debugString(x1);
    }

    static /* synthetic */ boolean access$500(AssetDownloader x0, DownloadRequestMediator x1) {
        return x0.isAnyConnected(x1);
    }

    static /* synthetic */ HashMap access$600(AssetDownloader x0, File x1) {
        return x0.extractMeta(x1);
    }

    static /* synthetic */ boolean access$700(AssetDownloader x0, DownloadRequestMediator x1, File x2, Map x3) {
        return x0.useCacheWithoutVerification(x1, x2, x3);
    }

    static /* synthetic */ void access$800(AssetDownloader x0, long x1, File x2, HashMap x3, Request.Builder x4) {
        x0.appendHeaders(x1, x2, x3, x4);
    }

    static /* synthetic */ OkHttpClient access$900(AssetDownloader x0) {
        return x0.okHttpClient;
    }

    static /* synthetic */ long access$1000(AssetDownloader x0, Response x1) {
        return x0.getContentLength(x1);
    }

    static /* synthetic */ boolean access$1100(AssetDownloader x0, File x1, Response x2, DownloadRequestMediator x3, HashMap x4) {
        return x0.notModified(x1, x2, x3, x4);
    }

    static /* synthetic */ boolean access$1200(AssetDownloader x0, DownloadRequestMediator x1, File x2, Map x3, int x4) {
        return x0.useCacheOnFail(x1, x2, x3, x4);
    }

    static /* synthetic */ void access$1300(AssetDownloader x0, File x1, HashMap x2) {
        x0.saveMeta(x1, x2);
    }

    static /* synthetic */ boolean access$1400(AssetDownloader x0, long x1, int x2, Response x3, DownloadRequestMediator x4) {
        return x0.partialMalformed(x1, x2, x3, x4);
    }

    static /* synthetic */ void access$1500(AssetDownloader x0, File x1, File x2, boolean x3) {
        x0.deleteFileAndMeta(x1, x2, x3);
    }

    static /* synthetic */ void access$1600(AssetDownloader x0, File x1, File x2, Headers x3) throws IOException {
        x0.checkEncoding(x1, x2, x3);
    }

    static /* synthetic */ HashMap access$1700(AssetDownloader x0, File x1, Headers x2, String x3) {
        return x0.makeMeta(x1, x2, x3);
    }

    static /* synthetic */ ResponseBody access$1800(AssetDownloader x0, Response x1) {
        return x0.decodeGzipIfNeeded(x1);
    }

    static /* synthetic */ void access$1900(AssetDownloader x0, DownloadRequestMediator x1, AssetDownloadListener.Progress x2) {
        x0.onProgressMediator(x1, x2);
    }

    static /* synthetic */ int access$2000(AssetDownloader x0) {
        return x0.progressStep;
    }

    static /* synthetic */ int access$2100(AssetDownloader x0, Throwable x1, boolean x2) {
        return x0.mapExceptionToReason(x1, x2);
    }

    static /* synthetic */ void access$2200(AssetDownloader x0, long x1) {
        x0.sleep(x1);
    }

    static /* synthetic */ boolean access$2300(AssetDownloader x0, DownloadRequestMediator x1, AssetDownloadListener.Progress x2, AssetDownloadListener.DownloadError x3) {
        return x0.pause(x1, x2, x3);
    }

    static /* synthetic */ void access$2400(AssetDownloader x0, File x1, DownloadRequestMediator x2) {
        x0.onSuccessMediator(x1, x2);
    }

    static /* synthetic */ void access$2500(AssetDownloader x0, AssetDownloadListener.DownloadError x1, DownloadRequestMediator x2) {
        x0.onErrorMediator(x1, x2);
    }

    static /* synthetic */ void access$2600(AssetDownloader x0, DownloadRequestMediator x1) {
        x0.onCancelledMediator(x1);
    }

    static /* synthetic */ void access$2700(AssetDownloader x0, DownloadRequestMediator x1) {
        x0.removeMediator(x1);
    }

    static /* synthetic */ void access$2800(AssetDownloader x0) {
        x0.removeNetworkListener();
    }

    public static abstract class DownloadPriorityRunnable
    implements Comparable,
    Runnable {
        private static final AtomicInteger seq = new AtomicInteger();
        private final int order = seq.incrementAndGet();
        private final DownloadRequestMediator mediator;
        private final AssetPriority priority;

        DownloadPriorityRunnable(DownloadRequestMediator mediator) {
            this.mediator = mediator;
            this.priority = mediator.priority;
            mediator.setRunnable(this);
        }

        DownloadPriorityRunnable(AssetPriority priority) {
            this.priority = priority;
            this.mediator = null;
        }

        AssetPriority getPriority() {
            return this.mediator != null ? this.mediator.getPriority() : this.priority;
        }

        public int compareTo(@NonNull Object o) {
            if (o instanceof DownloadPriorityRunnable) {
                DownloadPriorityRunnable other = (DownloadPriorityRunnable)o;
                int result = this.getPriority().compareTo(other.getPriority());
                if (result == 0) {
                    result = Integer.valueOf(this.order).compareTo(other.order);
                }
                return result;
            }
            return -1;
        }
    }

    public static @interface NetworkType {
        public static final int CELLULAR = 1;
        public static final int WIFI = 2;
        public static final int ANY = 3;
    }
}

