/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren.downloader;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.vungle.warren.downloader.AssetPriority;
import com.vungle.warren.downloader.Downloader;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public class DownloadRequest {
    public final int networkType;
    public final String url;
    public final String path;
    public final boolean pauseOnConnectionLost;
    private AtomicReference<AssetPriority> priority = new AtomicReference();
    final String id;
    public final String cookieString;
    private AtomicBoolean cancelled = new AtomicBoolean(false);

    public String toString() {
        return "DownloadRequest{networkType=" + this.networkType + ", priority=" + this.priority + ", url='" + this.url + '\'' + ", path='" + this.path + '\'' + ", pauseOnConnectionLost=" + this.pauseOnConnectionLost + ", id='" + this.id + '\'' + ", cookieString='" + this.cookieString + '\'' + ", cancelled=" + this.cancelled + '}';
    }

    public DownloadRequest(@NonNull String url, String path) {
        this(3, 0, url, path, false, null);
    }

    public DownloadRequest(@NonNull String url, String path, String cookieString) {
        this(3, 0, url, path, false, cookieString);
    }

    public DownloadRequest(@Downloader.NetworkType int networkType, @Priority int priority, @NonNull String url, @NonNull String path, boolean pauseOnConnectionLost, String cookieString) {
        this(networkType, new AssetPriority(priority, 0), url, path, pauseOnConnectionLost, cookieString);
    }

    public DownloadRequest(@Downloader.NetworkType int networkType, AssetPriority priority, @NonNull String url, @NonNull String path, boolean pauseOnConnectionLost, String cookieString) {
        if (TextUtils.isEmpty((CharSequence)path) || TextUtils.isEmpty((CharSequence)url)) {
            throw new IllegalArgumentException("Url or path is empty");
        }
        this.networkType = networkType;
        this.priority.set(priority);
        this.url = url;
        this.path = path;
        this.id = UUID.nameUUIDFromBytes((path + "_" + url).getBytes()).toString();
        this.pauseOnConnectionLost = pauseOnConnectionLost;
        this.cookieString = cookieString;
    }

    void cancel() {
        this.cancelled.set(true);
    }

    boolean isCancelled() {
        return this.cancelled.get();
    }

    public void setPriority(AssetPriority priority) {
        this.priority.set(priority);
    }

    public AssetPriority getPriority() {
        return this.priority.get();
    }

    public static @interface Priority {
        public static final int CRITICAL = -2147483647;
        public static final int HIGHEST = 0;
        public static final int HIGH = 1;
        public static final int LOWEST = Integer.MAX_VALUE;
    }
}

