/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren.log;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

class LogEntry {
    private static final String LOG_METADATA = "metadata";
    private static final String LOG_ITEM_CREATION_DATE = "device_timestamp";
    private static final String LOG_ITEM_LEVEL = "log_level";
    private static final String LOG_ITEM_MESSAGE = "raw_log";
    private static final String LOG_ITEM_CONTEXT = "context";
    private static final String LOG_ITEM_EVENT_ID = "event_id";
    private static final String LOG_ITEM_SDK_USER_AGENT = "sdk_user_agent";
    private static final String LOG_ITEM_BUNDLE_ID = "bundle_id";
    private static final String LOG_ITEM_TIME_ZONE = "time_zone";
    private static final String LOG_ITEM_CUSTOM_DATA = "custom_data";
    private static final String LOG_ITEM_EX_CLASS = "exception_class";
    private static final String LOG_ITEM_THREAD_ID = "thread_id";
    private String level;
    private String message;
    private String context;
    private String eventID;
    private String userAgent;
    private String bundleID;
    private String timeZone;
    private String creationDate;
    private String customData;
    private String exClass;
    private String threadId;

    LogEntry(@NonNull String message, @NonNull String logLevel, @NonNull String context, @Nullable String eventID, @Nullable String userAgent, @Nullable String bundleID, @Nullable String timeZone, @Nullable String creationDate, @Nullable String customData, @Nullable String exClass, @Nullable String threadId) {
        this.level = logLevel;
        this.message = message;
        this.context = context;
        this.eventID = eventID;
        this.userAgent = userAgent;
        this.bundleID = bundleID;
        this.timeZone = timeZone;
        this.creationDate = creationDate;
        this.customData = customData;
        this.exClass = exClass;
        this.threadId = threadId;
    }

    @NonNull
    public String toJsonString() {
        JsonObject logObj = new JsonObject();
        logObj.addProperty(LOG_ITEM_MESSAGE, this.message);
        JsonObject metadataObj = new JsonObject();
        logObj.add(LOG_METADATA, (JsonElement)metadataObj);
        this.addMetadataProperty(metadataObj, LOG_ITEM_LEVEL, this.level);
        this.addMetadataProperty(metadataObj, LOG_ITEM_CONTEXT, this.context);
        this.addMetadataProperty(metadataObj, LOG_ITEM_EVENT_ID, this.eventID);
        this.addMetadataProperty(metadataObj, LOG_ITEM_SDK_USER_AGENT, this.userAgent);
        this.addMetadataProperty(metadataObj, LOG_ITEM_BUNDLE_ID, this.bundleID);
        this.addMetadataProperty(metadataObj, LOG_ITEM_TIME_ZONE, this.timeZone);
        this.addMetadataProperty(metadataObj, LOG_ITEM_CREATION_DATE, this.creationDate);
        this.addMetadataProperty(metadataObj, LOG_ITEM_CUSTOM_DATA, this.customData);
        this.addMetadataProperty(metadataObj, LOG_ITEM_EX_CLASS, this.exClass);
        this.addMetadataProperty(metadataObj, LOG_ITEM_THREAD_ID, this.threadId);
        return logObj.toString();
    }

    private void addMetadataProperty(@NonNull JsonObject metadataObj, @NonNull String property, @Nullable String value) {
        if (value != null) {
            metadataObj.addProperty(property, value);
        }
    }
}

