/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren.log;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.vungle.warren.log.LogEntry;
import com.vungle.warren.log.LogManager;
import com.vungle.warren.utility.FileUtility;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.UUID;

class LogPersister {
    private static final String TAG = LogPersister.class.getSimpleName();
    private static final String SDK_LOGS_DIR = "sdk_logs";
    private static final String SDK_LOG_FILE_PATTERN = "log_";
    private static final String SDK_CRASH_LOG_FILE_PATTERN = "crash_";
    private static final String SDK_LOG_FILE_PENDING = "_pending";
    private static final String SDK_LOG_FILE_CRASH = "_crash";
    @Nullable
    private File logDir;
    private int entryCount;
    private int maximumEntries = 100;
    private File logFile;
    private LogManager.SdkLoggingEventListener listener;

    LogPersister(@Nullable File cacheDir) {
        if (cacheDir != null) {
            this.logDir = this.getOrCreateLogDir(cacheDir);
            if (this.logDir != null) {
                this.logFile = this.getOrCreateLogFile(this.logDir);
            }
        }
    }

    void setSdkLoggingEventListener(@NonNull LogManager.SdkLoggingEventListener listener) {
        this.listener = listener;
    }

    void setMaximumEntries(int maximumEntries) {
        if (maximumEntries <= 0) {
            maximumEntries = 100;
        }
        this.maximumEntries = maximumEntries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveLogData(@NonNull String message, @NonNull String logLevel, @NonNull String context, @Nullable String eventID, @Nullable String userAgent, @Nullable String bundleID, @Nullable String customData, @Nullable String exClass, @Nullable String threadId) {
        if (this.logDir == null) {
            Log.w((String)TAG, (String)"No log cache dir found.");
            return;
        }
        if (this.logFile == null || !this.logFile.exists()) {
            Log.d((String)TAG, (String)"current log file maybe deleted, create new one.");
            this.logFile = this.getOrCreateLogFile(this.logDir);
            if (this.logFile == null || !this.logFile.exists()) {
                Log.w((String)TAG, (String)"Can't create log file, maybe no space left.");
                return;
            }
        }
        String timeZone = TimeZone.getDefault().getID();
        String creationDate = LogPersister.getDateText(System.currentTimeMillis());
        LogEntry logEntry = new LogEntry(message, logLevel, context, eventID, userAgent, bundleID, timeZone, creationDate, customData, exClass, threadId);
        boolean saveSucceed = true;
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(this.logFile, true);
            if (this.entryCount > 0) {
                fileWriter.append("\n");
            }
            fileWriter.append(logEntry.toJsonString());
            fileWriter.flush();
        }
        catch (IOException e2) {
            try {
                Log.e((String)TAG, (String)"Failed to write sdk logs.");
                saveSucceed = false;
            }
            catch (Throwable throwable) {
                FileUtility.closeQuietly(fileWriter);
                throw throwable;
            }
            FileUtility.closeQuietly(fileWriter);
        }
        FileUtility.closeQuietly(fileWriter);
        if (saveSucceed) {
            ++this.entryCount;
            if (this.entryCount >= this.maximumEntries) {
                boolean pendingSucceed = this.renameFile(this.logFile, this.logFile.getName() + SDK_LOG_FILE_PENDING);
                if (pendingSucceed) {
                    this.logFile = this.getOrCreateLogFile(this.logDir);
                }
                if (this.listener != null) {
                    this.listener.sendPendingLogs();
                }
            }
        }
    }

    @Nullable
    File[] getPendingFiles() {
        if (this.logDir == null) {
            Log.w((String)TAG, (String)"No log cache dir found.");
            return null;
        }
        return this.logDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(LogPersister.SDK_LOG_FILE_PENDING);
            }
        });
    }

    @Nullable
    private File getOrCreateLogDir(@NonNull File baseDir) {
        File logDir = this.createFileOrDirectory(baseDir, SDK_LOGS_DIR, true);
        if (logDir == null || !logDir.exists()) {
            Log.e((String)TAG, (String)"Failed to create vungle logs dir");
            return null;
        }
        return logDir;
    }

    @Nullable
    File getOrCreateLogFile(@NonNull File logDir) {
        File[] logFiles = logDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return !name.endsWith(LogPersister.SDK_LOG_FILE_PENDING);
            }
        });
        if (logFiles == null || logFiles.length == 0) {
            this.entryCount = 0;
            String logFileName = SDK_LOG_FILE_PATTERN + System.currentTimeMillis() + UUID.randomUUID().toString();
            return this.createFileOrDirectory(logDir, logFileName, false);
        }
        Arrays.sort(logFiles, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return o2.getName().compareTo(o1.getName());
            }
        });
        File loggingFile = logFiles[0];
        int lineCount = LogPersister.getFileLineCount(loggingFile.getAbsolutePath());
        if (lineCount <= 0 || lineCount < this.maximumEntries) {
            this.entryCount = lineCount;
            return loggingFile;
        }
        File newLoggingFile = null;
        try {
            boolean pendingSucceed = this.renameFile(this.logFile, this.logFile.getName() + SDK_LOG_FILE_PENDING);
            if (pendingSucceed) {
                newLoggingFile = this.getOrCreateLogFile(logDir);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (newLoggingFile == null) {
            newLoggingFile = loggingFile;
            this.entryCount = lineCount;
        }
        return newLoggingFile;
    }

    @Nullable
    private File createFileOrDirectory(@NonNull File parentDir, @NonNull String fileName, boolean isDir) {
        boolean ret = false;
        File file = new File(parentDir, fileName);
        if (!file.exists()) {
            if (!isDir) {
                try {
                    ret = file.createNewFile();
                }
                catch (IOException e2) {
                    Log.e((String)TAG, (String)"", (Throwable)e2);
                }
            } else {
                ret = file.mkdir();
            }
        } else {
            ret = true;
        }
        return ret ? file : null;
    }

    private boolean renameFile(@NonNull File srcFile, @NonNull String destFileName) {
        if (!srcFile.exists() || !srcFile.isFile()) {
            return false;
        }
        File destFile = new File(this.logDir, destFileName);
        if (destFile.exists()) {
            return false;
        }
        boolean ret = srcFile.renameTo(destFile);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int getFileLineCount(@NonNull String filename) {
        int cnt;
        LineNumberReader reader = null;
        try {
            reader = new LineNumberReader(new FileReader(filename));
            while (reader.readLine() != null) {
            }
            cnt = reader.getLineNumber();
            FileUtility.closeQuietly(reader);
        }
        catch (Exception ex) {
            cnt = -1;
        }
        finally {
            FileUtility.closeQuietly(reader);
        }
        return cnt;
    }

    private static String getDateText(long time) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", Locale.getDefault());
        return sdf.format(new Date(time));
    }

    @Nullable
    File[] getCrashReportFiles(int crashBatchMax) {
        if (this.logDir == null) {
            Log.w((String)TAG, (String)"No log cache dir found.");
            return null;
        }
        File[] crashFiles = this.logDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(LogPersister.SDK_LOG_FILE_CRASH);
            }
        });
        if (crashFiles == null || crashFiles.length == 0) {
            return null;
        }
        Arrays.sort(crashFiles, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return o2.getName().compareTo(o1.getName());
            }
        });
        return Arrays.copyOfRange(crashFiles, 0, Math.min(crashFiles.length, crashBatchMax));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveCrashLogData(@NonNull String message, @NonNull String logLevel, @NonNull String context, @Nullable String eventID, @Nullable String userAgent, @Nullable String bundleID, @Nullable String customData, @Nullable String exClass, @Nullable String threadId) {
        block6: {
            if (this.logDir == null) {
                Log.w((String)TAG, (String)"No log cache dir found.");
                return;
            }
            String timeZone = TimeZone.getDefault().getID();
            String creationDate = LogPersister.getDateText(System.currentTimeMillis());
            LogEntry logEntry = new LogEntry(message, logLevel, context, eventID, userAgent, bundleID, timeZone, creationDate, customData, exClass, threadId);
            String crashFileName = SDK_CRASH_LOG_FILE_PATTERN + System.currentTimeMillis();
            File crashFile = this.createFileOrDirectory(this.logDir, crashFileName, false);
            if (crashFile == null) break block6;
            boolean saveSucceed = true;
            FileWriter fileWriter = null;
            try {
                fileWriter = new FileWriter(crashFile, true);
                fileWriter.append(logEntry.toJsonString());
                fileWriter.flush();
            }
            catch (IOException e2) {
                try {
                    Log.e((String)TAG, (String)"Failed to write crash log.");
                    saveSucceed = false;
                }
                catch (Throwable throwable) {
                    FileUtility.closeQuietly(fileWriter);
                    throw throwable;
                }
                FileUtility.closeQuietly(fileWriter);
            }
            FileUtility.closeQuietly(fileWriter);
            if (saveSucceed) {
                this.renameFile(crashFile, crashFile.getName() + SDK_LOG_FILE_CRASH);
            }
        }
    }
}

