/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren.model;

import android.content.ContentValues;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.vungle.warren.model.CacheBust;
import com.vungle.warren.persistence.DBAdapter;
import com.vungle.warren.persistence.IdColumns;

public class CacheBustDBAdapter
implements DBAdapter<CacheBust> {
    @VisibleForTesting
    static final String DELIMITER = ";";
    public static final String CREATE_CACHE_BUST_TABLE_QUERY = "CREATE TABLE IF NOT EXISTS cache_bust(_id INTEGER PRIMARY KEY AUTOINCREMENT, item_id TEXT UNIQUE, id TEXT, time_window_end INTEGER, id_type INTEGER, event_ids TEXT, timestamp_processed INTEGER )";

    @Override
    public ContentValues toContentValues(CacheBust item) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("item_id", item.calculateId());
        contentValues.put("id", item.id);
        contentValues.put("time_window_end", Long.valueOf(item.timeWindowEnd));
        contentValues.put("id_type", Integer.valueOf(item.idType));
        contentValues.put("event_ids", CacheBustDBAdapter.arrayToString(item.eventIds));
        contentValues.put("timestamp_processed", Long.valueOf(item.timestampProcessed));
        return contentValues;
    }

    @Override
    @NonNull
    public CacheBust fromContentValues(ContentValues values) {
        CacheBust item = new CacheBust();
        item.id = values.getAsString("id");
        item.timeWindowEnd = values.getAsLong("time_window_end");
        item.idType = values.getAsInteger("id_type");
        item.eventIds = CacheBustDBAdapter.stringToArray(values.getAsString("event_ids"));
        item.timestampProcessed = values.getAsLong("timestamp_processed");
        return item;
    }

    @Override
    public String tableName() {
        return "cache_bust";
    }

    static String arrayToString(String[] array) {
        if (array == null || array.length == 0) {
            return "";
        }
        if (array.length == 1) {
            return array[0];
        }
        StringBuilder result = new StringBuilder(array[0]);
        for (int i = 1; i < array.length; ++i) {
            result.append(DELIMITER).append(array[i]);
        }
        return result.toString();
    }

    static String[] stringToArray(String string) {
        if (string.isEmpty()) {
            return new String[0];
        }
        return string.split(DELIMITER);
    }

    public static interface CacheBustColumns
    extends IdColumns {
        public static final String TABLE_NAME = "cache_bust";
        public static final String COLUMN_EVENT_ID = "id";
        public static final String COLUMN_TIME_WINDOW_END = "time_window_end";
        public static final String COLUMN_EVENT_ID_TYPE = "id_type";
        public static final String COLUMN_EVENT_IDS = "event_ids";
        public static final String COLUMN_TIMESTAMP_PROCESSED = "timestamp_processed";
    }
}

