/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren.model;

import androidx.annotation.NonNull;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Cookie {
    public static final String APP_ID = "appId";
    public static final String CONSENT_COOKIE = "consentIsImportantToVungle";
    public static final String CCPA_COOKIE = "ccpaIsImportantToVungle";
    public static final String CCPA_CONSENT_STATUS = "ccpa_status";
    public static final String CONSENT_STATUS_OPTED_IN = "opted_in";
    public static final String CONSENT_STATUS_OPTED_OUT = "opted_out";
    public static final String INCENTIVIZED_TEXT_COOKIE = "incentivizedTextSetByPub";
    public static final String CONFIG_COOKIE = "configSettings";
    public static final String CACHE_BUST_COOKIE = "cacheBustSettings";
    public static final String LAST_CACHE_BUST = "last_cache_bust";
    public static final String USER_AGENT_ID_COOKIE = "userAgent";
    public static final String IS_PLAY_SERVICE_AVAILABLE = "isPlaySvcAvailable";
    Map<String, String> strings = new ConcurrentHashMap<String, String>();
    Map<String, Boolean> booleans = new ConcurrentHashMap<String, Boolean>();
    Map<String, Integer> integers = new ConcurrentHashMap<String, Integer>();
    Map<String, Long> longs = new ConcurrentHashMap<String, Long>();
    String identifier;

    public Cookie(String identifier) {
        this.identifier = identifier;
    }

    public <T> void putValue(String key, T value) {
        if (value instanceof String) {
            this.strings.put(key, (String)value);
        } else if (value instanceof Boolean) {
            this.booleans.put(key, (Boolean)value);
        } else if (value instanceof Integer) {
            this.integers.put(key, (Integer)value);
        } else if (value instanceof Long) {
            this.longs.put(key, (Long)value);
        } else {
            throw new IllegalArgumentException("Value type is not supported!");
        }
    }

    public Integer getInt(String key) {
        return this.integers.get(key);
    }

    public String getString(String key) {
        return this.strings.get(key);
    }

    public Boolean getBoolean(String key) {
        return this.booleans.get(key) != null && this.booleans.get(key) != false;
    }

    public Long getLong(String key) {
        return this.longs.get(key) != null ? this.longs.get(key) : 0L;
    }

    @NonNull
    public String getId() {
        return this.identifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Cookie cookie = (Cookie)o;
        if (this.strings != null ? !this.strings.equals(cookie.strings) : cookie.strings != null) {
            return false;
        }
        if (this.booleans != null ? !this.booleans.equals(cookie.booleans) : cookie.booleans != null) {
            return false;
        }
        if (this.integers != null ? !this.integers.equals(cookie.integers) : cookie.integers != null) {
            return false;
        }
        if (this.longs != null ? !this.longs.equals(cookie.longs) : cookie.longs != null) {
            return false;
        }
        return this.identifier != null ? this.identifier.equals(cookie.identifier) : cookie.identifier == null;
    }

    public int hashCode() {
        int result = this.strings != null ? this.strings.hashCode() : 0;
        result = 31 * result + (this.booleans != null ? this.booleans.hashCode() : 0);
        result = 31 * result + (this.integers != null ? this.integers.hashCode() : 0);
        result = 31 * result + (this.longs != null ? this.longs.hashCode() : 0);
        result = 31 * result + (this.identifier != null ? this.identifier.hashCode() : 0);
        return result;
    }
}

