/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren.model;

import android.util.Log;
import androidx.annotation.NonNull;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.vungle.warren.AdConfig;
import com.vungle.warren.VungleLogger;
import com.vungle.warren.model.JsonUtil;
import org.jetbrains.annotations.NotNull;

public class Placement {
    private static final String TAG = "Placement";
    String identifier;
    boolean autoCached;
    boolean incentivized;
    long wakeupTime;
    int adRefreshDuration;
    int autoCachePriority;
    boolean headerBidding;
    boolean isValid;
    @PlacementAdType
    int placementAdType = 0;
    public static final int TYPE_DEFAULT = 0;
    public static final int TYPE_VUNGLE_BANNER = 1;
    public static final int TYPE_DEPRECTAED_TEMPLATE = 2;
    public static final int TYPE_VUNGLE_MREC = 3;
    protected AdConfig.AdSize adSize;
    protected AdConfig.AdSize recommendedAdSize = AdConfig.AdSize.VUNGLE_DEFAULT;
    int maxHbCache;
    public static final int INVALID_INTEGER_VALUE = Integer.MIN_VALUE;

    public Placement(String identifier) {
        this.identifier = identifier;
        this.autoCached = false;
        this.incentivized = false;
        this.headerBidding = false;
    }

    Placement() {
    }

    public Placement(JsonObject jsonObject) throws IllegalArgumentException {
        JsonArray supportedTemplatesTypesArray;
        Object object;
        if (!jsonObject.has("reference_id")) {
            throw new IllegalArgumentException("Missing placement reference ID, cannot use placement!");
        }
        this.identifier = jsonObject.get("reference_id").getAsString();
        boolean bl = this.autoCached = jsonObject.has("is_auto_cached") && jsonObject.get("is_auto_cached").getAsBoolean();
        if (jsonObject.has("cache_priority") && this.autoCached) {
            try {
                this.autoCachePriority = jsonObject.get("cache_priority").getAsInt();
                if (this.autoCachePriority < 1) {
                    this.autoCachePriority = Integer.MAX_VALUE;
                }
            }
            catch (Exception e2) {
                this.autoCachePriority = Integer.MAX_VALUE;
            }
        } else {
            this.autoCachePriority = Integer.MAX_VALUE;
        }
        this.incentivized = jsonObject.has("is_incentivized") && jsonObject.get("is_incentivized").getAsBoolean();
        this.adRefreshDuration = jsonObject.has("ad_refresh_duration") ? jsonObject.get("ad_refresh_duration").getAsInt() : 0;
        boolean bl2 = this.headerBidding = jsonObject.has("header_bidding") && jsonObject.get("header_bidding").getAsBoolean();
        if (JsonUtil.hasNonNull((JsonElement)jsonObject, "max_hb_cache")) {
            try {
                this.maxHbCache = jsonObject.get("max_hb_cache").getAsInt();
                this.maxHbCache = this.maxHbCache > 0 ? this.maxHbCache : Integer.MIN_VALUE;
            }
            catch (NumberFormatException e3) {
                VungleLogger.error(true, TAG, TAG, String.format("Can't read int value from JSON: %s", e3.getLocalizedMessage()));
                this.maxHbCache = Integer.MIN_VALUE;
            }
        }
        if (JsonUtil.hasNonNull((JsonElement)jsonObject, "supported_template_types") && (object = (supportedTemplatesTypesArray = jsonObject.getAsJsonArray("supported_template_types")).iterator()).hasNext()) {
            JsonElement jsonElement = (JsonElement)object.next();
            Log.d((String)"PlacementModel", (String)("SupportedTemplatesTypes : " + jsonElement.getAsString()));
            this.placementAdType = jsonElement.getAsString().equals("banner") ? 1 : (jsonElement.getAsString().equals("flexfeed") || jsonElement.getAsString().equals("flexview") ? 2 : (jsonElement.getAsString().equals("mrec") ? 3 : 0));
        }
        if (JsonUtil.hasNonNull((JsonElement)jsonObject, "ad_size") && this.placementAdType == 1 && this.isMultipleHBPEnabled()) {
            String property = jsonObject.get("ad_size").getAsString();
            switch (property) {
                case "banner": {
                    this.recommendedAdSize = AdConfig.AdSize.BANNER;
                    break;
                }
                case "banner_short": {
                    this.recommendedAdSize = AdConfig.AdSize.BANNER_SHORT;
                    break;
                }
                case "banner_leaderboard": {
                    this.recommendedAdSize = AdConfig.AdSize.BANNER_LEADERBOARD;
                    break;
                }
                default: {
                    this.recommendedAdSize = AdConfig.AdSize.VUNGLE_DEFAULT;
                }
            }
        }
    }

    public void snooze(long sleepTime) {
        this.wakeupTime = System.currentTimeMillis() + sleepTime * 1000L;
    }

    public long getWakeupTime() {
        return this.wakeupTime;
    }

    public void setWakeupTime(long wakeupTime) {
        this.wakeupTime = wakeupTime;
    }

    @NonNull
    public String getId() {
        return this.identifier;
    }

    public void setValid(boolean valid) {
        this.isValid = valid;
    }

    @PlacementAdType
    public int getPlacementAdType() {
        return this.placementAdType;
    }

    public AdConfig.AdSize getAdSize() {
        return this.adSize == null ? AdConfig.AdSize.VUNGLE_DEFAULT : this.adSize;
    }

    @NonNull
    public AdConfig.AdSize getRecommendedAdSize() {
        return this.recommendedAdSize;
    }

    public void setAdSize(AdConfig.AdSize adSize) {
        this.adSize = adSize;
    }

    public int getAdRefreshDuration() {
        if (this.adRefreshDuration <= 0) {
            return 0;
        }
        return this.adRefreshDuration;
    }

    public int getAutoCachePriority() {
        return this.autoCachePriority;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Placement placement = (Placement)o;
        if (this.identifier != null ? !this.identifier.equals(placement.identifier) : placement.identifier != null) {
            return false;
        }
        if (this.placementAdType != placement.placementAdType) {
            return false;
        }
        if (this.autoCached != placement.autoCached) {
            return false;
        }
        if (this.incentivized != placement.incentivized) {
            return false;
        }
        if (this.headerBidding != placement.headerBidding) {
            return false;
        }
        return this.isValid == placement.isValid;
    }

    public int hashCode() {
        int result = this.identifier != null ? this.identifier.hashCode() : 0;
        result = 31 * result + this.placementAdType;
        result = 31 * result + (this.autoCached ? 1 : 0);
        result = 31 * result + (this.incentivized ? 1 : 0);
        result = 31 * result + (this.headerBidding ? 1 : 0);
        result = 31 * result + (this.isValid ? 1 : 0);
        return result;
    }

    public boolean isAutoCached() {
        if (AdConfig.AdSize.isNonMrecBannerAdSize(this.adSize)) {
            return true;
        }
        return this.autoCached;
    }

    public boolean isIncentivized() {
        return this.incentivized;
    }

    public boolean isHeaderBidding() {
        return this.headerBidding;
    }

    public int getMaxHbCache() {
        return this.maxHbCache;
    }

    public boolean isValid() {
        return this.isValid;
    }

    @NotNull
    public String toString() {
        return "Placement{identifier='" + this.identifier + '\'' + ", autoCached=" + this.autoCached + ", incentivized=" + this.incentivized + ", wakeupTime=" + this.wakeupTime + ", adRefreshDuration=" + this.adRefreshDuration + ", autoCachePriority=" + this.autoCachePriority + ", headerBidding=" + this.headerBidding + ", isValid=" + this.isValid + ", placementAdType=" + this.placementAdType + ", adSize=" + (Object)((Object)this.adSize) + ", maxHbCache=" + this.maxHbCache + ", adSize=" + (Object)((Object)this.adSize) + ", recommendedAdSize=" + (Object)((Object)this.recommendedAdSize) + '}';
    }

    public boolean isMultipleHBPEnabled() {
        return this.headerBidding && this.maxHbCache > 0;
    }

    public boolean isSingleHBPEnabled() {
        return this.headerBidding && this.maxHbCache == 1;
    }

    public static @interface PlacementAdType {
    }
}

