/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren.model;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.vungle.warren.AdConfig;
import com.vungle.warren.SessionData;
import com.vungle.warren.model.Advertisement;
import com.vungle.warren.model.Placement;
import java.util.ArrayList;
import java.util.List;

public class Report {
    public static final int NEW = 0;
    public static final int READY = 1;
    public static final int SENDING = 2;
    public static final int FAILED = 3;
    int status = 0;
    String placementId;
    String adToken;
    String appId;
    boolean incentivized;
    boolean headerBidding;
    boolean playRemoteUrl;
    long adStartTime;
    String url;
    long videoLength;
    long adDuration;
    long ttDownload;
    String campaign;
    String advertisementID;
    int videoViewed;
    final List<UserAction> userActions = new ArrayList<UserAction>();
    final List<String> clickedThrough = new ArrayList<String>();
    final List<String> errors = new ArrayList<String>();
    String adType;
    String templateId;
    String userID;
    int ordinal;
    String adSize;
    volatile boolean wasCTAClicked;
    @VisibleForTesting
    public long initTimeStamp;
    @VisibleForTesting
    public long assetDownloadDuration;

    Report() {
    }

    public Report(@NonNull Advertisement advertisement, @NonNull Placement placement, long startTime, SessionData sessionData) {
        this(advertisement, placement, startTime, null, sessionData);
    }

    public Report(@NonNull Advertisement advertisement, @NonNull Placement placement, long startTime, @Nullable String userID, SessionData sessionData) {
        this.placementId = placement.getId();
        this.adToken = advertisement.getAdToken();
        this.advertisementID = advertisement.getId();
        this.appId = advertisement.getAppID();
        this.incentivized = placement.isIncentivized();
        this.headerBidding = placement.isHeaderBidding();
        this.adStartTime = startTime;
        this.url = advertisement.getUrl();
        this.ttDownload = -1L;
        this.campaign = advertisement.getCampaign();
        this.initTimeStamp = sessionData != null ? sessionData.getInitTimeStamp() : 0L;
        this.assetDownloadDuration = advertisement.getAssetDownloadDuration();
        switch (advertisement.getAdType()) {
            case 0: {
                this.adType = "vungle_local";
                break;
            }
            case 1: {
                this.adType = "vungle_mraid";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown ad type, cannot process!");
            }
        }
        this.templateId = advertisement.getTemplateId();
        this.userID = userID == null ? "" : userID;
        this.ordinal = advertisement.getAdConfig().getOrdinal();
        AdConfig.AdSize tempAdSize = advertisement.getAdConfig().getAdSize();
        if (AdConfig.AdSize.isNonMrecBannerAdSize(tempAdSize)) {
            this.adSize = tempAdSize.getName();
        }
    }

    public synchronized void recordAction(String action, String value, long timestamp) {
        this.userActions.add(new UserAction(action, value, timestamp));
        this.clickedThrough.add(action);
        if (action.equals("download")) {
            this.wasCTAClicked = true;
        }
    }

    public synchronized void recordError(String description) {
        this.errors.add(description);
    }

    public void recordProgress(int viewed) {
        this.videoViewed = viewed;
    }

    public void setVideoLength(long duration) {
        this.videoLength = duration;
    }

    public void setAdDuration(long duration) {
        this.adDuration = duration;
    }

    public long getAdDuration() {
        return this.adDuration;
    }

    public void setTtDownload(long duration) {
        this.ttDownload = duration;
    }

    public void setAllAssetDownloaded(boolean allAssetDownloaded) {
        this.playRemoteUrl = !allAssetDownloaded;
    }

    public String getPlacementId() {
        return this.placementId;
    }

    public String getAdvertisementID() {
        return this.advertisementID;
    }

    public boolean isCTAClicked() {
        return this.wasCTAClicked;
    }

    public String getUserID() {
        return this.userID;
    }

    public synchronized JsonObject toReportBody() {
        JsonObject request = new JsonObject();
        request.addProperty("placement_reference_id", this.placementId);
        request.addProperty("ad_token", this.adToken);
        request.addProperty("app_id", this.appId);
        request.addProperty("incentivized", (Number)(this.incentivized ? 1 : 0));
        request.addProperty("header_bidding", Boolean.valueOf(this.headerBidding));
        request.addProperty("play_remote_assets", Boolean.valueOf(this.playRemoteUrl));
        request.addProperty("adStartTime", (Number)this.adStartTime);
        if (!TextUtils.isEmpty((CharSequence)this.url)) {
            request.addProperty("url", this.url);
        }
        request.addProperty("adDuration", (Number)this.adDuration);
        request.addProperty("ttDownload", (Number)this.ttDownload);
        request.addProperty("campaign", this.campaign);
        request.addProperty("adType", this.adType);
        request.addProperty("templateId", this.templateId);
        request.addProperty("init_timestamp", (Number)this.initTimeStamp);
        request.addProperty("asset_download_duration", (Number)this.assetDownloadDuration);
        if (!TextUtils.isEmpty((CharSequence)this.adSize)) {
            request.addProperty("ad_size", this.adSize);
        }
        JsonArray plays = new JsonArray();
        JsonObject playsObject = new JsonObject();
        playsObject.addProperty("startTime", (Number)this.adStartTime);
        if (this.videoViewed > 0) {
            playsObject.addProperty("videoViewed", (Number)this.videoViewed);
        }
        if (this.videoLength > 0L) {
            playsObject.addProperty("videoLength", (Number)this.videoLength);
        }
        JsonArray userActionJson = new JsonArray();
        for (UserAction userAction : this.userActions) {
            userActionJson.add((JsonElement)userAction.toJson());
        }
        playsObject.add("userActions", (JsonElement)userActionJson);
        plays.add((JsonElement)playsObject);
        request.add("plays", (JsonElement)plays);
        JsonArray errorsJson = new JsonArray();
        for (String s : this.errors) {
            errorsJson.add(s);
        }
        request.add("errors", (JsonElement)errorsJson);
        JsonArray jsonArray = new JsonArray();
        for (String s : this.clickedThrough) {
            jsonArray.add(s);
        }
        request.add("clickedThrough", (JsonElement)jsonArray);
        if (this.incentivized && !TextUtils.isEmpty((CharSequence)this.userID)) {
            request.addProperty("user", this.userID);
        }
        if (this.ordinal > 0) {
            request.addProperty("ordinal_view", (Number)this.ordinal);
        }
        return request;
    }

    @NonNull
    public String getId() {
        return this.placementId + "_" + this.adStartTime;
    }

    public long getAdStartTime() {
        return this.adStartTime;
    }

    public synchronized boolean equals(Object obj) {
        int x;
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Report wrap = (Report)obj;
        if (!wrap.placementId.equals(this.placementId)) {
            return false;
        }
        if (!wrap.adToken.equals(this.adToken)) {
            return false;
        }
        if (!wrap.appId.equals(this.appId)) {
            return false;
        }
        if (wrap.incentivized != this.incentivized) {
            return false;
        }
        if (wrap.headerBidding != this.headerBidding) {
            return false;
        }
        if (wrap.adStartTime != this.adStartTime) {
            return false;
        }
        if (!wrap.url.equals(this.url)) {
            return false;
        }
        if (wrap.videoLength != this.videoLength) {
            return false;
        }
        if (wrap.adDuration != this.adDuration) {
            return false;
        }
        if (wrap.ttDownload != this.ttDownload) {
            return false;
        }
        if (!wrap.campaign.equals(this.campaign)) {
            return false;
        }
        if (!wrap.adType.equals(this.adType)) {
            return false;
        }
        if (!wrap.templateId.equals(this.templateId)) {
            return false;
        }
        if (wrap.wasCTAClicked != this.wasCTAClicked) {
            return false;
        }
        if (!wrap.userID.equals(this.userID)) {
            return false;
        }
        if (wrap.initTimeStamp != this.initTimeStamp) {
            return false;
        }
        if (wrap.assetDownloadDuration != this.assetDownloadDuration) {
            return false;
        }
        if (wrap.clickedThrough.size() != this.clickedThrough.size()) {
            return false;
        }
        for (x = 0; x < this.clickedThrough.size(); ++x) {
            if (wrap.clickedThrough.get(x).equals(this.clickedThrough.get(x))) continue;
            return false;
        }
        if (wrap.errors.size() != this.errors.size()) {
            return false;
        }
        for (x = 0; x < this.errors.size(); ++x) {
            if (wrap.errors.get(x).equals(this.errors.get(x))) continue;
            return false;
        }
        if (wrap.userActions.size() != this.userActions.size()) {
            return false;
        }
        for (x = 0; x < this.userActions.size(); ++x) {
            if (wrap.userActions.get(x).equals(this.userActions.get(x))) continue;
            return false;
        }
        return true;
    }

    public synchronized int hashCode() {
        int result = this.placementId.hashCode();
        result = 31 * result + this.adToken.hashCode();
        result = 31 * result + this.appId.hashCode();
        result = 31 * result + (this.incentivized ? 1 : 0);
        result = 31 * result + (this.headerBidding ? 1 : 0);
        result = 31 * result + (int)(this.adStartTime ^ this.adStartTime >>> 32);
        result = 31 * result + this.url.hashCode();
        result = 31 * result + (int)(this.videoLength ^ this.videoLength >>> 32);
        result = 31 * result + (int)(this.adDuration ^ this.adDuration >>> 32);
        result = 31 * result + (int)(this.ttDownload ^ this.ttDownload >>> 32);
        result = 31 * result + (int)(this.initTimeStamp ^ this.initTimeStamp >>> 32);
        result = 31 * result + (int)(this.assetDownloadDuration ^ this.assetDownloadDuration >>> 32);
        result = 31 * result + this.campaign.hashCode();
        result = 31 * result + this.userActions.hashCode();
        result = 31 * result + this.clickedThrough.hashCode();
        result = 31 * result + this.errors.hashCode();
        result = 31 * result + this.adType.hashCode();
        result = 31 * result + this.templateId.hashCode();
        result = 31 * result + this.userID.hashCode();
        result = 31 * result + (this.wasCTAClicked ? 1 : 0);
        return result;
    }

    @Status
    public int getStatus() {
        return this.status;
    }

    public void setStatus(@Status int status) {
        this.status = status;
    }

    public static class UserAction {
        @SerializedName(value="action")
        private String action;
        @SerializedName(value="value")
        private String value;
        @SerializedName(value="timestamp")
        private long timestamp;

        public UserAction(String action, String value, long timestamp) {
            this.action = action;
            this.value = value;
            this.timestamp = timestamp;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            UserAction wrap = (UserAction)obj;
            if (!wrap.action.equals(this.action)) {
                return false;
            }
            if (!wrap.value.equals(this.value)) {
                return false;
            }
            return wrap.timestamp == this.timestamp;
        }

        public int hashCode() {
            int result = this.action.hashCode();
            result = 31 * result + this.value.hashCode();
            result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
            return result;
        }

        public JsonObject toJson() {
            JsonObject ret = new JsonObject();
            ret.addProperty("action", this.action);
            if (this.value != null && !this.value.isEmpty()) {
                ret.addProperty("value", this.value);
            }
            ret.addProperty("timestamp_millis", (Number)this.timestamp);
            return ret;
        }
    }

    public static @interface Status {
    }
}

