/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren.network;

import androidx.annotation.NonNull;
import com.vungle.warren.network.VungleApi;
import com.vungle.warren.network.VungleApiImpl;
import java.util.List;
import okhttp3.Call;
import okhttp3.HttpUrl;

public class APIFactory {
    private static final String TAG = APIFactory.class.getSimpleName();
    private Call.Factory okHttpClient;
    private HttpUrl baseUrl;

    public APIFactory(@NonNull Call.Factory callFactory, @NonNull String baseUrl) {
        this.baseUrl = HttpUrl.get((String)baseUrl);
        this.okHttpClient = callFactory;
        List pathSegments = this.baseUrl.pathSegments();
        if (!"".equals(pathSegments.get(pathSegments.size() - 1))) {
            throw new IllegalArgumentException("baseUrl must end in /: " + baseUrl);
        }
    }

    @NonNull
    public VungleApi createAPI() {
        return new VungleApiImpl(this.baseUrl, this.okHttpClient);
    }
}

