/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren.network;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.vungle.warren.network.Response;

public class HttpException
extends RuntimeException {
    private final int code;
    private final String message;
    private final transient Response<?> response;

    private static String getMessage(@NonNull Response<?> response) {
        return "HTTP " + response.code() + " " + response.message();
    }

    public HttpException(Response<?> response) {
        super(HttpException.getMessage(response));
        this.code = response.code();
        this.message = response.message();
        this.response = response;
    }

    public int code() {
        return this.code;
    }

    public String message() {
        return this.message;
    }

    @Nullable
    public Response<?> response() {
        return this.response;
    }
}

