/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren.network;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.gson.JsonObject;
import com.vungle.warren.network.Call;
import com.vungle.warren.network.OkHttpCall;
import com.vungle.warren.network.VungleApi;
import com.vungle.warren.network.converters.Converter;
import com.vungle.warren.network.converters.EmptyResponseConverter;
import com.vungle.warren.network.converters.JsonConverter;
import java.util.Map;
import okhttp3.Call;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;

public class VungleApiImpl
implements VungleApi {
    private static final String CONFIG = "config";
    private static final Converter<ResponseBody, JsonObject> jsonConverter = new JsonConverter();
    private static final Converter<ResponseBody, Void> emptyResponseConverter = new EmptyResponseConverter();
    @VisibleForTesting
    HttpUrl baseUrl;
    @VisibleForTesting
    Call.Factory okHttpClient;

    public VungleApiImpl(@NonNull HttpUrl baseUrl, @NonNull Call.Factory okHttpClient) {
        this.baseUrl = baseUrl;
        this.okHttpClient = okHttpClient;
    }

    @Override
    public Call<JsonObject> config(String ua, JsonObject body) {
        return this.createNewPostCall(ua, this.baseUrl.toString() + CONFIG, body);
    }

    @Override
    public Call<JsonObject> reportNew(String ua, String path, Map<String, String> query) {
        return this.createNewGetCall(ua, path, query, jsonConverter);
    }

    @Override
    public Call<JsonObject> ads(String ua, String path, JsonObject body) {
        return this.createNewPostCall(ua, path, body);
    }

    @Override
    public Call<JsonObject> willPlayAd(String ua, String path, JsonObject body) {
        return this.createNewPostCall(ua, path, body);
    }

    @Override
    public Call<JsonObject> ri(String ua, String path, JsonObject body) {
        return this.createNewPostCall(ua, path, body);
    }

    @Override
    public Call<JsonObject> reportAd(String ua, String path, JsonObject body) {
        return this.createNewPostCall(ua, path, body);
    }

    @Override
    public Call<JsonObject> sendLog(String ua, String path, JsonObject body) {
        return this.createNewPostCall(ua, path, body);
    }

    @Override
    public Call<Void> pingTPAT(String ua, String url) {
        return this.createNewGetCall(ua, url, null, emptyResponseConverter);
    }

    @Override
    public Call<JsonObject> cacheBust(String ua, String path, JsonObject body) {
        return this.createNewPostCall(ua, path, body);
    }

    @Override
    public Call<JsonObject> bustAnalytics(String ua, String path, JsonObject body) {
        return this.createNewPostCall(ua, path, body);
    }

    private Call<JsonObject> createNewPostCall(String ua, @NonNull String path, JsonObject requestObj) {
        String requestBody = "";
        if (requestObj != null) {
            requestBody = requestObj.toString();
        }
        Request request = this.defaultBuilder(ua, path).post(RequestBody.create(null, (String)requestBody)).build();
        return new OkHttpCall<JsonObject>(this.okHttpClient.newCall(request), jsonConverter);
    }

    private <T> Call<T> createNewGetCall(String ua, @NonNull String path, @Nullable Map<String, String> query, Converter<ResponseBody, T> converter) {
        HttpUrl.Builder urlBuilder = HttpUrl.get((String)path).newBuilder();
        if (query != null) {
            for (Map.Entry<String, String> q : query.entrySet()) {
                urlBuilder.addQueryParameter(q.getKey(), q.getValue());
            }
        }
        Request request = this.defaultBuilder(ua, urlBuilder.build().toString()).get().build();
        return new OkHttpCall<T>(this.okHttpClient.newCall(request), converter);
    }

    @NonNull
    private Request.Builder defaultBuilder(@NonNull String ua, @NonNull String path) {
        return new Request.Builder().url(path).addHeader("User-Agent", ua).addHeader("Vungle-Version", "5.9.0").addHeader("Content-Type", "application/json");
    }
}

