/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren.persistence;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Environment;
import android.os.FileObserver;
import android.os.StatFs;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.vungle.warren.VungleLogger;
import com.vungle.warren.persistence.FilePreferences;
import com.vungle.warren.utility.FileUtility;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CacheManager {
    private static final String TAG = CacheManager.class.getSimpleName();
    private static final String PATH_ID = "cache_path";
    private static final String PATH_IDS = "cache_paths";
    private static final String VUNGLE_DIR = "vungle_cache";
    private final Context context;
    private final FilePreferences prefs;
    private final Set<Listener> listeners = new HashSet<Listener>();
    private File current;
    private final List<File> old = new ArrayList<File>();
    private boolean changed;
    private final List<FileObserver> observers = new ArrayList<FileObserver>();
    static final long UNKNOWN_SIZE = -1L;

    public CacheManager(@NonNull Context context, @NonNull FilePreferences prefs) {
        this.context = context;
        this.prefs = prefs;
        this.prefs.addSharedPrefsKey(PATH_ID, PATH_IDS).apply();
    }

    @SuppressLint(value={"NewApi"})
    private synchronized void selectFileDest() {
        File parent;
        if (this.current == null) {
            String path = this.prefs.getString(PATH_ID, null);
            this.current = path != null ? new File(path) : null;
        }
        File external = this.context.getExternalFilesDir(null);
        File internal = this.context.getFilesDir();
        boolean canUseExternal = Environment.getExternalStorageState().equals("mounted") && external != null;
        ArrayList<File> candidates = new ArrayList<File>();
        if (canUseExternal && (parent = external.getParentFile()) != null) {
            candidates.add(new File(parent, "no_backup"));
        }
        candidates.add(this.context.getNoBackupFilesDir());
        if (canUseExternal) {
            candidates.add(external);
        }
        candidates.add(internal);
        File result = null;
        boolean created = false;
        for (File parent2 : candidates) {
            boolean success;
            File dir = new File(parent2, VUNGLE_DIR);
            CacheManager.deleteIfFile(dir);
            if (dir.exists()) {
                success = dir.isDirectory() && dir.canWrite();
            } else {
                created = success = dir.mkdirs();
            }
            if (!success) continue;
            result = dir;
            break;
        }
        File obsoleted = this.context.getCacheDir();
        HashSet<String> known = this.prefs.getStringSet(PATH_IDS, new HashSet<String>());
        if (result != null) {
            known.add(result.getPath());
        }
        known.add(obsoleted.getPath());
        this.prefs.put(PATH_IDS, known).apply();
        this.old.clear();
        for (String path : known) {
            if (result != null && result.getPath().equals(path)) continue;
            this.old.add(new File(path));
        }
        if (created || result != null && !result.equals(this.current) || this.current != null && !this.current.equals(result)) {
            this.current = result;
            if (this.current != null) {
                this.prefs.put(PATH_ID, this.current.getPath()).apply();
            }
            for (Listener l : this.listeners) {
                l.onCacheChanged();
            }
            this.changed = true;
            for (File dir : this.old) {
                if (dir.equals(obsoleted)) continue;
                try {
                    FileUtility.delete(dir);
                }
                catch (IOException e2) {
                    VungleLogger.error(true, TAG, "CacheManager", "Can't remove old cache:" + dir.getPath());
                }
            }
        }
        this.observeDirectory(external);
    }

    private void check() {
        if (!(this.current != null && this.current.exists() && this.current.isDirectory() && this.current.canWrite())) {
            this.selectFileDest();
        }
    }

    private synchronized void observeDirectory(File root) {
        if (root == null) {
            return;
        }
        this.observers.clear();
        this.observers.add(new FileObserver(root.getPath(), 1024){

            public void onEvent(int event, @Nullable String path) {
                this.stopWatching();
                CacheManager.this.selectFileDest();
            }
        });
        while (root.getParent() != null) {
            final String dirName = root.getName();
            this.observers.add(new FileObserver(root.getParent(), 256){

                public void onEvent(int event, @Nullable String path) {
                    this.stopWatching();
                    if (dirName.equals(path)) {
                        CacheManager.this.selectFileDest();
                    }
                }
            });
            root = root.getParentFile();
        }
        for (FileObserver observer : this.observers) {
            try {
                observer.startWatching();
            }
            catch (Exception e2) {
                VungleLogger.warn(true, TAG, "ExceptionContext", Log.getStackTraceString((Throwable)e2));
            }
        }
    }

    @Nullable
    public synchronized File getCache() {
        this.check();
        return this.current;
    }

    public synchronized List<File> getOldCaches() {
        this.check();
        return this.old;
    }

    public synchronized void addListener(Listener listener) {
        this.check();
        this.listeners.add(listener);
        if (this.changed) {
            listener.onCacheChanged();
        }
    }

    public synchronized void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    public long getBytesAvailable() {
        return this.getBytesAvailable(1);
    }

    @SuppressLint(value={"NewApi"})
    private long getBytesAvailable(int retry) {
        StatFs stats;
        long bytesAvailable;
        block4: {
            File dir = this.getCache();
            bytesAvailable = -1L;
            if (dir == null) {
                return bytesAvailable;
            }
            stats = null;
            try {
                stats = new StatFs(dir.getPath());
            }
            catch (IllegalArgumentException e2) {
                Log.w((String)TAG, (String)"Failed to get available bytes", (Throwable)e2);
                if (retry <= 0) break block4;
                return this.getBytesAvailable(retry - 1);
            }
        }
        if (stats != null) {
            bytesAvailable = stats.getBlockSizeLong() * stats.getAvailableBlocksLong();
        }
        return bytesAvailable;
    }

    private static void deleteIfFile(File dir) {
        if (dir.exists() && dir.isFile()) {
            FileUtility.deleteAndLogIfFailed(dir);
        }
    }

    public static interface Listener {
        public void onCacheChanged();
    }
}

