/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren.persistence;

import android.annotation.SuppressLint;
import android.content.ContentValues;
import android.content.Context;
import android.content.ContextWrapper;
import android.database.Cursor;
import android.database.DatabaseErrorHandler;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import androidx.annotation.NonNull;
import com.vungle.warren.VungleLogger;
import com.vungle.warren.persistence.Query;
import com.vungle.warren.utility.FileUtility;
import java.io.File;
import java.io.IOException;

public class DatabaseHelper
extends SQLiteOpenHelper {
    public static final String TAG = DatabaseHelper.class.getSimpleName();
    public static final String DB_NAME = "vungle_db";
    private final DatabaseFactory databaseFactory;

    public DatabaseHelper(@NonNull Context context, int version, @NonNull DatabaseFactory databaseFactory) {
        super((Context)new NoBackupDatabaseWrapperContext(context.getApplicationContext()), DB_NAME, null, version);
        this.databaseFactory = databaseFactory;
    }

    public synchronized void onCreate(SQLiteDatabase db) {
        this.databaseFactory.create(db);
    }

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        this.databaseFactory.onUpgrade(db, oldVersion, newVersion);
    }

    public void onDowngrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        this.databaseFactory.onDowngrade(db, oldVersion, newVersion);
    }

    public long insertWithConflict(String table, ContentValues values, int strategy) throws DBException {
        try {
            return this.loadWritableDB().insertWithOnConflict(table, null, values, strategy);
        }
        catch (SQLException e2) {
            throw new DBException(e2.getMessage());
        }
    }

    public long update(Query query, ContentValues values) throws DBException {
        try {
            return this.loadWritableDB().update(query.tableName, values, query.selection, query.args);
        }
        catch (SQLException e2) {
            throw new DBException(e2.getMessage());
        }
    }

    public Cursor query(Query query) {
        return this.loadWritableDB().query(query.tableName, query.columns, query.selection, query.args, query.groupBy, query.having, query.orderBy, query.limit);
    }

    public Cursor queryRaw(String sql, String[] selectionArgs) {
        return this.loadWritableDB().rawQuery(sql, selectionArgs);
    }

    public void delete(Query query) throws DBException {
        try {
            this.loadWritableDB().delete(query.tableName, query.selection, query.args);
        }
        catch (SQLException e2) {
            throw new DBException(e2.getMessage());
        }
    }

    public void execSQL(String s) throws DBException {
        try {
            this.loadWritableDB().execSQL(s);
        }
        catch (SQLException e2) {
            throw new DBException(e2.getMessage());
        }
    }

    public synchronized void dropDb() {
        this.databaseFactory.deleteData(this.loadWritableDB());
        this.close();
        this.onCreate(this.loadWritableDB());
    }

    public void init() {
        this.loadWritableDB();
    }

    private synchronized SQLiteDatabase loadWritableDB() {
        return this.getWritableDatabase();
    }

    private static class NoBackupDatabaseWrapperContext
    extends ContextWrapper {
        public NoBackupDatabaseWrapperContext(Context context) {
            super(context);
        }

        @SuppressLint(value={"NewApi"})
        public File getDatabasePath(String name) {
            File oldDb = super.getDatabasePath(name);
            File newDb = new File(this.getApplicationContext().getNoBackupFilesDir(), name);
            try {
                FileUtility.delete(new File(oldDb.getPath()));
                FileUtility.delete(new File(oldDb.getPath() + "-journal"));
            }
            catch (IOException e2) {
                VungleLogger.error(true, TAG, "DatabaseHelper", "Failed to delete old db/-journal");
            }
            return newDb;
        }

        @SuppressLint(value={"NewApi"})
        private int getFlags(int mode) {
            int flags = 0x10000000;
            flags |= (mode & 8) != 0 ? 0x20000000 : 0;
            return flags |= (mode & 0x10) != 0 ? 16 : 0;
        }

        public SQLiteDatabase openOrCreateDatabase(String name, int mode, SQLiteDatabase.CursorFactory factory) {
            return SQLiteDatabase.openDatabase((String)this.getDatabasePath(name).getPath(), (SQLiteDatabase.CursorFactory)factory, (int)this.getFlags(mode));
        }

        public SQLiteDatabase openOrCreateDatabase(String name, int mode, SQLiteDatabase.CursorFactory factory, DatabaseErrorHandler errorHandler) {
            return SQLiteDatabase.openDatabase((String)this.getDatabasePath(name).getPath(), (SQLiteDatabase.CursorFactory)factory, (int)this.getFlags(mode), (DatabaseErrorHandler)errorHandler);
        }
    }

    public static interface DatabaseFactory {
        public void onUpgrade(SQLiteDatabase var1, int var2, int var3);

        public void create(SQLiteDatabase var1);

        public void deleteData(SQLiteDatabase var1);

        public void onDowngrade(SQLiteDatabase var1, int var2, int var3);
    }

    public static class DBException
    extends Exception {
        public DBException(String message) {
            super(message);
        }
    }
}

